/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.k2.codeInsight;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.TrafficLightRendererContributor;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.kotlin.jupyter.k2.scriptingSupport.NotebookScriptConfigurationsManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.storage.HeavyProcessLatch;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kotlin/jupyter/k2/codeInsight/NotebookTrafficLightContributor;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRendererContributor;", "<init>", "()V", "createRenderer", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "UpdateTrafficLightRenderer", "intellij.kotlin.jupyter.k2"})
public final class NotebookTrafficLightContributor
implements TrafficLightRendererContributor {
    @Nullable
    public TrafficLightRenderer createRenderer(@NotNull Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null || !IsKotlinNotebookKt.isKotlinNotebook(editor.getVirtualFile())) {
            return null;
        }
        VirtualFile virtualFile = editor.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        BackedNotebookVirtualFile backedNotebookVirtualFile = UtilKt.toBackedNotebookFile(virtualFile);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile2 = backedNotebookVirtualFile;
        return new UpdateTrafficLightRenderer(project, editor, backedNotebookVirtualFile2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kotlin/jupyter/k2/codeInsight/NotebookTrafficLightContributor$UpdateTrafficLightRenderer;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "getDaemonCodeAnalyzerStatus", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DaemonCodeAnalyzerStatus;", "severityRegistrar", "Lcom/intellij/codeInsight/daemon/impl/SeverityRegistrar;", "intellij.kotlin.jupyter.k2"})
    public static final class UpdateTrafficLightRenderer
    extends TrafficLightRenderer {
        @NotNull
        private final BackedNotebookVirtualFile notebookFile;

        public UpdateTrafficLightRenderer(@NotNull Project project, @NotNull Editor editor, @NotNull BackedNotebookVirtualFile notebookFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
            super(project, editor);
            this.notebookFile = notebookFile;
        }

        @NotNull
        protected TrafficLightRenderer.DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
            Intrinsics.checkNotNullParameter((Object)severityRegistrar, (String)"severityRegistrar");
            TrafficLightRenderer.DaemonCodeAnalyzerStatus status = super.getDaemonCodeAnalyzerStatus(severityRegistrar);
            if (NotebookScriptConfigurationsManager.Companion.getInstance(this.getProject()).getCache().get(this.notebookFile.getFile()) == null) {
                status.reasonWhySuspended = KotlinNotebookBundle.message("kotlin.jupyter.highlighting.traffic.configuration.empty", new Object[0]);
                status.heavyProcessType = HeavyProcessLatch.Type.Processing;
            } else if (JupyterCompilerService.Companion.getForFile(this.getProject(), this.notebookFile).getNeedsConfigurationUpdate()) {
                status.reasonWhySuspended = KotlinNotebookBundle.message("kotlin.jupyter.highlighting.traffic.configuration.update", new Object[0]);
                status.heavyProcessType = HeavyProcessLatch.Type.Syncing;
            }
            return status;
        }
    }
}

