/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.util;

import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.util.KotlinNotebookLogging;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0004\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\u0012\u0010\u000b\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\f\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\f\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\u001a+\u0010\f\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0012\u001a\u0012\u0010\f\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a,\u0010\u0013\u001a\u00020\u0005*\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\t0\u0014\u001a+\u0010\u0015\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0012\u001a\u0018\u0010\u0016\u001a\u00020\u0005*\u00020\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014\u001a\u0018\u0010\u0018\u001a\u00020\u0005*\u00020\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014\u001a\u001a\u0010\u0019\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0011\u001a%\u0010\u001b\u001a\u00020\u0005*\u00020\u00012\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u001d\u00a2\u0006\u0002\b\u001eH\u0002\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001f"}, d2={"kotlinNotebookLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "getKotlinNotebookLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logListInfo", "", "message", "", "list", "", "", "warnUnderDebug", "errorUnderDebug", "throwable", "", "attachments", "", "Lcom/intellij/openapi/diagnostic/Attachment;", "(Lcom/intellij/openapi/diagnostic/Logger;Ljava/lang/String;[Lcom/intellij/openapi/diagnostic/Attachment;)V", "debugWithAttachments", "Lkotlin/Function0;", "errorWithAttachments", "warnInTests", "messageFactory", "debugInTests", "reportErrorTestAware", "attachment", "doUnderDebug", "action", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nlogging.kt\nKotlin\n*S Kotlin\n*F\n+ 1 logging.kt\ncom/intellij/kotlin/jupyter/core/util/LoggingKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,81:1\n37#2:82\n36#2,3:83\n*S KotlinDebug\n*F\n+ 1 logging.kt\ncom/intellij/kotlin/jupyter/core/util/LoggingKt\n*L\n45#1:82\n45#1:83,3\n*E\n"})
public final class LoggingKt {
    @NotNull
    public static final Logger getKotlinNotebookLogger() {
        return KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(KotlinNotebookLogging.class));
    }

    public static final void logListInfo(@NotNull Logger $this$logListInfo, @NotNull String message, @NotNull List<? extends Object> list) {
        Intrinsics.checkNotNullParameter((Object)$this$logListInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        $this$logListInfo.info(message + ". Listing " + list.size() + " elements:" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", (CharSequence)"\n", null, (int)0, null, null, (int)60, null));
    }

    public static final void warnUnderDebug(@NotNull Logger $this$warnUnderDebug, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$warnUnderDebug, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LoggingKt.doUnderDebug($this$warnUnderDebug, (Function1<? super Logger, Unit>)((Function1)arg_0 -> LoggingKt.warnUnderDebug$lambda$0(message, arg_0)));
    }

    public static final void errorUnderDebug(@NotNull Logger $this$errorUnderDebug, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$errorUnderDebug, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LoggingKt.doUnderDebug($this$errorUnderDebug, (Function1<? super Logger, Unit>)((Function1)arg_0 -> LoggingKt.errorUnderDebug$lambda$1(message, arg_0)));
    }

    public static final void errorUnderDebug(@NotNull Logger $this$errorUnderDebug, @NotNull String message, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)$this$errorUnderDebug, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        LoggingKt.doUnderDebug($this$errorUnderDebug, (Function1<? super Logger, Unit>)((Function1)arg_0 -> LoggingKt.errorUnderDebug$lambda$2(message, throwable, arg_0)));
    }

    public static final void errorUnderDebug(@NotNull Logger $this$errorUnderDebug, @NotNull String message, Attachment ... attachments) {
        Intrinsics.checkNotNullParameter((Object)$this$errorUnderDebug, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)attachments, (String)"attachments");
        LoggingKt.doUnderDebug($this$errorUnderDebug, (Function1<? super Logger, Unit>)((Function1)arg_0 -> LoggingKt.errorUnderDebug$lambda$3(message, attachments, arg_0)));
    }

    public static final void errorUnderDebug(@NotNull Logger $this$errorUnderDebug, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)$this$errorUnderDebug, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        LoggingKt.doUnderDebug($this$errorUnderDebug, (Function1<? super Logger, Unit>)((Function1)arg_0 -> LoggingKt.errorUnderDebug$lambda$4(throwable, arg_0)));
    }

    public static final void debugWithAttachments(@NotNull Logger $this$debugWithAttachments, @NotNull Function0<String> message, @NotNull Function0<? extends List<Attachment>> attachments) {
        Intrinsics.checkNotNullParameter((Object)$this$debugWithAttachments, (String)"<this>");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        if (!$this$debugWithAttachments.isDebugEnabled()) {
            return;
        }
        String messageValue = (String)message.invoke();
        Collection $this$toTypedArray$iv = (Collection)attachments.invoke();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Attachment[] attachmentArray = thisCollection$iv.toArray(new Attachment[0]);
        $this$debugWithAttachments.debug(messageValue, (Throwable)new RuntimeExceptionWithAttachments(messageValue, Arrays.copyOf(attachmentArray, attachmentArray.length)));
    }

    public static final void errorWithAttachments(@NotNull Logger $this$errorWithAttachments, @NotNull String message, Attachment ... attachments) {
        Intrinsics.checkNotNullParameter((Object)$this$errorWithAttachments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)attachments, (String)"attachments");
        $this$errorWithAttachments.error(message, (Throwable)new RuntimeExceptionWithAttachments(message, Arrays.copyOf(attachments, attachments.length)));
    }

    public static final void warnInTests(@NotNull Logger $this$warnInTests, @NotNull Function0<String> messageFactory) {
        Intrinsics.checkNotNullParameter((Object)$this$warnInTests, (String)"<this>");
        Intrinsics.checkNotNullParameter(messageFactory, (String)"messageFactory");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            $this$warnInTests.warn((String)messageFactory.invoke());
        }
    }

    public static final void debugInTests(@NotNull Logger $this$debugInTests, @NotNull Function0<String> messageFactory) {
        Intrinsics.checkNotNullParameter((Object)$this$debugInTests, (String)"<this>");
        Intrinsics.checkNotNullParameter(messageFactory, (String)"messageFactory");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            $this$debugInTests.debug((String)messageFactory.invoke());
        }
    }

    public static final void reportErrorTestAware(@NotNull Logger $this$reportErrorTestAware, @NotNull String message, @NotNull Attachment attachment) {
        Intrinsics.checkNotNullParameter((Object)$this$reportErrorTestAware, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        KFunction logReference2 = ApplicationManager.getApplication().isUnitTestMode() ? (KFunction)new Function2<String, Attachment[], Unit>((Object)$this$reportErrorTestAware){

            public final void invoke(String p0, Attachment[] p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                LoggingKt.errorWithAttachments((Logger)this.receiver, p0, p1);
            }
        } : (KFunction)new Function2<String, Attachment[], Unit>((Object)$this$reportErrorTestAware){

            public final void invoke(String p0, Attachment[] p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                LoggingKt.errorUnderDebug((Logger)this.receiver, p0, p1);
            }
        };
        Attachment[] attachmentArray = new Attachment[]{attachment};
        ((Function2)logReference2).invoke((Object)message, (Object)attachmentArray);
    }

    private static final void doUnderDebug(Logger $this$doUnderDebug, Function1<? super Logger, Unit> action) {
        if ($this$doUnderDebug.isDebugEnabled()) {
            action.invoke((Object)$this$doUnderDebug);
        }
    }

    private static final Unit warnUnderDebug$lambda$0(String $message, Logger $this$doUnderDebug) {
        Intrinsics.checkNotNullParameter((Object)$this$doUnderDebug, (String)"$this$doUnderDebug");
        $this$doUnderDebug.warn($message);
        return Unit.INSTANCE;
    }

    private static final Unit errorUnderDebug$lambda$1(String $message, Logger $this$doUnderDebug) {
        Intrinsics.checkNotNullParameter((Object)$this$doUnderDebug, (String)"$this$doUnderDebug");
        $this$doUnderDebug.error($message);
        return Unit.INSTANCE;
    }

    private static final Unit errorUnderDebug$lambda$2(String $message, Throwable $throwable, Logger $this$doUnderDebug) {
        Intrinsics.checkNotNullParameter((Object)$this$doUnderDebug, (String)"$this$doUnderDebug");
        $this$doUnderDebug.error($message, $throwable);
        return Unit.INSTANCE;
    }

    private static final Unit errorUnderDebug$lambda$3(String $message, Attachment[] $attachments, Logger $this$doUnderDebug) {
        Intrinsics.checkNotNullParameter((Object)$this$doUnderDebug, (String)"$this$doUnderDebug");
        LoggingKt.errorWithAttachments($this$doUnderDebug, $message, Arrays.copyOf($attachments, $attachments.length));
        return Unit.INSTANCE;
    }

    private static final Unit errorUnderDebug$lambda$4(Throwable $throwable, Logger $this$doUnderDebug) {
        Intrinsics.checkNotNullParameter((Object)$this$doUnderDebug, (String)"$this$doUnderDebug");
        $this$doUnderDebug.error($throwable);
        return Unit.INSTANCE;
    }
}

