/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.execution;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterExecutionCallbackAdapter;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageChannel;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputsBase;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.NotebookHighlightingService;
import com.intellij.kotlin.jupyter.core.jupyter.execution.KotlinNotebookCellExecutionCallbackFactoryKt;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.statistics.fus.KotlinNotebookFeatureUsagesCollector;
import com.intellij.kotlin.jupyter.core.util.JsonKt;
import com.intellij.kotlin.jupyter.core.util.KotlinNotebookPluginScope;
import com.intellij.kotlin.jupyter.core.util.LoggingKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.repl.EvaluatedSnippetMetadata;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/execution/KotlinNotebookCellExecutionCallback;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterExecutionCallbackAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "psiCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "index", "", "executionStartedMs", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;IJ)V", "channel", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageChannel;", "getChannel", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageChannel;", "finalizeCallback", "Lkotlin/Function0;", "", "getFinalizeCallback", "()Lkotlin/jvm/functions/Function0;", "setFinalizeCallback", "(Lkotlin/jvm/functions/Function0;)V", "expire", "onExecuteReply", "message", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "onExecuteReplyImpl", "onUpdateOutput", "unregisterCallback", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookCellExecutionCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookCellExecutionCallback.kt\ncom/intellij/kotlin/jupyter/core/jupyter/execution/KotlinNotebookCellExecutionCallback\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 json.kt\ncom/intellij/kotlin/jupyter/core/util/JsonKt\n+ 4 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 5 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,115:1\n29#2,2:116\n31#2:122\n67#3,3:118\n335#4:121\n13#5:123\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookCellExecutionCallback.kt\ncom/intellij/kotlin/jupyter/core/jupyter/execution/KotlinNotebookCellExecutionCallback\n*L\n70#1:116,2\n70#1:122\n71#1:118,3\n71#1:121\n112#1:123\n*E\n"})
public final class KotlinNotebookCellExecutionCallback
extends JupyterExecutionCallbackAdapter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile virtualFile;
    @Nullable
    private final JupyterPsiCell psiCell;
    private final int index;
    private final long executionStartedMs;
    @NotNull
    private Function0<Unit> finalizeCallback;
    @NotNull
    private static final Logger LOG;

    public KotlinNotebookCellExecutionCallback(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile, @Nullable JupyterPsiCell psiCell, int index, long executionStartedMs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.project = project;
        this.virtualFile = virtualFile;
        this.psiCell = psiCell;
        this.index = index;
        this.executionStartedMs = executionStartedMs;
        this.finalizeCallback = KotlinNotebookCellExecutionCallback::finalizeCallback$lambda$0;
    }

    @NotNull
    public JupyterMessageChannel getChannel() {
        return JupyterMessageChannel.ANY;
    }

    @NotNull
    public Function0<Unit> getFinalizeCallback() {
        return this.finalizeCallback;
    }

    public void setFinalizeCallback(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.finalizeCallback = function0;
    }

    public void expire() {
        this.unregisterCallback();
    }

    public void onExecuteReply(@NotNull JupyterMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        BuildersKt.async$default((CoroutineScope)KotlinNotebookPluginScope.Companion.getForProject(this.project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, message, null){
            int label;
            final /* synthetic */ KotlinNotebookCellExecutionCallback this$0;
            final /* synthetic */ JupyterMessage $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            KotlinNotebookCellExecutionCallback.access$onExecuteReplyImpl(this.this$0, this.$message);
                        }
                        catch (Throwable e) {
                            if (e instanceof ProcessCanceledException) {
                                throw e;
                            }
                            KotlinNotebookCellExecutionCallback.access$getLOG$cp().warn("Kotlin execution callback failed", e);
                        }
                        finally {
                            this.this$0.getFinalizeCallback().invoke();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void onExecuteReplyImpl(JupyterMessage message) {
        EvaluatedSnippetMetadata evaluatedSnippetMetadata;
        long executionFinishedMs = System.currentTimeMillis();
        JsonNode metadataObject = (JsonNode)message.getMetadata("eval_metadata");
        boolean bl = false;
        Object snippetMetadata = null;
        if (metadataObject != null) {
            Object object;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl2 = false;
            JsonNode $this$deserialize$iv = metadataObject;
            boolean $i$f$deserialize = false;
            JsonElement json$iv = JsonKt.toKotlinSerializationJson($this$deserialize$iv);
            if (json$iv instanceof JsonNull) {
                object = null;
            } else {
                void $this$decodeFromJsonElement$iv$iv;
                Json json = JsonKt.getJsonConfig();
                JsonElement json$iv$iv = json$iv;
                boolean $i$f$decodeFromJsonElement = false;
                SerializersModule serializersModule = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                KType kType = Reflection.nullableTypeOf(EvaluatedSnippetMetadata.class);
                MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                object = $this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), json$iv$iv);
            }
            snippetMetadata = object;
            long deserializationTime = System.currentTimeMillis() - start$iv;
            String string = "Cell executed. Deserialization took " + deserializationTime + " ms. New classpath received";
            EvaluatedSnippetMetadata evaluatedSnippetMetadata2 = (EvaluatedSnippetMetadata)snippetMetadata;
            List list = evaluatedSnippetMetadata2 != null ? evaluatedSnippetMetadata2.getNewClasspath() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            LoggingKt.logListInfo(LOG, string, list);
        } else {
            LoggingKt.debugInTests(LOG, (Function0<String>)((Function0)() -> KotlinNotebookCellExecutionCallback.onExecuteReplyImpl$lambda$3$lambda$2(message)));
        }
        if ((evaluatedSnippetMetadata = (EvaluatedSnippetMetadata)snippetMetadata) == null) {
            evaluatedSnippetMetadata = EvaluatedSnippetMetadata.Companion.getEMPTY();
        }
        KotlinNotebookFeatureUsagesCollector.Companion.registerCellExecuted(this.project, message, executionFinishedMs - this.executionStartedMs, evaluatedSnippetMetadata);
        EvaluatedSnippetMetadata snippetMetadata2 = (EvaluatedSnippetMetadata)snippetMetadata;
        this.unregisterCallback();
        if (snippetMetadata2 != null) {
            JupyterCompilerService.Companion.getForFile(this.project, this.virtualFile).addCompiledSnippet(snippetMetadata2, this.psiCell);
        } else {
            NotebookHighlightingService.Companion.getForFile(this.project, this.virtualFile).getDataController().getNotebookDocumentStructureNontrivialChanged().compareAndSet(false, true);
        }
    }

    public void onUpdateOutput(@NotNull JupyterMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JupyterOutput jupyterOutput = JupyterOutputsBase.Companion.fromMessage(message);
        if (jupyterOutput == null) {
            return;
        }
        JupyterOutput output = jupyterOutput;
        KotlinNotebookFeatureUsagesCollector.Companion.registerOutputUpdated(this.project, output);
    }

    private final void unregisterCallback() {
        KotlinNotebookCellExecutionCallbackFactoryKt.getKotlinNotebookCellExecutionCallbackFactory().unregisterCallback(this.project, this.virtualFile, this.index);
    }

    private static final Unit finalizeCallback$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final String onExecuteReplyImpl$lambda$3$lambda$2(JupyterMessage $message) {
        return "No snippet metadata found for message " + $message;
    }

    public static final /* synthetic */ void access$onExecuteReplyImpl(KotlinNotebookCellExecutionCallback $this, JupyterMessage message) {
        $this.onExecuteReplyImpl(message);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/execution/KotlinNotebookCellExecutionCallback$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

