/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.images.ImagesBundle;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.options.impl.ImagesConfigurable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/images/actions/EditExternallyAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.images"})
@SourceDebugExtension(value={"SMAP\nEditExternallyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditExternallyAction.kt\norg/intellij/images/actions/EditExternallyAction\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,91:1\n216#2,2:92\n*S KotlinDebug\n*F\n+ 1 EditExternallyAction.kt\norg/intellij/images/actions/EditExternallyAction\n*L\n36#1:92,2\n*E\n"})
public final class EditExternallyAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile imageFile = virtualFile;
        String executablePath = null;
        String string = PropertiesComponent.getInstance().getValue("Images.ExternalEditorPath", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        executablePath = string;
        if (!StringUtil.isEmpty((String)executablePath)) {
            String path;
            Object object;
            Map map = EnvironmentUtil.getEnvironmentMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironmentMap(...)");
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                object = element$iv;
                boolean bl = false;
                String varName = (String)object.getKey();
                String varValue = (String)object.getValue();
                String string2 = SystemInfo.isWindows ? StringUtil.replace((String)executablePath, (String)("%" + varName + "%"), (String)varValue, (boolean)true) : StringUtil.replace((String)executablePath, (String)("${" + varName + "}"), (String)varValue, (boolean)false);
                Intrinsics.checkNotNull((Object)string2);
                executablePath = string2;
            }
            String string3 = FileUtil.toSystemDependentName((String)executablePath);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemDependentName(...)");
            executablePath = string3;
            File executable = new File(executablePath);
            GeneralCommandLine commandLine = new GeneralCommandLine();
            String string4 = path = executable.exists() ? executable.getAbsolutePath() : executablePath;
            if (SystemInfo.isMac) {
                commandLine.setExePath(ExecUtil.getOpenCommandPath());
                commandLine.addParameter("-a");
                commandLine.addParameter(path);
            } else {
                commandLine.setExePath(path);
            }
            ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
            if (imageFile.isInLocalFileSystem() && typeManager.isImage(imageFile)) {
                commandLine.addParameter(VfsUtilCore.virtualToIoFile((VirtualFile)imageFile).getAbsolutePath());
            }
            commandLine.setWorkDirectory(new File(executablePath).getParentFile());
            try {
                object = commandLine.createProcess();
                Intrinsics.checkNotNull((Object)object);
            }
            catch (ExecutionException ex) {
                Messages.showErrorDialog((Project)e.getProject(), (String)ex.getLocalizedMessage(), (String)ImagesBundle.message("error.title.launching.external.editor", new Object[0]));
                ImagesConfigurable.show(e.getProject());
                object = Unit.INSTANCE;
            }
        } else {
            try {
                Desktop.getDesktop().open(imageFile.toNioPath().toFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean bl = enabled = file != null && ImageFileTypeManager.getInstance().isImage(file);
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(enabled);
        }
        e.getPresentation().setEnabled(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

