/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.codeInspection;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class WrongPropertyKeyValueDelimiterInspection
extends PropertiesInspectionBase
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            WrongPropertyKeyValueDelimiterInspection.$$$reportNull$$$0(0);
        }
        if (!(holder.getFile() instanceof PropertiesFileImpl)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                WrongPropertyKeyValueDelimiterInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        PropertiesCodeStyleSettings codeStyleSettings = PropertiesCodeStyleSettings.getInstance((Project)holder.getProject());
        final char codeStyleKeyValueDelimiter = codeStyleSettings.getDelimiter();
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                char delimiter;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PropertyImpl && (delimiter = ((PropertyImpl)element).getKeyValueDelimiter()) != codeStyleKeyValueDelimiter) {
                    holder.registerProblem(element, PropertiesBundle.message((String)"wrong.property.key.value.delimiter.inspection.display.name", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceKeyValueDelimiterQuickFix(element)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/codeInspection/WrongPropertyKeyValueDelimiterInspection$1", "visitElement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/codeInspection/WrongPropertyKeyValueDelimiterInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/codeInspection/WrongPropertyKeyValueDelimiterInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class ReplaceKeyValueDelimiterQuickFix
    extends LocalQuickFixOnPsiElement
    implements HighPriorityAction {
        ReplaceKeyValueDelimiterQuickFix(@NotNull PsiElement element) {
            if (element == null) {
                ReplaceKeyValueDelimiterQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ReplaceKeyValueDelimiterQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement element, @NotNull PsiElement endElement) {
            if (project == null) {
                ReplaceKeyValueDelimiterQuickFix.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                ReplaceKeyValueDelimiterQuickFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                ReplaceKeyValueDelimiterQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                ReplaceKeyValueDelimiterQuickFix.$$$reportNull$$$0(5);
            }
            ((PropertyImpl)element).replaceKeyValueDelimiterWithDefault();
        }

        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message((String)"replace.key.value.delimiter.quick.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceKeyValueDelimiterQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/codeInspection/WrongPropertyKeyValueDelimiterInspection$ReplaceKeyValueDelimiterQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/codeInspection/WrongPropertyKeyValueDelimiterInspection$ReplaceKeyValueDelimiterQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 6 -> new IllegalStateException(string);
            };
        }
    }
}

