/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.breaks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.core.commons.time.TimeUtil;
import org.jetbrains.letsPlot.core.commons.time.interval.NiceTimeInterval;
import org.jetbrains.letsPlot.core.commons.time.interval.TimeInterval;
import org.jetbrains.letsPlot.core.commons.time.interval.YearInterval;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.BreaksHelperBase;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.DummyBreaksFormatterKt;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.LinearBreaksHelper;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.TimeScaleTickFormatterFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/DateTimeBreaksHelper;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/BreaksHelperBase;", "rangeStart", "", "rangeEnd", "count", "", "providedFormatter", "Lkotlin/Function1;", "", "", "minInterval", "Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval;", "(DDILkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/core/commons/time/interval/TimeInterval;)V", "breaks", "", "getBreaks", "()Ljava/util/List;", "formatter", "getFormatter", "()Lkotlin/jvm/functions/Function1;", "pattern", "getPattern", "()Ljava/lang/String;", "plot-base"})
public final class DateTimeBreaksHelper
extends BreaksHelperBase {
    @Nullable
    private final Function1<Object, String> providedFormatter;
    @NotNull
    private final List<Double> breaks;
    @NotNull
    private final Function1<Object, String> formatter;
    @NotNull
    private final String pattern;

    public DateTimeBreaksHelper(double rangeStart, double rangeEnd, int count, @Nullable Function1<Object, String> providedFormatter, @Nullable TimeInterval minInterval) {
        super(rangeStart, rangeEnd, count);
        Function1 function1;
        this.providedFormatter = providedFormatter;
        double step = this.getTargetStep();
        Ref.ObjectRef dateTimeFormatter2 = new Ref.ObjectRef();
        if (step < 1000.0) {
            TimeScaleTickFormatterFactory interval = new TimeScaleTickFormatterFactory(minInterval);
            dateTimeFormatter2.element = interval.getFormatter(step);
            this.pattern = interval.formatPattern$plot_base(step);
            this.breaks = new LinearBreaksHelper(rangeStart, rangeEnd, count, DummyBreaksFormatterKt.getDUMMY_FORMATTER(), StringFormat.ExponentFormat.Companion.getDEF_EXPONENT_FORMAT(), false, 32, null).getBreaks();
        } else {
            double start2 = this.getNormalStart();
            double end = this.getNormalEnd();
            List ticks = null;
            if (minInterval != null) {
                ticks = CollectionsKt.toMutableList((Collection)minInterval.range(start2, end));
            }
            if (ticks != null && ticks.size() <= count) {
                TimeInterval timeInterval = minInterval;
                Intrinsics.checkNotNull((Object)timeInterval);
                dateTimeFormatter2.element = timeInterval.getTickFormatter();
                this.pattern = minInterval.getTickFormatPattern();
            } else if (step > 3.1536E10) {
                int startYear;
                dateTimeFormatter2.element = YearInterval.Companion.getTICK_FORMATTER();
                this.pattern = "%Y";
                ticks = new ArrayList();
                DateTime startDateTime = TimeUtil.INSTANCE.asDateTimeUTC(start2);
                if (startDateTime.isAfter(TimeUtil.INSTANCE.yearStart(startYear = startDateTime.getYear()))) {
                    ++startYear;
                }
                int endYear = TimeUtil.INSTANCE.asDateTimeUTC(end).getYear();
                double d = startYear;
                double d2 = endYear;
                StringFormat.ExponentFormat exponentFormat = StringFormat.ExponentFormat.Companion.getDEF_EXPONENT_FORMAT();
                Function1<Object, String> function12 = DummyBreaksFormatterKt.getDUMMY_FORMATTER();
                LinearBreaksHelper helper2 = new LinearBreaksHelper(d, d2, count, function12, exponentFormat, false, 32, null);
                Iterator<Double> iterator2 = helper2.getBreaks().iterator();
                while (iterator2.hasNext()) {
                    double tickYear = ((Number)iterator2.next()).doubleValue();
                    DateTime tickDate = TimeUtil.INSTANCE.yearStart((int)Math.rint(tickYear));
                    ((ArrayList)ticks).add(Double.valueOf(TimeUtil.INSTANCE.asInstantUTC(tickDate)));
                }
            } else {
                TimeInterval interval = NiceTimeInterval.INSTANCE.forMillis(step);
                dateTimeFormatter2.element = interval.getTickFormatter();
                this.pattern = interval.getTickFormatPattern();
                ticks = CollectionsKt.toMutableList((Collection)interval.range(start2, end));
            }
            if (this.isReversed()) {
                CollectionsKt.reverse((List)ticks);
            }
            this.breaks = ticks;
        }
        if ((function1 = this.providedFormatter) == null) {
            function1 = (Function1)new Function1<Object, String>((Ref.ObjectRef<Function1<Number, String>>)dateTimeFormatter2){
                final /* synthetic */ Ref.ObjectRef<Function1<Number, String>> $dateTimeFormatter;
                {
                    this.$dateTimeFormatter = $dateTimeFormatter;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull Object v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return (String)((Function1)this.$dateTimeFormatter.element).invoke((Object)((Number)v));
                }
            };
        }
        this.formatter = function1;
    }

    public /* synthetic */ DateTimeBreaksHelper(double d, double d2, int n, Function1 function1, TimeInterval timeInterval, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            timeInterval = null;
        }
        this(d, d2, n, (Function1<Object, String>)function1, timeInterval);
    }

    @Override
    @NotNull
    public List<Double> getBreaks() {
        return this.breaks;
    }

    @NotNull
    public final Function1<Object, String> getFormatter() {
        return this.formatter;
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }
}

