/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.calltree;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.model.TreeNode;
import com.intellij.profiler.model.diff.DiffCallWithValue;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JB\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J$\u0010\u0015\u001a\u00020\t*\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/ui/calltree/CallWithValuePercentageWithMetricTreeRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "componentIcon", "Ljavax/swing/Icon;", "callStackElementRenderer", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "<init>", "(Ljavax/swing/Icon;Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;)V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "appendPercentage", "Lcom/intellij/ui/SimpleColoredComponent;", "root", "Lcom/intellij/profiler/model/CallWithValue;", "item", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nCallWithValuePercentageWithMetricTreeRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallWithValuePercentageWithMetricTreeRenderer.kt\ncom/intellij/profiler/ui/calltree/CallWithValuePercentageWithMetricTreeRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class CallWithValuePercentageWithMetricTreeRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    private final Icon componentIcon;
    @NotNull
    private final BaseCallStackElementRenderer callStackElementRenderer;

    public CallWithValuePercentageWithMetricTreeRenderer(@NotNull Icon componentIcon, @NotNull BaseCallStackElementRenderer callStackElementRenderer) {
        Intrinsics.checkNotNullParameter((Object)componentIcon, (String)"componentIcon");
        Intrinsics.checkNotNullParameter((Object)callStackElementRenderer, (String)"callStackElementRenderer");
        this.componentIcon = componentIcon;
        this.callStackElementRenderer = callStackElementRenderer;
    }

    public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        CallWithValue item;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        TreeNode treeNode = value instanceof TreeNode ? (TreeNode)value : null;
        Object Data = treeNode != null ? treeNode.getData() : null;
        CallWithValue callWithValue = item = Data instanceof CallWithValue ? (CallWithValue)Data : null;
        if (item == null) {
            this.append(String.valueOf(value));
            return;
        }
        this.myUsedCustomSpeedSearchHighlighting = true;
        this.setIcon(this.componentIcon);
        if (!(item instanceof DiffCallWithValue)) {
            Object object = tree.getModel().getRoot();
            TreeNode treeNode2 = object instanceof TreeNode ? (TreeNode)object : null;
            Object object2 = treeNode2 != null ? treeNode2.getData() : null;
            Intrinsics.checkNotNull(object2, (String)"null cannot be cast to non-null type com.intellij.profiler.model.CallWithValue<*>");
            CallWithValue rootItem = (CallWithValue)object2;
            this.appendPercentage((SimpleColoredComponent)this, rootItem, item);
        }
        this.append("  ");
        Object t = item.getCall();
        BaseCallStackElement baseCallStackElement = t instanceof BaseCallStackElement ? (BaseCallStackElement)t : null;
        if (baseCallStackElement != null) {
            BaseCallStackElement it = baseCallStackElement;
            boolean bl = false;
            this.callStackElementRenderer.appendStackElementInRenderer(it, (SimpleColoredComponent)this, tree, selected);
            v5 = Unit.INSTANCE;
        } else {
            CallWithValuePercentageWithMetricTreeRenderer $this$customizeCellRenderer_u24lambda_u241 = this;
            boolean bl = false;
            SimpleColoredComponent simpleColoredComponent = $this$customizeCellRenderer_u24lambda_u241.append(String.valueOf(item));
            v5 = simpleColoredComponent;
            Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent, (String)"run(...)");
        }
    }

    private final void appendPercentage(SimpleColoredComponent $this$appendPercentage, CallWithValue<?> root, CallWithValue<?> item) {
        int width = ProfilerUIUtilsKt.metricsStringWidth$default((JComponent)$this$appendPercentage, $this$appendPercentage.getIcon() != null, false, 2, null);
        double fraction = root == item ? 1.0 : (double)item.getValue() / (double)root.getValue();
        if (Math.abs(fraction) <= Double.MAX_VALUE) {
            $this$appendPercentage.append(ProfilerUIUtilsKt.fractionToString$default(fraction, 0.01, false, false, 12, null), new SimpleTextAttributes(0, FlameChartColors.INSTANCE.getFireColor$intellij_profiler_common(fraction)));
            Icon icon2 = $this$appendPercentage.getIcon();
            $this$appendPercentage.appendTextPadding(width + (icon2 != null ? icon2.getIconWidth() : 0), 4);
        }
    }
}

