/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.frontend.split.diff;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.platform.vcs.frontend.split.diff.FrontendDiffMarkModelSupportKt;
import com.intellij.platform.vcs.frontend.split.diff.UnifiedChangeModel;
import com.intellij.platform.vcs.frontend.split.diff.UnifiedChangedBlock;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001c\u001a\u00020\bH\u0002J\b\u0010\u001d\u001a\u00020\bH\u0002J\b\u0010\u001e\u001a\u00020\bH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/UnifiedBlocksModel;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "onBlocksChanges", "Lkotlin/Function0;", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/ex/EditorEx;Lkotlin/jvm/functions/Function0;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "getOnBlocksChanges", "()Lkotlin/jvm/functions/Function0;", "isUpdateScheduled", "", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "value", "", "Lcom/intellij/platform/vcs/frontend/split/diff/UnifiedChangedBlock;", "changedBlocks", "getChangedBlocks", "()Ljava/util/List;", "scheduleBlockUpdate", "clearBlocks", "rebuildBlocks", "collectBlockHighlighters", "BlocksMarkupModelListener", "intellij.platform.vcs.frontend.split"})
public final class UnifiedBlocksModel {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final Function0<Unit> onBlocksChanges;
    private boolean isUpdateScheduled;
    @NotNull
    private final List<RangeHighlighter> highlighters;
    @NotNull
    private List<UnifiedChangedBlock> changedBlocks;

    public UnifiedBlocksModel(@NotNull Lifetime lifetime, @NotNull EditorEx editor, @NotNull Function0<Unit> onBlocksChanges) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(onBlocksChanges, (String)"onBlocksChanges");
        this.lifetime = lifetime;
        this.editor = editor;
        this.onBlocksChanges = onBlocksChanges;
        this.highlighters = new ArrayList();
        this.changedBlocks = CollectionsKt.emptyList();
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null);
        BlocksMarkupModelListener markupListener = new BlocksMarkupModelListener();
        this.editor.getMarkupModel().addMarkupModelListener(disposable, (MarkupModelListener)markupListener);
        this.scheduleBlockUpdate();
        this.lifetime.onTermination(() -> UnifiedBlocksModel._init_$lambda$0(this));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    @NotNull
    public final Function0<Unit> getOnBlocksChanges() {
        return this.onBlocksChanges;
    }

    @NotNull
    public final List<UnifiedChangedBlock> getChangedBlocks() {
        return this.changedBlocks;
    }

    private final void scheduleBlockUpdate() {
        if (this.isUpdateScheduled) {
            return;
        }
        this.isUpdateScheduled = true;
        ActionsKt.invokeLater$default(null, () -> UnifiedBlocksModel.scheduleBlockUpdate$lambda$1(this), (int)1, null);
    }

    private final void clearBlocks() {
        for (RangeHighlighter highlighter : this.highlighters) {
            highlighter.dispose();
        }
        this.highlighters.clear();
        this.changedBlocks = CollectionsKt.emptyList();
    }

    private final void rebuildBlocks() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime) || this.editor.isDisposed()) {
            return;
        }
        this.clearBlocks();
        List<UnifiedChangedBlock> newBlocks = this.collectBlockHighlighters(this.editor);
        this.changedBlocks = newBlocks;
        this.onBlocksChanges.invoke();
    }

    private final List<UnifiedChangedBlock> collectBlockHighlighters(EditorEx editor) {
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        List result = new ArrayList();
        editor.getMarkupModel().processRangeHighlightersOverlappingWith(0, document.getTextLength(), arg_0 -> UnifiedBlocksModel.collectBlockHighlighters$lambda$3(arg_0 -> UnifiedBlocksModel.collectBlockHighlighters$lambda$2(result, arg_0), arg_0));
        return result;
    }

    private static final Unit _init_$lambda$0(UnifiedBlocksModel this$0) {
        this$0.clearBlocks();
        return Unit.INSTANCE;
    }

    private static final Unit scheduleBlockUpdate$lambda$1(UnifiedBlocksModel this$0) {
        this$0.isUpdateScheduled = false;
        this$0.rebuildBlocks();
        return Unit.INSTANCE;
    }

    private static final boolean collectBlockHighlighters$lambda$2(List $result, RangeHighlighterEx it) {
        Intrinsics.checkNotNull((Object)it);
        UnifiedChangeModel blockModel = FrontendDiffMarkModelSupportKt.getUnifiedChangeModel((RangeHighlighter)it);
        if (blockModel != null) {
            ((Collection)$result).add(new UnifiedChangedBlock(it, blockModel));
        }
        return true;
    }

    private static final boolean collectBlockHighlighters$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/UnifiedBlocksModel$BlocksMarkupModelListener;", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "<init>", "(Lcom/intellij/platform/vcs/frontend/split/diff/UnifiedBlocksModel;)V", "afterAdded", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterRemoved", "attributesChanged", "renderersChanged", "", "fontStyleChanged", "foregroundColorChanged", "onHighlighterModified", "intellij.platform.vcs.frontend.split"})
    private final class BlocksMarkupModelListener
    implements MarkupModelListener {
        public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            this.onHighlighterModified(highlighter);
        }

        public void afterRemoved(@NotNull RangeHighlighterEx highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            this.onHighlighterModified(highlighter);
        }

        public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            this.onHighlighterModified(highlighter);
        }

        private final void onHighlighterModified(RangeHighlighterEx highlighter) {
            if (FrontendDiffMarkModelSupportKt.getUnifiedChangeModel((RangeHighlighter)highlighter) != null) {
                UnifiedBlocksModel.this.scheduleBlockUpdate();
            }
        }
    }
}

