/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.blockdevicelib.vmdk;

import com.amazon.aes.webservices.client.blockdevicelib.ImageVerificationException;
import java.nio.ByteBuffer;

public class SparseExtentHeader {
    public final int magicNumber;
    public final int version;
    public final int flags;
    public final long capacity;
    public final long grainSize;
    public final long descriptorOffset;
    public final long descriptorSize;
    public final int numGTEsPerGT;
    public final long rgdOffset;
    public final long gdOffset;
    public final long overHead;
    public final boolean uncleanShutdown;
    public final byte singleEndLineChar;
    public final byte nonEndLineChar;
    public final byte doubleEndLineChar1;
    public final byte doubleEndLineChar2;
    public final short compressAlgorithm;

    public SparseExtentHeader(ByteBuffer buff) {
        this.magicNumber = buff.getInt();
        this.version = buff.getInt();
        this.flags = buff.getInt();
        this.capacity = buff.getLong();
        this.grainSize = buff.getLong();
        this.descriptorOffset = buff.getLong();
        this.descriptorSize = buff.getLong();
        this.numGTEsPerGT = buff.getInt();
        this.rgdOffset = buff.getLong();
        this.gdOffset = buff.getLong();
        this.overHead = buff.getLong();
        this.uncleanShutdown = buff.get() != 0;
        this.singleEndLineChar = buff.get();
        this.nonEndLineChar = buff.get();
        this.doubleEndLineChar1 = buff.get();
        this.doubleEndLineChar2 = buff.get();
        this.compressAlgorithm = buff.getShort();
    }

    public void validateHeader() throws ImageVerificationException {
        if (this.magicNumber != 1447904331) {
            throw new ImageVerificationException("This does not appear to be a Stream Optimized VMDK. It contains invalid magic number " + this.magicNumber);
        }
        if (this.descriptorOffset == 0L) {
            throw new ImageVerificationException("VMDK Descriptor does not exist.");
        }
        if (this.compressAlgorithm != 1) {
            throw new ImageVerificationException("File uses unsupported compression algorithm " + this.compressAlgorithm);
        }
        if ((this.flags & 0x10000) == 0) {
            throw new ImageVerificationException("File does not contain compressed grains.");
        }
        if ((this.flags & 0x20000) == 0) {
            throw new ImageVerificationException("File does not have all data present.");
        }
        if (this.uncleanShutdown) {
            throw new ImageVerificationException("File marked as unclean shutdown.");
        }
        if (this.corruptViaFtpTextMode()) {
            throw new ImageVerificationException("Perhaps this file has been transferred over ftp?");
        }
    }

    private boolean corruptViaFtpTextMode() {
        return this.singleEndLineChar != 10 || this.nonEndLineChar != 32 || this.doubleEndLineChar1 != 13 || this.doubleEndLineChar2 != 10;
    }

    public int getNumberOfGDEntries() {
        return (int)Math.ceil((double)(this.capacity * 512L) / 3.3554432E7);
    }
}

