/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.output.NullOutputStream;

public final class ThresholdingOutputStream
extends OutputStream {
    public static final IOFunction NOOP_OS_GETTER = thresholdingOutputStream -> NullOutputStream.INSTANCE;
    public final int threshold = Integer.MAX_VALUE;
    public final IOConsumer thresholdConsumer;
    public final IOFunction outputStreamGetter;
    public long written;
    public boolean thresholdExceeded;

    public ThresholdingOutputStream(IOConsumer iOConsumer, IOFunction iOFunction) {
        if (iOConsumer == null) {
            iOConsumer = IOConsumer.NOOP_IO_CONSUMER;
        }
        this.thresholdConsumer = iOConsumer;
        if (iOFunction == null) {
            iOFunction = NOOP_OS_GETTER;
        }
        this.outputStreamGetter = iOFunction;
    }

    public final void checkThreshold(int n) {
        if (!this.thresholdExceeded && this.written + (long)n > (long)this.threshold) {
            this.thresholdExceeded = true;
            this.thresholdConsumer.accept(this);
        }
    }

    @Override
    public final void close() {
        try {
            this.getStream().flush();
        }
        catch (IOException iOException) {}
        this.getStream().close();
    }

    @Override
    public final void flush() {
        this.getStream().flush();
    }

    public final OutputStream getStream() {
        return (OutputStream)this.outputStreamGetter.apply(this);
    }

    @Override
    public final void write(byte[] byArray) {
        ThresholdingOutputStream thresholdingOutputStream = this;
        thresholdingOutputStream.checkThreshold(byArray.length);
        thresholdingOutputStream.getStream().write(byArray);
        thresholdingOutputStream.written += (long)byArray.length;
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) {
        ThresholdingOutputStream thresholdingOutputStream = this;
        thresholdingOutputStream.checkThreshold(n2);
        thresholdingOutputStream.getStream().write(byArray, n, n2);
        thresholdingOutputStream.written += (long)n2;
    }

    @Override
    public final void write(int n) {
        ThresholdingOutputStream thresholdingOutputStream = this;
        thresholdingOutputStream.checkThreshold(1);
        thresholdingOutputStream.getStream().write(n);
        ++thresholdingOutputStream.written;
    }
}

