/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.internals.AsyncKafkaConsumer;
import org.apache.kafka.clients.consumer.internals.ClassicKafkaConsumer;
import org.apache.kafka.clients.consumer.internals.ConsumerDelegate;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;

public class ConsumerDelegateCreator {
    public <K, V> ConsumerDelegate<K, V> create(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        try {
            GroupProtocol groupProtocol = GroupProtocol.valueOf(config.getString("group.protocol").toUpperCase(Locale.ROOT));
            if (groupProtocol == GroupProtocol.CONSUMER) {
                return new AsyncKafkaConsumer<K, V>(config, keyDeserializer, valueDeserializer, Optional.empty());
            }
            return new ClassicKafkaConsumer<K, V>(config, keyDeserializer, valueDeserializer);
        }
        catch (KafkaException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new KafkaException("Failed to construct Kafka consumer", t);
        }
    }

    public <K, V> ConsumerDelegate<K, V> create(LogContext logContext, Time time, ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, KafkaClient client, SubscriptionState subscriptions, ConsumerMetadata metadata, List<ConsumerPartitionAssignor> assignors) {
        try {
            GroupProtocol groupProtocol = GroupProtocol.valueOf(config.getString("group.protocol").toUpperCase(Locale.ROOT));
            if (groupProtocol == GroupProtocol.CONSUMER) {
                return new AsyncKafkaConsumer<K, V>(logContext, time, config, keyDeserializer, valueDeserializer, client, subscriptions, metadata);
            }
            return new ClassicKafkaConsumer<K, V>(logContext, time, config, keyDeserializer, valueDeserializer, client, subscriptions, metadata, assignors);
        }
        catch (KafkaException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new KafkaException("Failed to construct Kafka consumer", t);
        }
    }
}

