/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChangeCipherSuiteAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private CipherSuite newValue = null;
    private CipherSuite oldValue = null;

    public ChangeCipherSuiteAction(CipherSuite newValue) {
        this.newValue = newValue;
    }

    public ChangeCipherSuiteAction(String alias, CipherSuite newValue) {
        super(alias);
        this.newValue = newValue;
    }

    public ChangeCipherSuiteAction() {
    }

    public CipherSuite getNewValue() {
        return this.newValue;
    }

    public void setNewValue(CipherSuite newValue) {
        this.newValue = newValue;
    }

    public CipherSuite getOldValue() {
        return this.oldValue;
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        this.oldValue = tlsContext.getSelectedCipherSuite();
        tlsContext.setSelectedCipherSuite(this.newValue);
        tlsContext.getRecordLayer().updateDecryptionCipher();
        tlsContext.getRecordLayer().updateEncryptionCipher();
        LOGGER.info("Changed CipherSuite from " + (this.oldValue == null ? null : this.oldValue.name()) + " to " + this.newValue.name());
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.oldValue = null;
        this.setExecuted(null);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode((Object)this.newValue);
        hash = 17 * hash + Objects.hashCode((Object)this.oldValue);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeCipherSuiteAction other = (ChangeCipherSuiteAction)obj;
        if (this.newValue != other.newValue) {
            return false;
        }
        return this.oldValue == other.oldValue;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

