/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.ice4j.attribute.Attribute;
import org.ice4j.attribute.ContentDependentAttribute;
import org.ice4j.message.Message;
import org.ice4j.stack.StunStack;

public class MessageIntegrityAttribute
extends Attribute
implements ContentDependentAttribute {
    private static final Logger logger = Logger.getLogger(MessageIntegrityAttribute.class.getName());
    public static final String NAME = "MESSAGE_INTEGRITY";
    public static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    public static final char DATA_LENGTH = '\u0014';
    private byte[] hmacSha1Content;
    private String username;
    private String media;

    protected MessageIntegrityAttribute() {
        super('\b');
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public byte[] getHmacSha1Content() {
        return this.hmacSha1Content;
    }

    public static byte[] calculateHmacSha1(byte[] message, int offset, int length, byte[] key) throws IllegalArgumentException {
        byte[] hmac;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            byte[] macInput = new byte[length];
            System.arraycopy(message, offset, macInput, 0, length);
            hmac = mac.doFinal(macInput);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Could not create HMAC-SHA1 request encoding: ", exc);
        }
        return hmac;
    }

    @Override
    public void decodeAttributeBody(byte[] attributeValue, char offset, char length) {
        this.hmacSha1Content = new byte[length];
        System.arraycopy(attributeValue, offset, this.hmacSha1Content, 0, length);
    }

    @Override
    public byte[] encode() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ContentDependentAttributes should be encoded through the contend-dependent encode method");
    }

    @Override
    public byte[] encode(StunStack stunStack, byte[] content, int offset, int length) {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        byte[] key = null;
        char msgType = (char)((content[0] & 0xFF) << 8 | content[1] & 0xFF);
        if (Message.isRequestType(msgType)) {
            key = stunStack.getCredentialsManager().getRemoteKey(this.username, this.media);
        } else if (Message.isResponseType(msgType)) {
            key = stunStack.getCredentialsManager().getLocalKey(this.username);
        } else {
            logger.warning("Can not encode a message of type Indication.");
        }
        Objects.requireNonNull(key, "key=null; msgType=" + String.format("%04X", msgType));
        this.hmacSha1Content = MessageIntegrityAttribute.calculateHmacSha1(content, offset, length, key);
        System.arraycopy(this.hmacSha1Content, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    @Override
    public char getDataLength() {
        return '\u0014';
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MessageIntegrityAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        MessageIntegrityAttribute att = (MessageIntegrityAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.hmacSha1Content, this.hmacSha1Content);
    }
}

