# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.infra.identity_firewall_stores.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class EventLogServers(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.identity_firewall_stores.event_log_servers'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _EventLogServersStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               identity_firewall_store_id,
               event_log_server_id,
               enforcement_point_path=None,
               ):
        """
        Delete a Event Log server for Firewall Identity store

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: Firewall Identity store identifier (required)
        :type  event_log_server_id: :class:`str`
        :param event_log_server_id: Event Log server identifier (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'event_log_server_id': event_log_server_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def get(self,
            identity_firewall_store_id,
            event_log_server_id,
            enforcement_point_path=None,
            ):
        """
        Get a specific Event Log server for a given Firewall Identity store

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: Firewall Identity store identifier (required)
        :type  event_log_server_id: :class:`str`
        :param event_log_server_id: Event Log server identifier (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreEventLogServer`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStoreEventLogServer
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'event_log_server_id': event_log_server_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def patch(self,
              identity_firewall_store_id,
              event_log_server_id,
              identity_firewall_store_event_log_server,
              enforcement_point_path=None,
              ):
        """
        More than one Event Log server can be created and only one event log
        server is used to synchronize directory objects. If more than one Event
        Log server is configured, NSX will try all the servers until it is able
        to successfully connect to one.

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: Firewall Identity store identifier (required)
        :type  event_log_server_id: :class:`str`
        :param event_log_server_id: Event Log server identifier (required)
        :type  identity_firewall_store_event_log_server: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreEventLogServer`
        :param identity_firewall_store_event_log_server: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'event_log_server_id': event_log_server_id,
                            'identity_firewall_store_event_log_server': identity_firewall_store_event_log_server,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def update(self,
               identity_firewall_store_id,
               event_log_server_id,
               identity_firewall_store_event_log_server,
               enforcement_point_path=None,
               ):
        """
        Update a event log server for Firewall Identity store

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: Firewall Identity store identifier (required)
        :type  event_log_server_id: :class:`str`
        :param event_log_server_id: Event Log Server identifier (required)
        :type  identity_firewall_store_event_log_server: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreEventLogServer`
        :param identity_firewall_store_event_log_server: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreEventLogServer`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStoreEventLogServer
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'event_log_server_id': event_log_server_id,
                            'identity_firewall_store_event_log_server': identity_firewall_store_event_log_server,
                            'enforcement_point_path': enforcement_point_path,
                            })
class LdapServers(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.identity_firewall_stores.ldap_servers'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _LdapServersStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               identity_firewall_store_id,
               ldap_server_id,
               enforcement_point_path=None,
               ):
        """
        Delete a LDAP server for Firewall Identity store

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: Firewall Identity store identifier (required)
        :type  ldap_server_id: :class:`str`
        :param ldap_server_id: LDAP server identifier (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'ldap_server_id': ldap_server_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def get(self,
            identity_firewall_store_id,
            ldap_server_id,
            enforcement_point_path=None,
            ):
        """
        Get a specific LDAP server for a given Firewall Identity store

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: Firewall Identity store identifier (required)
        :type  ldap_server_id: :class:`str`
        :param ldap_server_id: LDAP server identifier (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreLdapServer`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStoreLdapServer
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'ldap_server_id': ldap_server_id,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def list(self,
             identity_firewall_store_id,
             cursor=None,
             enforcement_point_path=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        List all configured domain LDAP servers

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: Firewall Identity store identifier (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreLdapServerListResults`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStoreLdapServerListResults
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              identity_firewall_store_id,
              ldap_server_id,
              identity_firewall_store_ldap_server,
              enforcement_point_path=None,
              ):
        """
        More than one LDAP server can be created and only one LDAP server is
        used to synchronize directory objects. If more than one LDAP server is
        configured, NSX will try all the servers until it is able to
        successfully connect to one.

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: Firewall Identity store identifier (required)
        :type  ldap_server_id: :class:`str`
        :param ldap_server_id: LDAP server identifier (required)
        :type  identity_firewall_store_ldap_server: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreLdapServer`
        :param identity_firewall_store_ldap_server: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreLdapServer`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStoreLdapServer
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'ldap_server_id': ldap_server_id,
                            'identity_firewall_store_ldap_server': identity_firewall_store_ldap_server,
                            'enforcement_point_path': enforcement_point_path,
                            })

    def update(self,
               identity_firewall_store_id,
               ldap_server_id,
               identity_firewall_store_ldap_server,
               enforcement_point_path=None,
               ):
        """
        Update a LDAP server for Firewall Identity store

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: Firewall Identity store identifier (required)
        :type  ldap_server_id: :class:`str`
        :param ldap_server_id: LDAP server identifier (required)
        :type  identity_firewall_store_ldap_server: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreLdapServer`
        :param identity_firewall_store_ldap_server: (required)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreLdapServer`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStoreLdapServer
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'ldap_server_id': ldap_server_id,
                            'identity_firewall_store_ldap_server': identity_firewall_store_ldap_server,
                            'enforcement_point_path': enforcement_point_path,
                            })
class Users(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.identity_firewall_stores.users'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _UsersStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             identity_firewall_store_id,
             filter_value,
             cursor=None,
             enforcement_point_path=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Return all the users based on the user name.

        :type  identity_firewall_store_id: :class:`str`
        :param identity_firewall_store_id: Firewall Identity store identifier (required)
        :type  filter_value: :class:`str`
        :param filter_value: Name search filter value (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  enforcement_point_path: :class:`str` or ``None``
        :param enforcement_point_path: String Path of the enforcement point (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.IdentityFirewallStoreUserOrGrouptListResults`
        :return: com.vmware.nsx_policy.model.IdentityFirewallStoreUserOrGrouptListResults
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'identity_firewall_store_id': identity_firewall_store_id,
                            'filter_value': filter_value,
                            'cursor': cursor,
                            'enforcement_point_path': enforcement_point_path,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class _EventLogServersStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'identity_firewall_store_id': type.StringType(),
            'event_log_server_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/identity-firewall-stores/{identity-firewall-store-id}/event-log-servers/{event-log-server-id}',
            path_variables={
                'identity_firewall_store_id': 'identity-firewall-store-id',
                'event_log_server_id': 'event-log-server-id',
            },
             header_parameters={
                   },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'identity_firewall_store_id': type.StringType(),
            'event_log_server_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/identity-firewall-stores/{identity-firewall-store-id}/event-log-servers/{event-log-server-id}',
            path_variables={
                'identity_firewall_store_id': 'identity-firewall-store-id',
                'event_log_server_id': 'event-log-server-id',
            },
             header_parameters={
                   },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'identity_firewall_store_id': type.StringType(),
            'event_log_server_id': type.StringType(),
            'identity_firewall_store_event_log_server': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IdentityFirewallStoreEventLogServer'),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/identity-firewall-stores/{identity-firewall-store-id}/event-log-servers/{event-log-server-id}',
            request_body_parameter='identity_firewall_store_event_log_server',
            path_variables={
                'identity_firewall_store_id': 'identity-firewall-store-id',
                'event_log_server_id': 'event-log-server-id',
            },
             header_parameters={
                     },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'identity_firewall_store_id': type.StringType(),
            'event_log_server_id': type.StringType(),
            'identity_firewall_store_event_log_server': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IdentityFirewallStoreEventLogServer'),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/identity-firewall-stores/{identity-firewall-store-id}/event-log-servers/{event-log-server-id}',
            request_body_parameter='identity_firewall_store_event_log_server',
            path_variables={
                'identity_firewall_store_id': 'identity-firewall-store-id',
                'event_log_server_id': 'event-log-server-id',
            },
             header_parameters={
                     },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IdentityFirewallStoreEventLogServer'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IdentityFirewallStoreEventLogServer'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.identity_firewall_stores.event_log_servers',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _LdapServersStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'identity_firewall_store_id': type.StringType(),
            'ldap_server_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/identity-firewall-stores/{identity-firewall-store-id}/ldap-servers/{ldap-server-id}',
            path_variables={
                'identity_firewall_store_id': 'identity-firewall-store-id',
                'ldap_server_id': 'ldap-server-id',
            },
             header_parameters={
                   },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'identity_firewall_store_id': type.StringType(),
            'ldap_server_id': type.StringType(),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/identity-firewall-stores/{identity-firewall-store-id}/ldap-servers/{ldap-server-id}',
            path_variables={
                'identity_firewall_store_id': 'identity-firewall-store-id',
                'ldap_server_id': 'ldap-server-id',
            },
             header_parameters={
                   },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'identity_firewall_store_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'enforcement_point_path': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/identity-firewall-stores/{identity-firewall-store-id}/ldap-servers',
            path_variables={
                'identity_firewall_store_id': 'identity-firewall-store-id',
            },
             header_parameters={
                           },
            query_parameters={
                'cursor': 'cursor',
                'enforcement_point_path': 'enforcement_point_path',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'identity_firewall_store_id': type.StringType(),
            'ldap_server_id': type.StringType(),
            'identity_firewall_store_ldap_server': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IdentityFirewallStoreLdapServer'),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/identity-firewall-stores/{identity-firewall-store-id}/ldap-servers/{ldap-server-id}',
            request_body_parameter='identity_firewall_store_ldap_server',
            path_variables={
                'identity_firewall_store_id': 'identity-firewall-store-id',
                'ldap_server_id': 'ldap-server-id',
            },
             header_parameters={
                     },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'identity_firewall_store_id': type.StringType(),
            'ldap_server_id': type.StringType(),
            'identity_firewall_store_ldap_server': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IdentityFirewallStoreLdapServer'),
            'enforcement_point_path': type.OptionalType(type.StringType()),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/identity-firewall-stores/{identity-firewall-store-id}/ldap-servers/{ldap-server-id}',
            request_body_parameter='identity_firewall_store_ldap_server',
            path_variables={
                'identity_firewall_store_id': 'identity-firewall-store-id',
                'ldap_server_id': 'ldap-server-id',
            },
             header_parameters={
                     },
            query_parameters={
                'enforcement_point_path': 'enforcement_point_path',
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IdentityFirewallStoreLdapServer'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IdentityFirewallStoreLdapServerListResults'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IdentityFirewallStoreLdapServer'),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IdentityFirewallStoreLdapServer'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.identity_firewall_stores.ldap_servers',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _UsersStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'identity_firewall_store_id': type.StringType(),
            'filter_value': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'enforcement_point_path': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/identity-firewall-stores/{identity-firewall-store-id}/users',
            path_variables={
                'identity_firewall_store_id': 'identity-firewall-store-id',
            },
             header_parameters={
                             },
            query_parameters={
                'filter_value': 'filter_value',
                'cursor': 'cursor',
                'enforcement_point_path': 'enforcement_point_path',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'IdentityFirewallStoreUserOrGrouptListResults'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.identity_firewall_stores.users',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'EventLogServers': EventLogServers,
        'LdapServers': LdapServers,
        'Users': Users,
        'groups': 'com.vmware.nsx_policy.infra.identity_firewall_stores.groups_client.StubFactory',
        'users': 'com.vmware.nsx_policy.infra.identity_firewall_stores.users_client.StubFactory',
    }

