/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene101;

import java.io.Closeable;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.apache.lucene.backward_codecs.lucene101.ForDeltaUtil;
import org.apache.lucene.backward_codecs.lucene101.Lucene101PostingsFormat;
import org.apache.lucene.backward_codecs.lucene101.PForUtil;
import org.apache.lucene.backward_codecs.lucene101.PostingDecodingUtil;
import org.apache.lucene.backward_codecs.lucene101.PostingsUtil;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Impact;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.FileDataHint;
import org.apache.lucene.store.FileTypeHint;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.VectorUtil;

public final class Lucene101PostingsReader
extends PostingsReaderBase {
    private static final List<Impact> DUMMY_IMPACTS = Collections.singletonList(new Impact(Integer.MAX_VALUE, 1L));
    private static final List<Impact> DUMMY_IMPACTS_NO_FREQS = Collections.singletonList(new Impact(1, 1L));
    private final IndexInput docIn;
    private final IndexInput posIn;
    private final IndexInput payIn;
    private final int maxNumImpactsAtLevel0;
    private final int maxImpactNumBytesAtLevel0;
    private final int maxNumImpactsAtLevel1;
    private final int maxImpactNumBytesAtLevel1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene101PostingsReader(SegmentReadState state) throws IOException {
        long expectedPayFileLength;
        long expectedPosFileLength;
        long expectedDocFileLength;
        int version;
        boolean success;
        block13: {
            ChecksumIndexInput metaIn;
            block12: {
                String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"psm");
                metaIn = null;
                success = false;
                try {
                    metaIn = state.directory.openChecksumInput(metaName);
                    version = CodecUtil.checkIndexHeader((DataInput)metaIn, (String)"Lucene101PostingsWriterMeta", (int)0, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.maxNumImpactsAtLevel0 = metaIn.readInt();
                    this.maxImpactNumBytesAtLevel0 = metaIn.readInt();
                    this.maxNumImpactsAtLevel1 = metaIn.readInt();
                    this.maxImpactNumBytesAtLevel1 = metaIn.readInt();
                    expectedDocFileLength = metaIn.readLong();
                    if (state.fieldInfos.hasProx()) {
                        expectedPosFileLength = metaIn.readLong();
                        expectedPayFileLength = state.fieldInfos.hasPayloads() || state.fieldInfos.hasOffsets() ? metaIn.readLong() : -1L;
                    } else {
                        expectedPosFileLength = -1L;
                        expectedPayFileLength = -1L;
                    }
                    CodecUtil.checkFooter((ChecksumIndexInput)metaIn, null);
                    success = true;
                    if (!success) break block12;
                }
                catch (Throwable t) {
                    try {
                        if (metaIn == null) throw t;
                        CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)t);
                        throw new AssertionError((Object)"unreachable");
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            metaIn.close();
                            throw throwable;
                        } else {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{metaIn});
                        }
                        throw throwable;
                    }
                }
                metaIn.close();
                break block13;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{metaIn});
        }
        success = false;
        IndexInput docIn = null;
        IndexInput posIn = null;
        IndexInput payIn = null;
        String docName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"doc");
        try {
            docIn = state.directory.openInput(docName, state.context.withHints(new IOContext.FileOpenHint[]{FileTypeHint.DATA, FileDataHint.POSTINGS}));
            CodecUtil.checkIndexHeader((DataInput)docIn, (String)"Lucene101PostingsWriterDoc", (int)version, (int)version, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            CodecUtil.retrieveChecksum((IndexInput)docIn, (long)expectedDocFileLength);
            if (state.fieldInfos.hasProx()) {
                String proxName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"pos");
                posIn = state.directory.openInput(proxName, state.context);
                CodecUtil.checkIndexHeader((DataInput)posIn, (String)"Lucene101PostingsWriterPos", (int)version, (int)version, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                CodecUtil.retrieveChecksum((IndexInput)posIn, (long)expectedPosFileLength);
                if (state.fieldInfos.hasPayloads() || state.fieldInfos.hasOffsets()) {
                    String payName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"pay");
                    payIn = state.directory.openInput(payName, state.context);
                    CodecUtil.checkIndexHeader((DataInput)payIn, (String)"Lucene101PostingsWriterPay", (int)version, (int)version, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    CodecUtil.retrieveChecksum((IndexInput)payIn, (long)expectedPayFileLength);
                }
            }
            this.docIn = docIn;
            this.posIn = posIn;
            this.payIn = payIn;
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{docIn, posIn, payIn});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{docIn, posIn, payIn});
    }

    public void init(IndexInput termsIn, SegmentReadState state) throws IOException {
        CodecUtil.checkIndexHeader((DataInput)termsIn, (String)"Lucene90PostingsWriterTerms", (int)0, (int)1, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
        int indexBlockSize = termsIn.readVInt();
        if (indexBlockSize != 128) {
            throw new IllegalStateException("index-time BLOCK_SIZE (" + indexBlockSize + ") != read-time BLOCK_SIZE (128)");
        }
    }

    static void prefixSum(int[] buffer, int count, long base) {
        buffer[0] = (int)((long)buffer[0] + base);
        for (int i = 1; i < count; ++i) {
            int n = i;
            buffer[n] = buffer[n] + buffer[i - 1];
        }
    }

    public BlockTermState newTermState() {
        return new Lucene101PostingsFormat.IntBlockTermState();
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.docIn, this.posIn, this.payIn});
    }

    public void decodeTerm(DataInput in, FieldInfo fieldInfo, BlockTermState _termState, boolean absolute) throws IOException {
        long l;
        Lucene101PostingsFormat.IntBlockTermState termState = (Lucene101PostingsFormat.IntBlockTermState)_termState;
        if (absolute) {
            termState.docStartFP = 0L;
            termState.posStartFP = 0L;
            termState.payStartFP = 0L;
        }
        if (((l = in.readVLong()) & 1L) == 0L) {
            termState.docStartFP += l >>> 1;
            termState.singletonDocID = termState.docFreq == 1 ? in.readVInt() : -1;
        } else {
            assert (!absolute);
            assert (termState.singletonDocID != -1);
            termState.singletonDocID = (int)((long)termState.singletonDocID + BitUtil.zigZagDecode((long)(l >>> 1)));
        }
        if (fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            termState.posStartFP += in.readVLong();
            if (fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 || fieldInfo.hasPayloads()) {
                termState.payStartFP += in.readVLong();
            }
            termState.lastPosBlockOffset = termState.totalTermFreq > 128L ? in.readVLong() : -1L;
        }
    }

    public PostingsEnum postings(FieldInfo fieldInfo, BlockTermState termState, PostingsEnum reuse, int flags) throws IOException {
        BlockPostingsEnum everythingEnum;
        return (reuse instanceof BlockPostingsEnum && (everythingEnum = (BlockPostingsEnum)reuse).canReuse(this.docIn, fieldInfo, flags, false) ? everythingEnum : new BlockPostingsEnum(fieldInfo, flags, false)).reset((Lucene101PostingsFormat.IntBlockTermState)termState, flags);
    }

    public ImpactsEnum impacts(FieldInfo fieldInfo, BlockTermState state, int flags) throws IOException {
        return new BlockPostingsEnum(fieldInfo, flags, true).reset((Lucene101PostingsFormat.IntBlockTermState)state, flags);
    }

    private static int sumOverRange(int[] arr, int start, int end) {
        int res = 0;
        for (int i = start; i < end; ++i) {
            res += arr[i];
        }
        return res;
    }

    static int readVInt15(DataInput in) throws IOException {
        short s = in.readShort();
        if (s >= 0) {
            return s;
        }
        return s & Short.MAX_VALUE | in.readVInt() << 15;
    }

    static long readVLong15(DataInput in) throws IOException {
        short s = in.readShort();
        if (s >= 0) {
            return s;
        }
        return (long)s & 0x7FFFL | in.readVLong() << 15;
    }

    private static void prefetchPostings(IndexInput docIn, Lucene101PostingsFormat.IntBlockTermState state) throws IOException {
        assert (state.docFreq > 1);
        if (docIn.getFilePointer() != state.docStartFP) {
            docIn.prefetch(state.docStartFP, 1L);
        }
    }

    static MutableImpactList readImpacts(ByteArrayDataInput in, MutableImpactList reuse) {
        int freq = 0;
        long norm = 0L;
        int length = 0;
        while (in.getPosition() < in.length()) {
            int freqDelta = in.readVInt();
            if ((freqDelta & 1) != 0) {
                freq += 1 + (freqDelta >>> 1);
                try {
                    norm += 1L + in.readZLong();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                freq += 1 + (freqDelta >>> 1);
            }
            Impact impact = reuse.impacts[length];
            impact.freq = freq;
            impact.norm = ++norm;
            ++length;
        }
        reuse.length = length;
        return reuse;
    }

    public void checkIntegrity() throws IOException {
        if (this.docIn != null) {
            CodecUtil.checksumEntireFile((IndexInput)this.docIn);
        }
        if (this.posIn != null) {
            CodecUtil.checksumEntireFile((IndexInput)this.posIn);
        }
        if (this.payIn != null) {
            CodecUtil.checksumEntireFile((IndexInput)this.payIn);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(positions=" + (this.posIn != null) + ",payloads=" + (this.payIn != null) + ")";
    }

    final class BlockPostingsEnum
    extends ImpactsEnum {
        private ForDeltaUtil forDeltaUtil;
        private PForUtil pforUtil;
        private DeltaEncoding encoding;
        private int doc;
        private final int[] docBuffer = new int[128];
        private final FixedBitSet docBitSet = new FixedBitSet(4096);
        private int docBitSetBase;
        private final int[] docCumulativeWordPopCounts = this.docBuffer;
        private int level0LastDocID;
        private long level0DocEndFP;
        private int level1LastDocID;
        private long level1DocEndFP;
        private int level1DocCountUpto;
        private int docFreq;
        private long totalTermFreq;
        private int singletonDocID;
        private int docCountLeft;
        private int prevDocID;
        private int docBufferSize;
        private int docBufferUpto;
        private IndexInput docIn;
        private PostingDecodingUtil docInUtil;
        private final int[] freqBuffer = new int[128];
        private final int[] posDeltaBuffer;
        private final int[] payloadLengthBuffer;
        private final int[] offsetStartDeltaBuffer;
        private final int[] offsetLengthBuffer;
        private byte[] payloadBytes;
        private int payloadByteUpto;
        private int payloadLength;
        private int lastStartOffset;
        private int startOffset;
        private int endOffset;
        private int posBufferUpto;
        final IndexInput posIn;
        final PostingDecodingUtil posInUtil;
        final IndexInput payIn;
        final PostingDecodingUtil payInUtil;
        final BytesRef payload;
        final IndexOptions options;
        final boolean indexHasFreq;
        final boolean indexHasPos;
        final boolean indexHasOffsets;
        final boolean indexHasPayloads;
        final boolean indexHasOffsetsOrPayloads;
        final int flags;
        final boolean needsFreq;
        final boolean needsPos;
        final boolean needsOffsets;
        final boolean needsPayloads;
        final boolean needsOffsetsOrPayloads;
        final boolean needsImpacts;
        final boolean needsDocsAndFreqsOnly;
        private long freqFP;
        private int position;
        private int posDocBufferUpto;
        private int posPendingCount;
        private long lastPosBlockFP;
        private long level0PosEndFP;
        private int level0BlockPosUpto;
        private long level0PayEndFP;
        private int level0BlockPayUpto;
        private final BytesRef level0SerializedImpacts;
        private final MutableImpactList level0Impacts;
        private long level1PosEndFP;
        private int level1BlockPosUpto;
        private long level1PayEndFP;
        private int level1BlockPayUpto;
        private final BytesRef level1SerializedImpacts;
        private final MutableImpactList level1Impacts;
        private boolean needsRefilling;
        private final Impacts impacts = new Impacts(){
            private final ByteArrayDataInput scratch = new ByteArrayDataInput();

            public int numLevels() {
                return !BlockPostingsEnum.this.indexHasFreq || BlockPostingsEnum.this.level1LastDocID == Integer.MAX_VALUE ? 1 : 2;
            }

            public int getDocIdUpTo(int level) {
                if (!BlockPostingsEnum.this.indexHasFreq) {
                    return Integer.MAX_VALUE;
                }
                if (level == 0) {
                    return BlockPostingsEnum.this.level0LastDocID;
                }
                return level == 1 ? BlockPostingsEnum.this.level1LastDocID : Integer.MAX_VALUE;
            }

            public List<Impact> getImpacts(int level) {
                if (!BlockPostingsEnum.this.indexHasFreq) {
                    return DUMMY_IMPACTS_NO_FREQS;
                }
                if (level == 0 && BlockPostingsEnum.this.level0LastDocID != Integer.MAX_VALUE) {
                    return this.readImpacts(BlockPostingsEnum.this.level0SerializedImpacts, BlockPostingsEnum.this.level0Impacts);
                }
                if (level == 1) {
                    return this.readImpacts(BlockPostingsEnum.this.level1SerializedImpacts, BlockPostingsEnum.this.level1Impacts);
                }
                return DUMMY_IMPACTS;
            }

            private List<Impact> readImpacts(BytesRef serialized, MutableImpactList impactsList) {
                ByteArrayDataInput scratch = this.scratch;
                scratch.reset(serialized.bytes, 0, serialized.length);
                Lucene101PostingsReader.readImpacts(scratch, impactsList);
                return impactsList;
            }
        };

        public BlockPostingsEnum(FieldInfo fieldInfo, int flags, boolean needsImpacts) throws IOException {
            this.options = fieldInfo.getIndexOptions();
            this.indexHasFreq = this.options.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
            this.indexHasPos = this.options.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            this.indexHasOffsets = this.options.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            this.indexHasPayloads = fieldInfo.hasPayloads();
            this.indexHasOffsetsOrPayloads = this.indexHasOffsets || this.indexHasPayloads;
            this.flags = flags;
            this.needsFreq = this.indexHasFreq && PostingsEnum.featureRequested((int)flags, (short)8);
            this.needsPos = this.indexHasPos && PostingsEnum.featureRequested((int)flags, (short)24);
            this.needsOffsets = this.indexHasOffsets && PostingsEnum.featureRequested((int)flags, (short)56);
            this.needsPayloads = this.indexHasPayloads && PostingsEnum.featureRequested((int)flags, (short)88);
            this.needsOffsetsOrPayloads = this.needsOffsets || this.needsPayloads;
            this.needsImpacts = needsImpacts;
            boolean bl = this.needsDocsAndFreqsOnly = !this.needsPos && !needsImpacts;
            if (!this.needsFreq) {
                Arrays.fill(this.freqBuffer, 1);
            }
            if (this.needsFreq && needsImpacts) {
                this.level0SerializedImpacts = new BytesRef(Lucene101PostingsReader.this.maxImpactNumBytesAtLevel0);
                this.level1SerializedImpacts = new BytesRef(Lucene101PostingsReader.this.maxImpactNumBytesAtLevel1);
                this.level0Impacts = new MutableImpactList(Lucene101PostingsReader.this.maxNumImpactsAtLevel0);
                this.level1Impacts = new MutableImpactList(Lucene101PostingsReader.this.maxNumImpactsAtLevel1);
            } else {
                this.level0SerializedImpacts = null;
                this.level1SerializedImpacts = null;
                this.level0Impacts = null;
                this.level1Impacts = null;
            }
            if (this.needsPos) {
                this.posIn = Lucene101PostingsReader.this.posIn.clone();
                this.posInUtil = new PostingDecodingUtil(this.posIn);
                this.posDeltaBuffer = new int[128];
            } else {
                this.posIn = null;
                this.posInUtil = null;
                this.posDeltaBuffer = null;
            }
            if (this.needsOffsets || this.needsPayloads) {
                this.payIn = Lucene101PostingsReader.this.payIn.clone();
                this.payInUtil = new PostingDecodingUtil(this.payIn);
            } else {
                this.payIn = null;
                this.payInUtil = null;
            }
            if (this.needsOffsets) {
                this.offsetStartDeltaBuffer = new int[128];
                this.offsetLengthBuffer = new int[128];
            } else {
                this.offsetStartDeltaBuffer = null;
                this.offsetLengthBuffer = null;
                this.startOffset = -1;
                this.endOffset = -1;
            }
            if (this.indexHasPayloads) {
                this.payloadLengthBuffer = new int[128];
                this.payloadBytes = new byte[128];
                this.payload = new BytesRef();
            } else {
                this.payloadLengthBuffer = null;
                this.payloadBytes = null;
                this.payload = null;
            }
        }

        public boolean canReuse(IndexInput docIn, FieldInfo fieldInfo, int flags, boolean needsImpacts) {
            return docIn == Lucene101PostingsReader.this.docIn && this.options == fieldInfo.getIndexOptions() && this.indexHasPayloads == fieldInfo.hasPayloads() && this.flags == flags && this.needsImpacts == needsImpacts;
        }

        public BlockPostingsEnum reset(Lucene101PostingsFormat.IntBlockTermState termState, int flags) throws IOException {
            this.docFreq = termState.docFreq;
            this.singletonDocID = termState.singletonDocID;
            if (this.docFreq > 1) {
                if (this.docIn == null) {
                    this.docIn = Lucene101PostingsReader.this.docIn.clone();
                    this.docInUtil = new PostingDecodingUtil(this.docIn);
                }
                Lucene101PostingsReader.prefetchPostings(this.docIn, termState);
            }
            if (this.forDeltaUtil == null && this.docFreq >= 128) {
                this.forDeltaUtil = new ForDeltaUtil();
            }
            long l = this.totalTermFreq = this.indexHasFreq ? termState.totalTermFreq : (long)termState.docFreq;
            if (this.needsFreq && this.pforUtil == null && this.totalTermFreq >= 128L) {
                this.pforUtil = new PForUtil();
            }
            long posTermStartFP = termState.posStartFP;
            long payTermStartFP = termState.payStartFP;
            if (this.posIn != null) {
                this.posIn.seek(posTermStartFP);
                if (this.payIn != null) {
                    this.payIn.seek(payTermStartFP);
                }
            }
            this.level1PosEndFP = posTermStartFP;
            this.level1PayEndFP = payTermStartFP;
            this.level0PosEndFP = posTermStartFP;
            this.level0PayEndFP = payTermStartFP;
            this.posPendingCount = 0;
            this.payloadByteUpto = 0;
            this.lastPosBlockFP = termState.totalTermFreq < 128L ? posTermStartFP : (termState.totalTermFreq == 128L ? -1L : posTermStartFP + termState.lastPosBlockOffset);
            this.level1BlockPosUpto = 0;
            this.level1BlockPayUpto = 0;
            this.level0BlockPosUpto = 0;
            this.level0BlockPayUpto = 0;
            this.posBufferUpto = 128;
            this.doc = -1;
            this.prevDocID = -1;
            this.docCountLeft = this.docFreq;
            this.freqFP = -1L;
            this.level0LastDocID = -1;
            if (this.docFreq < 4096) {
                this.level1LastDocID = Integer.MAX_VALUE;
                if (this.docFreq > 1) {
                    this.docIn.seek(termState.docStartFP);
                }
            } else {
                this.level1LastDocID = -1;
                this.level1DocEndFP = termState.docStartFP;
            }
            this.level1DocCountUpto = 0;
            this.docBufferSize = 128;
            this.docBufferUpto = 128;
            this.posDocBufferUpto = 128;
            return this;
        }

        public int docID() {
            return this.doc;
        }

        public int freq() throws IOException {
            if (this.freqFP != -1L) {
                this.docIn.seek(this.freqFP);
                this.pforUtil.decode(this.docInUtil, this.freqBuffer);
                this.freqFP = -1L;
            }
            return this.freqBuffer[this.docBufferUpto - 1];
        }

        private void refillFullBlock() throws IOException {
            byte bitsPerValue = this.docIn.readByte();
            if (bitsPerValue > 0) {
                this.forDeltaUtil.decodeAndPrefixSum(bitsPerValue, this.docInUtil, this.prevDocID, this.docBuffer);
                this.encoding = DeltaEncoding.PACKED;
            } else {
                int numLongs;
                assert (this.level0LastDocID != Integer.MAX_VALUE);
                this.docBitSetBase = this.prevDocID + 1;
                if (bitsPerValue == 0) {
                    numLongs = 2;
                    this.docBitSet.set(0, 128);
                } else {
                    numLongs = -bitsPerValue;
                    this.docIn.readLongs(this.docBitSet.getBits(), 0, numLongs);
                }
                if (this.needsFreq) {
                    int i;
                    for (i = 0; i < numLongs - 1; ++i) {
                        this.docCumulativeWordPopCounts[i] = Long.bitCount(this.docBitSet.getBits()[i]);
                    }
                    for (i = 1; i < numLongs - 1; ++i) {
                        int n = i;
                        this.docCumulativeWordPopCounts[n] = this.docCumulativeWordPopCounts[n] + this.docCumulativeWordPopCounts[i - 1];
                    }
                    this.docCumulativeWordPopCounts[numLongs - 1] = 128;
                    assert (this.docCumulativeWordPopCounts[numLongs - 2] + Long.bitCount(this.docBitSet.getBits()[numLongs - 1]) == 128);
                }
                this.encoding = DeltaEncoding.UNARY;
            }
            if (this.indexHasFreq) {
                if (this.needsFreq) {
                    this.freqFP = this.docIn.getFilePointer();
                }
                PForUtil.skip((DataInput)this.docIn);
            }
            this.docCountLeft -= 128;
            this.prevDocID = this.docBuffer[127];
            this.docBufferUpto = 0;
            this.posDocBufferUpto = 0;
        }

        private void refillRemainder() throws IOException {
            assert (this.docCountLeft >= 0 && this.docCountLeft < 128);
            if (this.docFreq == 1) {
                this.docBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = (int)this.totalTermFreq;
                this.docBuffer[1] = Integer.MAX_VALUE;
                assert (this.freqFP == -1L);
                this.docCountLeft = 0;
                this.docBufferSize = 1;
            } else {
                PostingsUtil.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, this.docCountLeft, this.indexHasFreq, this.needsFreq);
                Lucene101PostingsReader.prefixSum(this.docBuffer, this.docCountLeft, this.prevDocID);
                this.docBuffer[this.docCountLeft] = Integer.MAX_VALUE;
                this.freqFP = -1L;
                this.docBufferSize = this.docCountLeft;
                this.docCountLeft = 0;
            }
            this.prevDocID = this.docBuffer[127];
            this.docBufferUpto = 0;
            this.posDocBufferUpto = 0;
            this.encoding = DeltaEncoding.PACKED;
            assert (this.docBuffer[this.docBufferSize] == Integer.MAX_VALUE);
        }

        private void refillDocs() throws IOException {
            assert (this.docCountLeft >= 0);
            if (this.docCountLeft >= 128) {
                this.refillFullBlock();
            } else {
                this.refillRemainder();
            }
        }

        private void skipLevel1To(int target) throws IOException {
            do {
                this.prevDocID = this.level1LastDocID;
                this.level0LastDocID = this.level1LastDocID;
                this.docIn.seek(this.level1DocEndFP);
                this.level0PosEndFP = this.level1PosEndFP;
                this.level0BlockPosUpto = this.level1BlockPosUpto;
                this.level0PayEndFP = this.level1PayEndFP;
                this.level0BlockPayUpto = this.level1BlockPayUpto;
                this.docCountLeft = this.docFreq - this.level1DocCountUpto;
                this.level1DocCountUpto += 4096;
                if (this.docCountLeft < 4096) {
                    this.level1LastDocID = Integer.MAX_VALUE;
                    break;
                }
                this.level1LastDocID += this.docIn.readVInt();
                long delta = this.docIn.readVLong();
                this.level1DocEndFP = delta + this.docIn.getFilePointer();
                if (!this.indexHasFreq) continue;
                long skip1EndFP = (long)this.docIn.readShort() + this.docIn.getFilePointer();
                short numImpactBytes = this.docIn.readShort();
                if (this.needsImpacts && this.level1LastDocID >= target) {
                    this.docIn.readBytes(this.level1SerializedImpacts.bytes, 0, (int)numImpactBytes);
                    this.level1SerializedImpacts.length = numImpactBytes;
                } else {
                    this.docIn.skipBytes((long)numImpactBytes);
                }
                if (this.indexHasPos) {
                    this.level1PosEndFP += this.docIn.readVLong();
                    this.level1BlockPosUpto = this.docIn.readByte();
                    if (this.indexHasOffsetsOrPayloads) {
                        this.level1PayEndFP += this.docIn.readVLong();
                        this.level1BlockPayUpto = this.docIn.readVInt();
                    }
                }
                assert (this.docIn.getFilePointer() == skip1EndFP);
            } while (this.level1LastDocID < target);
        }

        private void doMoveToNextLevel0Block() throws IOException {
            assert (this.doc == this.level0LastDocID);
            if (this.posIn != null) {
                if (this.level0PosEndFP >= this.posIn.getFilePointer()) {
                    this.posIn.seek(this.level0PosEndFP);
                    this.posPendingCount = this.level0BlockPosUpto;
                    if (this.payIn != null) {
                        assert (this.level0PayEndFP >= this.payIn.getFilePointer());
                        this.payIn.seek(this.level0PayEndFP);
                        this.payloadByteUpto = this.level0BlockPayUpto;
                    }
                    this.posBufferUpto = 128;
                } else {
                    assert (this.freqFP == -1L);
                    this.posPendingCount += Lucene101PostingsReader.sumOverRange(this.freqBuffer, this.posDocBufferUpto, 128);
                }
            }
            if (this.docCountLeft >= 128) {
                this.docIn.readVLong();
                int docDelta = Lucene101PostingsReader.readVInt15((DataInput)this.docIn);
                this.level0LastDocID += docDelta;
                long blockLength = Lucene101PostingsReader.readVLong15((DataInput)this.docIn);
                this.level0DocEndFP = this.docIn.getFilePointer() + blockLength;
                if (this.indexHasFreq) {
                    int numImpactBytes = this.docIn.readVInt();
                    if (this.needsImpacts) {
                        this.docIn.readBytes(this.level0SerializedImpacts.bytes, 0, numImpactBytes);
                        this.level0SerializedImpacts.length = numImpactBytes;
                    } else {
                        this.docIn.skipBytes((long)numImpactBytes);
                    }
                    if (this.indexHasPos) {
                        this.level0PosEndFP += this.docIn.readVLong();
                        this.level0BlockPosUpto = this.docIn.readByte();
                        if (this.indexHasOffsetsOrPayloads) {
                            this.level0PayEndFP += this.docIn.readVLong();
                            this.level0BlockPayUpto = this.docIn.readVInt();
                        }
                    }
                }
                this.refillFullBlock();
            } else {
                this.level0LastDocID = Integer.MAX_VALUE;
                this.refillRemainder();
            }
        }

        private void moveToNextLevel0Block() throws IOException {
            if (this.doc == this.level1LastDocID) {
                this.skipLevel1To(this.doc + 1);
            }
            this.prevDocID = this.level0LastDocID;
            if (this.needsDocsAndFreqsOnly && this.docCountLeft >= 128) {
                long level0NumBytes = this.docIn.readVLong();
                long level0End = this.docIn.getFilePointer() + level0NumBytes;
                this.level0LastDocID += Lucene101PostingsReader.readVInt15((DataInput)this.docIn);
                this.docIn.seek(level0End);
                this.refillFullBlock();
            } else {
                this.doMoveToNextLevel0Block();
            }
        }

        private void readLevel0PosData() throws IOException {
            this.level0PosEndFP += this.docIn.readVLong();
            this.level0BlockPosUpto = this.docIn.readByte();
            if (this.indexHasOffsetsOrPayloads) {
                this.level0PayEndFP += this.docIn.readVLong();
                this.level0BlockPayUpto = this.docIn.readVInt();
            }
        }

        private void seekPosData(long posFP, int posUpto, long payFP, int payUpto) throws IOException {
            if (posFP >= this.posIn.getFilePointer()) {
                this.posIn.seek(posFP);
                this.posPendingCount = posUpto;
                if (this.payIn != null) {
                    assert (this.level0PayEndFP >= this.payIn.getFilePointer());
                    this.payIn.seek(payFP);
                    this.payloadByteUpto = payUpto;
                }
                this.posBufferUpto = 128;
            } else {
                this.posPendingCount += Lucene101PostingsReader.sumOverRange(this.freqBuffer, this.posDocBufferUpto, 128);
            }
        }

        private void skipLevel0To(int target) throws IOException {
            int payUpto;
            long payFP;
            int posUpto;
            long posFP;
            block10: {
                while (true) {
                    this.prevDocID = this.level0LastDocID;
                    posFP = this.level0PosEndFP;
                    posUpto = this.level0BlockPosUpto;
                    payFP = this.level0PayEndFP;
                    payUpto = this.level0BlockPayUpto;
                    if (this.docCountLeft < 128) break;
                    long numSkipBytes = this.docIn.readVLong();
                    long skip0End = this.docIn.getFilePointer() + numSkipBytes;
                    int docDelta = Lucene101PostingsReader.readVInt15((DataInput)this.docIn);
                    this.level0LastDocID += docDelta;
                    boolean found = target <= this.level0LastDocID;
                    long blockLength = Lucene101PostingsReader.readVLong15((DataInput)this.docIn);
                    this.level0DocEndFP = this.docIn.getFilePointer() + blockLength;
                    if (this.indexHasFreq) {
                        if (!found && !this.needsPos) {
                            this.docIn.seek(skip0End);
                        } else {
                            int numImpactBytes = this.docIn.readVInt();
                            if (this.needsImpacts && found) {
                                this.docIn.readBytes(this.level0SerializedImpacts.bytes, 0, numImpactBytes);
                                this.level0SerializedImpacts.length = numImpactBytes;
                            } else {
                                this.docIn.skipBytes((long)numImpactBytes);
                            }
                            if (this.needsPos) {
                                this.readLevel0PosData();
                            } else {
                                this.docIn.seek(skip0End);
                            }
                        }
                    }
                    if (!found) {
                        this.docIn.seek(this.level0DocEndFP);
                        this.docCountLeft -= 128;
                        continue;
                    }
                    break block10;
                    break;
                }
                this.level0LastDocID = Integer.MAX_VALUE;
            }
            if (this.posIn != null) {
                this.seekPosData(posFP, posUpto, payFP, payUpto);
            }
        }

        public void advanceShallow(int target) throws IOException {
            if (target > this.level0LastDocID) {
                this.doAdvanceShallow(target);
                this.needsRefilling = true;
            }
        }

        private void doAdvanceShallow(int target) throws IOException {
            if (target > this.level1LastDocID) {
                this.skipLevel1To(target);
            } else if (this.needsRefilling) {
                this.docIn.seek(this.level0DocEndFP);
                this.docCountLeft -= 128;
            }
            this.skipLevel0To(target);
        }

        public int nextDoc() throws IOException {
            if (this.doc == this.level0LastDocID || this.needsRefilling) {
                if (this.needsRefilling) {
                    this.refillDocs();
                    this.needsRefilling = false;
                } else {
                    this.moveToNextLevel0Block();
                }
            }
            switch (this.encoding.ordinal()) {
                case 0: {
                    this.doc = this.docBuffer[this.docBufferUpto];
                    break;
                }
                case 1: {
                    int next = this.docBitSet.nextSetBit(this.doc - this.docBitSetBase + 1);
                    assert (next != Integer.MAX_VALUE);
                    this.doc = this.docBitSetBase + next;
                }
            }
            ++this.docBufferUpto;
            return this.doc;
        }

        public int advance(int target) throws IOException {
            if (target > this.level0LastDocID || this.needsRefilling) {
                if (target > this.level0LastDocID) {
                    this.doAdvanceShallow(target);
                }
                this.refillDocs();
                this.needsRefilling = false;
            }
            switch (this.encoding.ordinal()) {
                case 0: {
                    int next = VectorUtil.findNextGEQ((int[])this.docBuffer, (int)target, (int)this.docBufferUpto, (int)this.docBufferSize);
                    this.doc = this.docBuffer[next];
                    this.docBufferUpto = next + 1;
                    break;
                }
                case 1: {
                    int next = this.docBitSet.nextSetBit(target - this.docBitSetBase);
                    assert (next != Integer.MAX_VALUE);
                    this.doc = this.docBitSetBase + next;
                    if (this.needsFreq) {
                        int wordIndex = next >> 6;
                        this.docBufferUpto = 1 + this.docCumulativeWordPopCounts[wordIndex] - Long.bitCount(this.docBitSet.getBits()[wordIndex] >>> next);
                        break;
                    }
                    this.docBufferUpto = 1;
                }
            }
            return this.doc;
        }

        public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
            if (this.doc >= upTo) {
                return;
            }
            bitSet.set(this.doc - offset);
            block4: while (true) {
                if (this.doc == this.level0LastDocID) {
                    this.moveToNextLevel0Block();
                }
                switch (this.encoding.ordinal()) {
                    case 0: {
                        int start = this.docBufferUpto;
                        int end = this.computeBufferEndBoundary(upTo);
                        if (end != 0) {
                            this.bufferIntoBitSet(start, end, bitSet, offset);
                            this.doc = this.docBuffer[end - 1];
                        }
                        this.docBufferUpto = end;
                        if (end == 128) continue block4;
                        this.nextDoc();
                        assert (this.doc >= upTo);
                        return;
                    }
                    case 1: {
                        int sourceFrom = this.docBufferUpto == 0 ? 0 : this.doc - this.docBitSetBase + 1;
                        int destFrom = this.docBitSetBase - offset + sourceFrom;
                        assert (this.level0LastDocID != Integer.MAX_VALUE);
                        int sourceTo = Math.min(upTo, this.level0LastDocID + 1) - this.docBitSetBase;
                        if (sourceTo > sourceFrom) {
                            FixedBitSet.orRange((FixedBitSet)this.docBitSet, (int)sourceFrom, (FixedBitSet)bitSet, (int)destFrom, (int)(sourceTo - sourceFrom));
                        }
                        if (this.docBitSetBase + sourceTo <= this.level0LastDocID) {
                            this.advance(this.docBitSetBase + sourceTo);
                            return;
                        }
                        this.doc = this.level0LastDocID;
                        this.docBufferUpto = 128;
                    }
                }
            }
        }

        private int computeBufferEndBoundary(int upTo) {
            if (this.docBufferSize != 0 && this.docBuffer[this.docBufferSize - 1] < upTo) {
                return this.docBufferSize;
            }
            return VectorUtil.findNextGEQ((int[])this.docBuffer, (int)upTo, (int)this.docBufferUpto, (int)this.docBufferSize);
        }

        private void bufferIntoBitSet(int start, int end, FixedBitSet bitSet, int offset) throws IOException {
            for (int i = start; i < end; ++i) {
                int doc = this.docBuffer[i];
                bitSet.set(doc - offset);
            }
        }

        public int docIDRunEnd() throws IOException {
            boolean level0IsDense;
            long blockSize = 128L;
            assert (blockSize == 128L);
            boolean bl = level0IsDense = this.encoding == DeltaEncoding.UNARY && this.docBitSet.getBits()[0] == -1L && this.docBitSet.getBits()[1] == -1L;
            if (level0IsDense) {
                boolean level1IsDense;
                int level0DocCountUpto = this.docFreq - this.docCountLeft;
                boolean bl2 = level1IsDense = this.level1LastDocID - this.level0LastDocID == this.level1DocCountUpto - level0DocCountUpto;
                if (level1IsDense) {
                    return this.level1LastDocID + 1;
                }
                return this.level0LastDocID + 1;
            }
            return super.docIDRunEnd();
        }

        private void skipPositions(int freq) throws IOException {
            int toSkip = this.posPendingCount - freq;
            int leftInBlock = 128 - this.posBufferUpto;
            if (toSkip < leftInBlock) {
                int end = this.posBufferUpto + toSkip;
                if (this.needsPayloads) {
                    this.payloadByteUpto += Lucene101PostingsReader.sumOverRange(this.payloadLengthBuffer, this.posBufferUpto, end);
                }
                this.posBufferUpto = end;
            } else {
                toSkip -= leftInBlock;
                while (toSkip >= 128) {
                    assert (this.posIn.getFilePointer() != this.lastPosBlockFP);
                    PForUtil.skip((DataInput)this.posIn);
                    if (this.payIn != null) {
                        if (this.indexHasPayloads) {
                            PForUtil.skip((DataInput)this.payIn);
                            int numBytes = this.payIn.readVInt();
                            this.payIn.seek(this.payIn.getFilePointer() + (long)numBytes);
                        }
                        if (this.indexHasOffsets) {
                            PForUtil.skip((DataInput)this.payIn);
                            PForUtil.skip((DataInput)this.payIn);
                        }
                    }
                    toSkip -= 128;
                }
                this.refillPositions();
                if (this.needsPayloads) {
                    this.payloadByteUpto = Lucene101PostingsReader.sumOverRange(this.payloadLengthBuffer, 0, toSkip);
                }
                this.posBufferUpto = toSkip;
            }
        }

        private void refillLastPositionBlock() throws IOException {
            int count = (int)(this.totalTermFreq % 128L);
            int payloadLength = 0;
            int offsetLength = 0;
            this.payloadByteUpto = 0;
            for (int i = 0; i < count; ++i) {
                int code = this.posIn.readVInt();
                if (this.indexHasPayloads) {
                    if ((code & 1) != 0) {
                        payloadLength = this.posIn.readVInt();
                    }
                    if (this.payloadLengthBuffer != null) {
                        this.payloadLengthBuffer[i] = payloadLength;
                        this.posDeltaBuffer[i] = code >>> 1;
                        if (payloadLength != 0) {
                            if (this.payloadByteUpto + payloadLength > this.payloadBytes.length) {
                                this.payloadBytes = ArrayUtil.grow((byte[])this.payloadBytes, (int)(this.payloadByteUpto + payloadLength));
                            }
                            this.posIn.readBytes(this.payloadBytes, this.payloadByteUpto, payloadLength);
                            this.payloadByteUpto += payloadLength;
                        }
                    } else {
                        this.posIn.skipBytes((long)payloadLength);
                    }
                } else {
                    this.posDeltaBuffer[i] = code;
                }
                if (!this.indexHasOffsets) continue;
                int deltaCode = this.posIn.readVInt();
                if ((deltaCode & 1) != 0) {
                    offsetLength = this.posIn.readVInt();
                }
                if (this.offsetStartDeltaBuffer == null) continue;
                this.offsetStartDeltaBuffer[i] = deltaCode >>> 1;
                this.offsetLengthBuffer[i] = offsetLength;
            }
            this.payloadByteUpto = 0;
        }

        private void refillOffsetsOrPayloads() throws IOException {
            if (this.indexHasPayloads) {
                if (this.needsPayloads) {
                    this.pforUtil.decode(this.payInUtil, this.payloadLengthBuffer);
                    int numBytes = this.payIn.readVInt();
                    if (numBytes > this.payloadBytes.length) {
                        this.payloadBytes = ArrayUtil.growNoCopy((byte[])this.payloadBytes, (int)numBytes);
                    }
                    this.payIn.readBytes(this.payloadBytes, 0, numBytes);
                } else if (this.payIn != null) {
                    PForUtil.skip((DataInput)this.payIn);
                    int numBytes = this.payIn.readVInt();
                    this.payIn.seek(this.payIn.getFilePointer() + (long)numBytes);
                }
                this.payloadByteUpto = 0;
            }
            if (this.indexHasOffsets) {
                if (this.needsOffsets) {
                    this.pforUtil.decode(this.payInUtil, this.offsetStartDeltaBuffer);
                    this.pforUtil.decode(this.payInUtil, this.offsetLengthBuffer);
                } else if (this.payIn != null) {
                    PForUtil.skip((DataInput)this.payIn);
                    PForUtil.skip((DataInput)this.payIn);
                }
            }
        }

        private void refillPositions() throws IOException {
            if (this.posIn.getFilePointer() == this.lastPosBlockFP) {
                this.refillLastPositionBlock();
                return;
            }
            this.pforUtil.decode(this.posInUtil, this.posDeltaBuffer);
            if (this.indexHasOffsetsOrPayloads) {
                this.refillOffsetsOrPayloads();
            }
        }

        private void accumulatePendingPositions() throws IOException {
            int freq = this.freq();
            this.posPendingCount += Lucene101PostingsReader.sumOverRange(this.freqBuffer, this.posDocBufferUpto, this.docBufferUpto);
            this.posDocBufferUpto = this.docBufferUpto;
            assert (this.posPendingCount > 0);
            if (this.posPendingCount > freq) {
                this.skipPositions(freq);
                this.posPendingCount = freq;
            }
        }

        private void accumulatePayloadAndOffsets() {
            if (this.needsPayloads) {
                this.payloadLength = this.payloadLengthBuffer[this.posBufferUpto];
                this.payload.bytes = this.payloadBytes;
                this.payload.offset = this.payloadByteUpto;
                this.payload.length = this.payloadLength;
                this.payloadByteUpto += this.payloadLength;
            }
            if (this.needsOffsets) {
                this.startOffset = this.lastStartOffset + this.offsetStartDeltaBuffer[this.posBufferUpto];
                this.endOffset = this.startOffset + this.offsetLengthBuffer[this.posBufferUpto];
                this.lastStartOffset = this.startOffset;
            }
        }

        public int nextPosition() throws IOException {
            if (!this.needsPos) {
                return -1;
            }
            assert (this.posDocBufferUpto <= this.docBufferUpto);
            if (this.posDocBufferUpto != this.docBufferUpto) {
                this.accumulatePendingPositions();
                this.position = 0;
                this.lastStartOffset = 0;
            }
            if (this.posBufferUpto == 128) {
                this.refillPositions();
                this.posBufferUpto = 0;
            }
            this.position += this.posDeltaBuffer[this.posBufferUpto];
            if (this.needsOffsetsOrPayloads) {
                this.accumulatePayloadAndOffsets();
            }
            ++this.posBufferUpto;
            --this.posPendingCount;
            return this.position;
        }

        public int startOffset() {
            if (!this.needsOffsets) {
                return -1;
            }
            return this.startOffset;
        }

        public int endOffset() {
            if (!this.needsOffsets) {
                return -1;
            }
            return this.endOffset;
        }

        public BytesRef getPayload() {
            if (!this.needsPayloads || this.payloadLength == 0) {
                return null;
            }
            return this.payload;
        }

        public long cost() {
            return this.docFreq;
        }

        public Impacts getImpacts() {
            assert (this.needsImpacts);
            return this.impacts;
        }

        private static enum DeltaEncoding {
            PACKED,
            UNARY;

        }
    }

    static class MutableImpactList
    extends AbstractList<Impact>
    implements RandomAccess {
        int length;
        final Impact[] impacts;

        MutableImpactList(int capacity) {
            this.impacts = new Impact[capacity];
            for (int i = 0; i < capacity; ++i) {
                this.impacts[i] = new Impact(Integer.MAX_VALUE, 1L);
            }
        }

        @Override
        public Impact get(int index) {
            return this.impacts[index];
        }

        @Override
        public int size() {
            return this.length;
        }
    }
}

