/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.EdECPublicKey;
import java.security.spec.EdECPoint;
import java.security.spec.NamedParameterSpec;
import org.bouncycastle.crypto.asymmetric.AsymmetricEdDSAPublicKey;
import org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.util.Arrays;

class Prov15EdDSAPublicKey
implements EdECPublicKey,
EdDSAPublicKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricEdDSAPublicKey baseKey;

    Prov15EdDSAPublicKey(AsymmetricEdDSAPublicKey asymmetricEdDSAPublicKey) {
        this.baseKey = asymmetricEdDSAPublicKey;
    }

    Prov15EdDSAPublicKey(byte[] byArray) {
        this.baseKey = new AsymmetricEdDSAPublicKey(byArray);
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getPublicData() {
        return this.baseKey.getPublicData();
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public AsymmetricEdDSAPublicKey getBaseKey() {
        return this.baseKey;
    }

    public String toString() {
        return KeyUtil.keyToString("Public Key", this.getAlgorithm(), this.baseKey);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EdECPublicKey)) {
            return false;
        }
        EdECPublicKey edECPublicKey = (EdECPublicKey)object;
        return Arrays.areEqual(edECPublicKey.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricEdDSAPublicKey(byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public EdECPoint getPoint() {
        byte[] byArray = this.baseKey.getPublicData();
        Arrays.reverseInPlace(byArray);
        boolean bl = (byArray[0] & 0x80) != 0;
        byArray[0] = (byte)(byArray[0] & 0x7F);
        return new EdECPoint(bl, new BigInteger(1, byArray));
    }

    @Override
    public NamedParameterSpec getParams() {
        if (this.baseKey.getAlgorithm().getName().startsWith("Ed448")) {
            return NamedParameterSpec.ED448;
        }
        return NamedParameterSpec.ED25519;
    }
}

