/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_relevance;

import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.search_relevance.GetQuerySetsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class GetQuerySetsRequest
extends RequestBase
implements ToCopyableBuilder<Builder, GetQuerySetsRequest> {
    @Nullable
    private final String querySetId;
    public static final Endpoint<GetQuerySetsRequest, GetQuerySetsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetQuerySetsRequest, GetQuerySetsResponse>(request -> "GET", request -> {
        boolean _querySetId = true;
        boolean propsSet = false;
        if (request.querySetId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_plugins/_search_relevance/query_sets";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_plugins/_search_relevance/query_sets/");
            SimpleEndpoint.pathEncode(request.querySetId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetQuerySetsResponse._DESERIALIZER);

    private GetQuerySetsRequest(Builder builder) {
        super(builder);
        this.querySetId = builder.querySetId;
    }

    public static GetQuerySetsRequest of(Function<Builder, ObjectBuilder<GetQuerySetsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String querySetId() {
        return this.querySetId;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.querySetId);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetQuerySetsRequest other = (GetQuerySetsRequest)o;
        return Objects.equals(this.querySetId, other.querySetId);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GetQuerySetsRequest> {
        @Nullable
        private String querySetId;

        public Builder() {
        }

        private Builder(GetQuerySetsRequest o) {
            super(o);
            this.querySetId = o.querySetId;
        }

        private Builder(Builder o) {
            super(o);
            this.querySetId = o.querySetId;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder querySetId(@Nullable String value) {
            this.querySetId = value;
            return this;
        }

        @Override
        @Nonnull
        public GetQuerySetsRequest build() {
            this._checkSingleUse();
            return new GetQuerySetsRequest(this);
        }
    }
}

