/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.alertsv2;

import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.rollover.RolloverResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.alerting.alertsv2.AlertV2Indices;
import org.opensearch.alerting.alertsv2.AlertV2IndicesKt;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.util.IndexUtils;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 Q2\u00020\u0001:\u0001QB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#J\b\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020#H\u0002J\u000e\u0010+\u001a\u00020#H\u0086@\u00a2\u0006\u0002\u0010,J\u000e\u0010-\u001a\u00020#H\u0086@\u00a2\u0006\u0002\u0010,J\u0006\u0010.\u001a\u00020\rJ\b\u0010/\u001a\u00020#H\u0002J*\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020&2\n\b\u0002\u00103\u001a\u0004\u0018\u00010&H\u0082@\u00a2\u0006\u0002\u00104J(\u00105\u001a\u00020#2\u0006\u00101\u001a\u00020&2\u0006\u00106\u001a\u00020&2\b\b\u0002\u00103\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u00107J\u0018\u00108\u001a\u00020#2\u0006\u00101\u001a\u00020&2\u0006\u00109\u001a\u00020&H\u0002J@\u0010:\u001a\u00020#2\u0006\u0010;\u001a\u00020\r2\u0006\u00101\u001a\u00020&2\u0006\u0010<\u001a\u00020&2\u0006\u0010=\u001a\u00020&2\u0006\u0010>\u001a\u00020\u00112\u0006\u0010?\u001a\u00020\u00142\u0006\u0010@\u001a\u00020&H\u0002J\b\u0010A\u001a\u00020#H\u0002J\u0018\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020&2\u0006\u0010D\u001a\u00020&H\u0002J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020&0F2\u0006\u0010G\u001a\u00020HH\u0002J*\u0010I\u001a\u0004\u0018\u00010&2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u00112\u0006\u0010@\u001a\u00020&2\u0006\u0010M\u001a\u00020\rH\u0002J\u0016\u0010N\u001a\u00020#2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020&0FH\u0002J\u0016\u0010P\u001a\u00020#2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020&0FH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0018\u0010\u0010\u001a\n \u000e*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0016\u0010\u0013\u001a\n \u000e*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u000e*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u000e*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u000e*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/opensearch/alerting/alertsv2/AlertV2Indices;", "Lorg/opensearch/cluster/ClusterStateListener;", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/transport/client/Client;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "<init>", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/transport/client/Client;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/cluster/service/ClusterService;)V", "alertV2HistoryEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "alertV2HistoryMaxDocs", "", "Ljava/lang/Long;", "alertV2HistoryMaxAge", "Lorg/opensearch/common/unit/TimeValue;", "alertV2HistoryRolloverPeriod", "alertV2HistoryRetentionPeriod", "requestTimeout", "isClusterManager", "lastRolloverTime", "getLastRolloverTime", "()Lorg/opensearch/common/unit/TimeValue;", "setLastRolloverTime", "(Lorg/opensearch/common/unit/TimeValue;)V", "alertV2HistoryIndexInitialized", "alertV2IndexInitialized", "scheduledAlertV2Rollover", "Lorg/opensearch/threadpool/Scheduler$Cancellable;", "onClusterManager", "", "offClusterManager", "executorName", "", "clusterChanged", "event", "Lorg/opensearch/cluster/ClusterChangedEvent;", "rescheduleAlertRollover", "createOrUpdateAlertV2Index", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createOrUpdateInitialAlertV2HistoryIndex", "isAlertV2Initialized", "rolloverAndDeleteAlertV2HistoryIndices", "createIndex", "index", "schemaMapping", "alias", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateIndexMapping", "mapping", "(Ljava/lang/String;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setIndexUpdateFlag", "targetIndex", "rolloverIndex", "initialized", "pattern", "map", "docsCondition", "ageCondition", "writeIndex", "rolloverAlertV2HistoryIndex", "deleteOldIndices", "tag", "indices", "getIndicesToDelete", "", "clusterStateResponse", "Lorg/opensearch/action/admin/cluster/state/ClusterStateResponse;", "getHistoryIndexToDelete", "indexMetadata", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "retentionPeriodMillis", "historyEnabled", "deleteAllOldHistoryIndices", "indicesToDelete", "deleteOldHistoryIndex", "Companion", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nAlertV2Indices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertV2Indices.kt\norg/opensearch/alerting/alertsv2/AlertV2Indices\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,419:1\n1#2:420\n295#3,2:421\n37#4:423\n36#4,3:424\n37#4:427\n36#4,3:428\n*S KotlinDebug\n*F\n+ 1 AlertV2Indices.kt\norg/opensearch/alerting/alertsv2/AlertV2Indices\n*L\n359#1:421,2\n377#1:423\n377#1:424,3\n400#1:427\n400#1:428,3\n*E\n"})
public final class AlertV2Indices
implements ClusterStateListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final ClusterService clusterService;
    private volatile Boolean alertV2HistoryEnabled;
    private volatile Long alertV2HistoryMaxDocs;
    private volatile TimeValue alertV2HistoryMaxAge;
    private volatile TimeValue alertV2HistoryRolloverPeriod;
    private volatile TimeValue alertV2HistoryRetentionPeriod;
    private volatile TimeValue requestTimeout;
    private volatile boolean isClusterManager;
    @Nullable
    private TimeValue lastRolloverTime;
    private boolean alertV2HistoryIndexInitialized;
    private boolean alertV2IndexInitialized;
    @Nullable
    private Scheduler.Cancellable scheduledAlertV2Rollover;
    @NotNull
    public static final String ALERT_V2_INDEX = ".opensearch-alerting-v2-alerts";
    @NotNull
    public static final String ALERT_V2_HISTORY_WRITE_INDEX = ".opensearch-alerting-v2-alert-history-write";
    @NotNull
    public static final String ALERT_V2_HISTORY_ALL = ".opensearch-alerting-v2-alert-history*";
    @NotNull
    public static final String ALERT_V2_HISTORY_INDEX_PATTERN = "<.opensearch-alerting-v2-alert-history-{now/d}-1>";
    @NotNull
    public static final String ALL_ALERT_V2_INDEX_PATTERN = ".opensearch-alerting-v2-alert*";

    public AlertV2Indices(@NotNull Settings settings, @NotNull Client client, @NotNull ThreadPool threadPool, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_V2_HISTORY_ENABLED(), arg_0 -> AlertV2Indices._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_V2_HISTORY_MAX_DOCS(), arg_0 -> AlertV2Indices._init_$lambda$1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_V2_HISTORY_INDEX_MAX_AGE(), arg_0 -> AlertV2Indices._init_$lambda$2(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_V2_HISTORY_ROLLOVER_PERIOD(), arg_0 -> AlertV2Indices._init_$lambda$3(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERT_V2_HISTORY_RETENTION_PERIOD(), arg_0 -> AlertV2Indices._init_$lambda$4(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getREQUEST_TIMEOUT(), arg_0 -> AlertV2Indices._init_$lambda$5(this, arg_0));
        this.alertV2HistoryEnabled = (Boolean)AlertingSettings.Companion.getALERT_V2_HISTORY_ENABLED().get(settings);
        this.alertV2HistoryMaxDocs = (Long)AlertingSettings.Companion.getALERT_V2_HISTORY_MAX_DOCS().get(settings);
        this.alertV2HistoryMaxAge = (TimeValue)AlertingSettings.Companion.getALERT_V2_HISTORY_INDEX_MAX_AGE().get(settings);
        this.alertV2HistoryRolloverPeriod = (TimeValue)AlertingSettings.Companion.getALERT_V2_HISTORY_ROLLOVER_PERIOD().get(settings);
        this.alertV2HistoryRetentionPeriod = (TimeValue)AlertingSettings.Companion.getALERT_V2_HISTORY_RETENTION_PERIOD().get(settings);
        this.requestTimeout = (TimeValue)AlertingSettings.Companion.getREQUEST_TIMEOUT().get(settings);
    }

    @Nullable
    public final TimeValue getLastRolloverTime() {
        return this.lastRolloverTime;
    }

    public final void setLastRolloverTime(@Nullable TimeValue timeValue) {
        this.lastRolloverTime = timeValue;
    }

    public final void onClusterManager() {
        try {
            this.rolloverAlertV2HistoryIndex();
            this.scheduledAlertV2Rollover = this.threadPool.scheduleWithFixedDelay(() -> AlertV2Indices.onClusterManager$lambda$6(this), this.alertV2HistoryRolloverPeriod, this.executorName());
        }
        catch (Exception e) {
            AlertV2IndicesKt.access$getLogger$p().error("Error rolling over alerts v2 history index.", (Throwable)e);
        }
    }

    public final void offClusterManager() {
        block0: {
            Scheduler.Cancellable cancellable = this.scheduledAlertV2Rollover;
            if (cancellable == null) break block0;
            cancellable.cancel();
        }
    }

    private final String executorName() {
        return "management";
    }

    public void clusterChanged(@NotNull ClusterChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isClusterManager != event.localNodeClusterManager()) {
            this.isClusterManager = event.localNodeClusterManager();
            if (this.isClusterManager) {
                this.onClusterManager();
            } else {
                this.offClusterManager();
            }
        }
        this.alertV2IndexInitialized = event.state().routingTable().hasIndex(ALERT_V2_INDEX);
        this.alertV2HistoryIndexInitialized = event.state().metadata().hasAlias(ALERT_V2_HISTORY_WRITE_INDEX);
    }

    private final void rescheduleAlertRollover() {
        if (this.clusterService.state().getNodes().isLocalNodeElectedClusterManager()) {
            Scheduler.Cancellable cancellable = this.scheduledAlertV2Rollover;
            if (cancellable != null) {
                cancellable.cancel();
            }
            this.scheduledAlertV2Rollover = this.threadPool.scheduleWithFixedDelay(() -> AlertV2Indices.rescheduleAlertRollover$lambda$7(this), this.alertV2HistoryRolloverPeriod, this.executorName());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createOrUpdateAlertV2Index(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof createOrUpdateAlertV2Index.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AlertV2Indices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createOrUpdateAlertV2Index((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.alertV2IndexInitialized) break;
                var2_5 = this;
                $continuation.L$0 = var2_5;
                $continuation.label = 1;
                v0 = AlertV2Indices.createIndex$default(this, ".opensearch-alerting-v2-alerts", AlertV2Indices.Companion.alertV2Mapping(), null, (Continuation)$continuation, 4, null);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                var2_5 = (AlertV2Indices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                var2_5.alertV2IndexInitialized = (Boolean)v0;
                if (this.alertV2IndexInitialized) {
                    IndexUtils.Companion.alertIndexUpdated();
                }
                ** GOTO lbl38
            }
        }
        if (!IndexUtils.Companion.getAlertIndexUpdated()) {
            $continuation.label = 2;
            v1 = AlertV2Indices.updateIndexMapping$default(this, ".opensearch-alerting-v2-alerts", AlertV2Indices.Companion.alertV2Mapping(), false, (Continuation)$continuation, 4, null);
            if (v1 == var5_4) {
                return var5_4;
            }
        }
        ** GOTO lbl38
        {
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createOrUpdateInitialAlertV2HistoryIndex(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof createOrUpdateInitialAlertV2HistoryIndex.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AlertV2Indices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createOrUpdateInitialAlertV2HistoryIndex((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.alertV2HistoryIndexInitialized) break;
                var2_5 = this;
                $continuation.L$0 = var2_5;
                $continuation.label = 1;
                v0 = this.createIndex("<.opensearch-alerting-v2-alert-history-{now/d}-1>", AlertV2Indices.Companion.alertV2Mapping(), ".opensearch-alerting-v2-alert-history-write", (Continuation<? super Boolean>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                var2_5 = (AlertV2Indices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                var2_5.alertV2HistoryIndexInitialized = (Boolean)v0;
                if (this.alertV2HistoryIndexInitialized) {
                    v1 = this.clusterService.state();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"state(...)");
                    IndexUtils.Companion.setLastUpdatedAlertV2HistoryIndex(IndexUtils.Companion.getIndexNameWithAlias(v1, ".opensearch-alerting-v2-alert-history-write"));
                }
                ** GOTO lbl39
            }
        }
        $continuation.label = 2;
        v2 = this.updateIndexMapping(".opensearch-alerting-v2-alert-history-write", AlertV2Indices.Companion.alertV2Mapping(), true, (Continuation<? super Unit>)$continuation);
        if (v2 == var5_4) {
            return var5_4;
        }
        ** GOTO lbl39
        {
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl39:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean isAlertV2Initialized() {
        return this.alertV2IndexInitialized && this.alertV2HistoryIndexInitialized;
    }

    private final void rolloverAndDeleteAlertV2HistoryIndices() {
        if (this.alertV2HistoryEnabled.booleanValue()) {
            this.rolloverAlertV2HistoryIndex();
        }
        this.deleteOldIndices("History", ALERT_V2_HISTORY_ALL);
    }

    /*
     * Unable to fully structure code
     */
    private final Object createIndex(String index, String schemaMapping, String alias, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof createIndex.1)) ** GOTO lbl-1000
        var10_5 = $completion;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ AlertV2Indices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AlertV2Indices.access$createIndex(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = index;
                $continuation.L$1 = schemaMapping;
                $continuation.L$2 = alias;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client.admin().indices()), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, createIndex$lambda$8(java.lang.String org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((String)index), (Continuation)$continuation);
                if (v0 == var11_7) {
                    return var11_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                alias = (String)$continuation.L$2;
                schemaMapping = (String)$continuation.L$1;
                index = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if ((existsResponse = (IndicesExistsResponse)v0).isExists()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                AlertV2IndicesKt.access$getLogger$p().debug("index: [" + index + "] schema mappings: [" + schemaMapping + "]");
                request = new CreateIndexRequest(index).mapping(schemaMapping).settings(Settings.builder().put("index.hidden", true).build());
                if (alias != null) {
                    request.alias(new Alias(alias));
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)index);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)schemaMapping);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)alias);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)existsResponse);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.label = 2;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client.admin().indices()), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, createIndex$lambda$9(org.opensearch.action.admin.indices.create.CreateIndexRequest org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((CreateIndexRequest)request), (Continuation)$continuation);
                ** if (v1 != var11_7) goto lbl44
lbl43:
                // 1 sources

                return var11_7;
lbl44:
                // 1 sources

                ** GOTO lbl55
            }
            case 2: {
                request = (CreateIndexRequest)$continuation.L$4;
                existsResponse = (IndicesExistsResponse)$continuation.L$3;
                alias = (String)$continuation.L$2;
                schemaMapping = (String)$continuation.L$1;
                index = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl55:
                    // 2 sources

                    createIndexResponse = (CreateIndexResponse)v1;
                    var7_13 = createIndexResponse.isAcknowledged();
                }
                catch (Exception t) {
                    if (!(ExceptionsHelper.unwrapCause((Throwable)t) instanceof ResourceAlreadyExistsException)) {
                        throw AlertingException.Companion.wrap(t);
                    }
                    var7_13 = true;
                }
                return Boxing.boxBoolean((boolean)(var7_13 != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object createIndex$default(AlertV2Indices alertV2Indices, String string, String string2, String string3, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return alertV2Indices.createIndex(string, string2, string3, (Continuation<? super Boolean>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateIndexMapping(String index, String mapping, boolean alias, Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateIndexMapping.1)) ** GOTO lbl-1000
        var11_5 = $completion;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ AlertV2Indices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AlertV2Indices.access$updateIndexMapping(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                clusterState = this.clusterService.state();
                targetIndex = index;
                if (alias) {
                    Intrinsics.checkNotNull((Object)clusterState);
                    targetIndex = IndexUtils.Companion.getIndexNameWithAlias(clusterState, index);
                }
                if (Intrinsics.areEqual((Object)targetIndex, (Object)IndexUtils.Companion.getLastUpdatedAlertV2HistoryIndex())) {
                    return Unit.INSTANCE;
                }
                var9_11 = new String[]{targetIndex};
                v0 = new PutMappingRequest(var9_11).source(mapping, (MediaType)XContentType.JSON);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"source(...)");
                putMappingRequest = v0;
                $continuation.L$0 = index;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)mapping);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)clusterState);
                $continuation.L$3 = targetIndex;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)putMappingRequest);
                $continuation.Z$0 = alias;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client.admin().indices()), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, updateIndexMapping$lambda$10(org.opensearch.action.admin.indices.mapping.put.PutMappingRequest org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((PutMappingRequest)putMappingRequest), (Continuation)$continuation);
                if (v1 == var12_7) {
                    return var12_7;
                }
                ** GOTO lbl43
            }
            case 1: {
                alias = $continuation.Z$0;
                putMappingRequest = (PutMappingRequest)$continuation.L$4;
                targetIndex = (String)$continuation.L$3;
                clusterState = (ClusterState)$continuation.L$2;
                mapping = (String)$continuation.L$1;
                index = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                if ((updateResponse = (AcknowledgedResponse)v1).isAcknowledged()) {
                    AlertV2IndicesKt.access$getLogger$p().info("Index mapping of " + targetIndex + " is updated");
                    this.setIndexUpdateFlag(index, targetIndex);
                } else {
                    AlertV2IndicesKt.access$getLogger$p().info("Failed to update index mapping of " + targetIndex);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object updateIndexMapping$default(AlertV2Indices alertV2Indices, String string, String string2, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return alertV2Indices.updateIndexMapping(string, string2, bl, (Continuation<? super Unit>)continuation);
    }

    private final void setIndexUpdateFlag(String index, String targetIndex) {
        String string = index;
        if (Intrinsics.areEqual((Object)string, (Object)ALERT_V2_INDEX)) {
            IndexUtils.Companion.alertV2IndexUpdated();
        } else if (Intrinsics.areEqual((Object)string, (Object)ALERT_V2_HISTORY_WRITE_INDEX)) {
            IndexUtils.Companion.setLastUpdatedAlertV2HistoryIndex(targetIndex);
        }
    }

    private final void rolloverIndex(boolean initialized, String index, String pattern, String map, long docsCondition, TimeValue ageCondition, String writeIndex) {
        if (!initialized) {
            return;
        }
        RolloverRequest request = new RolloverRequest(index, null);
        request.getCreateIndexRequest().index(pattern).mapping(map).settings(Settings.builder().put("index.hidden", true).build());
        request.addMaxIndexDocsCondition(docsCondition);
        request.addMaxIndexAgeCondition(ageCondition);
        this.client.admin().indices().rolloverIndex(request, (ActionListener)new ActionListener<RolloverResponse>(writeIndex, this){
            final /* synthetic */ String $writeIndex;
            final /* synthetic */ AlertV2Indices this$0;
            {
                this.$writeIndex = $writeIndex;
                this.this$0 = $receiver;
            }

            public void onResponse(RolloverResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.isRolledOver()) {
                    AlertV2IndicesKt.access$getLogger$p().info(this.$writeIndex + " not rolled over. Conditions were: " + response2.getConditionStatus());
                } else {
                    this.this$0.setLastRolloverTime(TimeValue.timeValueMillis((long)AlertV2Indices.access$getThreadPool$p(this.this$0).absoluteTimeInMillis()));
                }
            }

            public void onFailure(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AlertV2IndicesKt.access$getLogger$p().error(this.$writeIndex + " not roll over failed.");
            }
        });
    }

    private final void rolloverAlertV2HistoryIndex() {
        String string = Companion.alertV2Mapping();
        Long l = this.alertV2HistoryMaxDocs;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"alertV2HistoryMaxDocs");
        long l2 = ((Number)l).longValue();
        TimeValue timeValue = this.alertV2HistoryMaxAge;
        Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"alertV2HistoryMaxAge");
        this.rolloverIndex(this.alertV2HistoryIndexInitialized, ALERT_V2_HISTORY_WRITE_INDEX, ALERT_V2_HISTORY_INDEX_PATTERN, string, l2, timeValue, ALERT_V2_HISTORY_WRITE_INDEX);
    }

    private final void deleteOldIndices(String tag, String indices) {
        String[] stringArray = new String[]{indices};
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(stringArray).metadata(true).local(true)).indicesOptions(IndicesOptions.strictExpand());
        this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(tag, this){
            final /* synthetic */ String $tag;
            final /* synthetic */ AlertV2Indices this$0;
            {
                this.$tag = $tag;
                this.this$0 = $receiver;
            }

            public void onResponse(ClusterStateResponse clusterStateResponse) {
                Intrinsics.checkNotNullParameter((Object)clusterStateResponse, (String)"clusterStateResponse");
                Map map = clusterStateResponse.getState().getMetadata().getIndices();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getIndices(...)");
                if (!map.isEmpty()) {
                    BuildersKt.launch$default((CoroutineScope)AlertV2IndicesKt.access$getScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, clusterStateResponse, this.$tag, null){
                        int label;
                        final /* synthetic */ AlertV2Indices this$0;
                        final /* synthetic */ ClusterStateResponse $clusterStateResponse;
                        final /* synthetic */ String $tag;
                        {
                            this.this$0 = $receiver;
                            this.$clusterStateResponse = $clusterStateResponse;
                            this.$tag = $tag;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    List indicesToDelete = AlertV2Indices.access$getIndicesToDelete(this.this$0, this.$clusterStateResponse);
                                    AlertV2IndicesKt.access$getLogger$p().info("Deleting old " + this.$tag + " indices viz " + indicesToDelete);
                                    AlertV2Indices.access$deleteAllOldHistoryIndices(this.this$0, indicesToDelete);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                } else {
                    AlertV2IndicesKt.access$getLogger$p().info("No Old " + this.$tag + " Indices to delete");
                }
            }

            public void onFailure(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AlertV2IndicesKt.access$getLogger$p().error("Error fetching cluster state");
            }
        });
    }

    private final List<String> getIndicesToDelete(ClusterStateResponse clusterStateResponse) {
        List indicesToDelete = new ArrayList();
        Map map = clusterStateResponse.getState().getMetadata().getIndices();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getIndices(...)");
        for (Map.Entry entry : map.entrySet()) {
            IndexMetadata indexMetaData = (IndexMetadata)entry.getValue();
            Intrinsics.checkNotNull((Object)indexMetaData);
            long l = this.alertV2HistoryRetentionPeriod.getMillis();
            Boolean bl = this.alertV2HistoryEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"alertV2HistoryEnabled");
            String string = this.getHistoryIndexToDelete(indexMetaData, l, ALERT_V2_HISTORY_WRITE_INDEX, bl);
            if (string == null) continue;
            String it = string;
            boolean bl2 = false;
            indicesToDelete.add(it);
        }
        return indicesToDelete;
    }

    private final String getHistoryIndexToDelete(IndexMetadata indexMetadata, long retentionPeriodMillis, String writeIndex, boolean historyEnabled) {
        long creationTime = indexMetadata.getCreationDate();
        if (Instant.now().toEpochMilli() - creationTime > retentionPeriodMillis) {
            Object v0;
            block5: {
                Iterable $this$firstOrNull$iv = indexMetadata.getAliases().entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)writeIndex, (Object)((AliasMetadata)it.getValue()).getAlias())) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            Map.Entry alias = v0;
            if (alias != null) {
                if (historyEnabled) {
                    return null;
                }
                if (Intrinsics.areEqual((Object)writeIndex, (Object)ALERT_V2_HISTORY_WRITE_INDEX)) {
                    this.alertV2HistoryIndexInitialized = false;
                }
            }
            return indexMetadata.getIndex().getName();
        }
        return null;
    }

    private final void deleteAllOldHistoryIndices(List<String> indicesToDelete) {
        if (!((Collection)indicesToDelete).isEmpty()) {
            Collection $this$toTypedArray$iv = indicesToDelete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(Arrays.copyOf(stringArray, stringArray.length));
            this.client.admin().indices().delete(deleteIndexRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(indicesToDelete, this){
                final /* synthetic */ List<String> $indicesToDelete;
                final /* synthetic */ AlertV2Indices this$0;
                {
                    this.$indicesToDelete = $indicesToDelete;
                    this.this$0 = $receiver;
                }

                public void onResponse(AcknowledgedResponse deleteIndicesResponse) {
                    Intrinsics.checkNotNullParameter((Object)deleteIndicesResponse, (String)"deleteIndicesResponse");
                    if (!deleteIndicesResponse.isAcknowledged()) {
                        AlertV2IndicesKt.access$getLogger$p().error("Could not delete one or more Alerting V2 history indices: " + this.$indicesToDelete + ". Retrying one by one.");
                        AlertV2Indices.access$deleteOldHistoryIndex(this.this$0, this.$indicesToDelete);
                    }
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AlertV2IndicesKt.access$getLogger$p().error("Delete for Alerting V2 History Indices " + this.$indicesToDelete + " Failed. Retrying one by one.");
                    AlertV2Indices.access$deleteOldHistoryIndex(this.this$0, this.$indicesToDelete);
                }
            });
        }
    }

    private final void deleteOldHistoryIndex(List<String> indicesToDelete) {
        for (String index : indicesToDelete) {
            Collection $this$toTypedArray$iv = indicesToDelete;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            DeleteIndexRequest singleDeleteRequest = new DeleteIndexRequest(Arrays.copyOf(stringArray, stringArray.length));
            this.client.admin().indices().delete(singleDeleteRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(index){
                final /* synthetic */ String $index;
                {
                    this.$index = $index;
                }

                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    if (acknowledgedResponse != null && !acknowledgedResponse.isAcknowledged()) {
                        AlertV2IndicesKt.access$getLogger$p().error("Could not delete one or more Alerting V2 history indices: " + this.$index);
                    }
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AlertV2IndicesKt.access$getLogger$p().error("Exception " + e.getMessage() + " while deleting the index " + this.$index);
                }
            });
        }
    }

    private static final void _init_$lambda$0(AlertV2Indices this$0, Boolean it) {
        this$0.alertV2HistoryEnabled = it;
    }

    private static final void _init_$lambda$1(AlertV2Indices this$0, Long it) {
        this$0.alertV2HistoryMaxDocs = it;
    }

    private static final void _init_$lambda$2(AlertV2Indices this$0, TimeValue it) {
        this$0.alertV2HistoryMaxAge = it;
    }

    private static final void _init_$lambda$3(AlertV2Indices this$0, TimeValue it) {
        this$0.alertV2HistoryRolloverPeriod = it;
        this$0.rescheduleAlertRollover();
    }

    private static final void _init_$lambda$4(AlertV2Indices this$0, TimeValue it) {
        this$0.alertV2HistoryRetentionPeriod = it;
    }

    private static final void _init_$lambda$5(AlertV2Indices this$0, TimeValue it) {
        this$0.requestTimeout = it;
    }

    private static final void onClusterManager$lambda$6(AlertV2Indices this$0) {
        this$0.rolloverAndDeleteAlertV2HistoryIndices();
    }

    private static final void rescheduleAlertRollover$lambda$7(AlertV2Indices this$0) {
        this$0.rolloverAndDeleteAlertV2HistoryIndices();
    }

    private static final Unit createIndex$lambda$8(String $index, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{$index};
        $this$suspendUntil.exists((IndicesExistsRequest)new IndicesExistsRequest(stringArray).local(true), it);
        return Unit.INSTANCE;
    }

    private static final Unit createIndex$lambda$9(CreateIndexRequest $request, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.create($request, it);
        return Unit.INSTANCE;
    }

    private static final Unit updateIndexMapping$lambda$10(PutMappingRequest $putMappingRequest, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.putMapping($putMappingRequest, it);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final String alertV2Mapping() {
        return Companion.alertV2Mapping();
    }

    public static final /* synthetic */ Object access$createIndex(AlertV2Indices $this, String index, String schemaMapping, String alias, Continuation $completion) {
        return $this.createIndex(index, schemaMapping, alias, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$updateIndexMapping(AlertV2Indices $this, String index, String mapping, boolean alias, Continuation $completion) {
        return $this.updateIndexMapping(index, mapping, alias, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ ThreadPool access$getThreadPool$p(AlertV2Indices $this) {
        return $this.threadPool;
    }

    public static final /* synthetic */ List access$getIndicesToDelete(AlertV2Indices $this, ClusterStateResponse clusterStateResponse) {
        return $this.getIndicesToDelete(clusterStateResponse);
    }

    public static final /* synthetic */ void access$deleteAllOldHistoryIndices(AlertV2Indices $this, List indicesToDelete) {
        $this.deleteAllOldHistoryIndices(indicesToDelete);
    }

    public static final /* synthetic */ void access$deleteOldHistoryIndex(AlertV2Indices $this, List indicesToDelete) {
        $this.deleteOldHistoryIndex(indicesToDelete);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/alerting/alertsv2/AlertV2Indices$Companion;", "", "<init>", "()V", "ALERT_V2_INDEX", "", "ALERT_V2_HISTORY_WRITE_INDEX", "ALERT_V2_HISTORY_ALL", "ALERT_V2_HISTORY_INDEX_PATTERN", "ALL_ALERT_V2_INDEX_PATTERN", "alertV2Mapping", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String alertV2Mapping() {
            URL uRL = AlertV2Indices.class.getResource("alert_v2_mapping.json");
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getResource(...)");
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            return new String(byArray, charset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

