/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import java.util.List;
import java.util.function.BiConsumer;
import org.opensearch.action.StepListener;
import org.opensearch.common.UUIDs;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.replication.AbstractSegmentReplicationTarget;
import org.opensearch.indices.replication.CheckpointInfoResponse;
import org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.opensearch.indices.replication.SegmentReplicationSource;
import org.opensearch.indices.replication.checkpoint.MergedSegmentCheckpoint;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.common.ReplicationListener;

public class MergedSegmentReplicationTarget
extends AbstractSegmentReplicationTarget {
    public static final String MERGE_REPLICATION_PREFIX = "merge.";

    public MergedSegmentReplicationTarget(IndexShard indexShard, ReplicationCheckpoint checkpoint, SegmentReplicationSource source, ReplicationListener listener) {
        super("merged_segment_replication_target", indexShard, checkpoint, source, listener);
    }

    @Override
    protected String getPrefix() {
        return MERGE_REPLICATION_PREFIX + UUIDs.randomBase64UUID() + ".";
    }

    @Override
    protected void getCheckpointMetadata(StepListener<CheckpointInfoResponse> checkpointInfoListener) {
        checkpointInfoListener.onResponse((Object)new CheckpointInfoResponse(this.checkpoint, this.checkpoint.getMetadataMap(), null));
    }

    @Override
    protected void updateCheckpoint(ReplicationCheckpoint checkpoint, BiConsumer<ReplicationCheckpoint, IndexShard> checkpointUpdater) {
    }

    @Override
    protected void getFilesFromSource(CheckpointInfoResponse checkpointInfo, List<StoreFileMetadata> filesToFetch, StepListener<GetSegmentFilesResponse> getFilesListener) {
        this.source.getMergedSegmentFiles(this.getId(), this.checkpoint, filesToFetch, this.indexShard, this::updateMergedSegmentFileRecoveryBytes, (ActionListener<GetSegmentFilesResponse>)getFilesListener);
    }

    @Override
    protected void finalizeReplication(CheckpointInfoResponse checkpointInfoResponse) throws Exception {
        assert (this.checkpoint instanceof MergedSegmentCheckpoint);
        this.multiFileWriter.renameAllTempFiles();
        this.indexShard.addPendingMergeSegmentCheckpoint((MergedSegmentCheckpoint)this.checkpoint);
    }

    @Override
    public MergedSegmentReplicationTarget retryCopy() {
        return new MergedSegmentReplicationTarget(this.indexShard, this.checkpoint, this.source, this.listener);
    }

    protected void updateMergedSegmentFileRecoveryBytes(String fileName, long bytesRecovered) {
        this.indexShard.mergedSegmentTransferTracker().addTotalBytesReceived(bytesRecovered);
        this.updateFileRecoveryBytes(fileName, bytesRecovered);
    }
}

