/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.routingtable;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opensearch.Version;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.RoutingTableIncrementalDiff;
import org.opensearch.common.io.Streams;
import org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.opensearch.common.remote.BlobPathParameters;
import org.opensearch.core.compress.Compressor;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.repositories.blobstore.ChecksumWritableBlobStoreFormat;

public class RemoteRoutingTableDiff
extends AbstractClusterMetadataWriteableBlobEntity<Diff<RoutingTable>> {
    private final RoutingTableIncrementalDiff routingTableIncrementalDiff;
    private long term;
    private long version;
    public static final String ROUTING_TABLE_DIFF = "routing-table-diff";
    public static final String ROUTING_TABLE_DIFF_METADATA_PREFIX = "routingTableDiff--";
    public static final String ROUTING_TABLE_DIFF_FILE = "routing_table_diff";
    private static final String codec = "RemoteRoutingTableDiff";
    public static final String ROUTING_TABLE_DIFF_PATH_TOKEN = "routing-table-diff";
    public static final int VERSION = 1;
    public final ChecksumWritableBlobStoreFormat<RoutingTableIncrementalDiff> remoteRoutingTableDiffFormat;

    public RemoteRoutingTableDiff(RoutingTableIncrementalDiff routingTableIncrementalDiff, String clusterUUID, Compressor compressor, long term, long version) {
        super(clusterUUID, compressor);
        this.routingTableIncrementalDiff = routingTableIncrementalDiff;
        this.term = term;
        this.version = version;
        this.remoteRoutingTableDiffFormat = new ChecksumWritableBlobStoreFormat(codec, RoutingTableIncrementalDiff::readFrom);
    }

    public RemoteRoutingTableDiff(String blobName, String clusterUUID, Compressor compressor, Version version) {
        super(clusterUUID, compressor);
        this.routingTableIncrementalDiff = null;
        this.blobName = blobName;
        this.remoteRoutingTableDiffFormat = new ChecksumWritableBlobStoreFormat(codec, RoutingTableIncrementalDiff::readFrom, version);
    }

    public Diff<RoutingTable> getDiffs() {
        return this.routingTableIncrementalDiff;
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        return new BlobPathParameters(List.of("routing-table-diff"), ROUTING_TABLE_DIFF_METADATA_PREFIX);
    }

    @Override
    public String getType() {
        return "routing-table-diff";
    }

    @Override
    public String generateBlobFileName() {
        if (this.blobFileName == null) {
            this.blobFileName = String.join((CharSequence)"__", this.getBlobPathParameters().getFilePrefix(), RemoteStoreUtils.invertLong(this.term), RemoteStoreUtils.invertLong(this.version), RemoteStoreUtils.invertLong(System.currentTimeMillis()));
        }
        return this.blobFileName;
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        return new ClusterMetadataManifest.UploadedMetadataAttribute(ROUTING_TABLE_DIFF_FILE, this.blobName);
    }

    @Override
    public InputStream serialize() throws IOException {
        assert (this.routingTableIncrementalDiff != null);
        return this.remoteRoutingTableDiffFormat.serialize(this.routingTableIncrementalDiff, this.generateBlobFileName(), this.getCompressor()).streamInput();
    }

    @Override
    public Diff<RoutingTable> deserialize(InputStream in) throws IOException {
        return this.remoteRoutingTableDiffFormat.deserialize(this.blobName, Streams.readFully(in));
    }
}

