/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPublicKey;
import org.bouncycastle.jcajce.interfaces.LMSPrivateKey;
import org.bouncycastle.jcajce.interfaces.LMSPublicKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvLMSPublicKey;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvLMSPrivateKey
implements Destroyable,
LMSPrivateKey {
    private static final long serialVersionUID = 1L;
    private transient AsymmetricLMSPrivateKey baseKey;

    ProvLMSPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.baseKey = new AsymmetricLMSPrivateKey(privateKeyInfo);
    }

    ProvLMSPrivateKey(AsymmetricLMSPrivateKey asymmetricLMSPrivateKey) {
        this.baseKey = asymmetricLMSPrivateKey;
    }

    @Override
    public long getIndex() {
        if (this.getUsagesRemaining() == 0L) {
            throw new IllegalStateException("key exhausted");
        }
        return this.baseKey.getIndex();
    }

    @Override
    public long getUsagesRemaining() {
        return this.baseKey.getUsagesRemaining();
    }

    @Override
    public LMSPrivateKey extractKeyShard(int n) {
        return new ProvLMSPrivateKey(this.baseKey.extractKeyShard(n));
    }

    @Override
    public String getAlgorithm() {
        return this.getBaseKey().getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    public byte[] getPublicData() {
        return this.getBaseKey().getPublicData();
    }

    @Override
    public byte[] getEncoded() {
        return this.getBaseKey().getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    AsymmetricLMSPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public int getLevels() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey.getL();
    }

    @Override
    public LMSPublicKey getPublicKey() {
        return new ProvLMSPublicKey(new AsymmetricLMSPublicKey(this.baseKey.getL(), this.baseKey.getPublicData()));
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("LMS");
        }
        AsymmetricLMSPublicKey asymmetricLMSPublicKey = new AsymmetricLMSPublicKey(this.baseKey.getL(), this.baseKey.getPublicData());
        return KeyUtil.keyToString("Private Key", this.getAlgorithm(), asymmetricLMSPublicKey);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvLMSPrivateKey)) {
            return false;
        }
        ProvLMSPrivateKey provLMSPrivateKey = (ProvLMSPrivateKey)object;
        return this.baseKey.equals(provLMSPrivateKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricLMSPrivateKey(byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

