/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.rest.CreateSubmissionRequest;
import org.apache.spark.deploy.rest.CreateSubmissionResponse;
import org.apache.spark.deploy.rest.ErrorResponse;
import org.apache.spark.deploy.rest.KillSubmissionResponse;
import org.apache.spark.deploy.rest.RestSubmissionClient$;
import org.apache.spark.deploy.rest.RestSubmissionServer$;
import org.apache.spark.deploy.rest.SubmissionStatusResponse;
import org.apache.spark.deploy.rest.SubmitRestConnectionException;
import org.apache.spark.deploy.rest.SubmitRestProtocolException;
import org.apache.spark.deploy.rest.SubmitRestProtocolException$;
import org.apache.spark.deploy.rest.SubmitRestProtocolMessage;
import org.apache.spark.deploy.rest.SubmitRestProtocolMessage$;
import org.apache.spark.deploy.rest.SubmitRestProtocolResponse;
import org.apache.spark.internal.Logging;
import org.apache.spark.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t%a!B\u0015+\u00019\"\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u000b9\u0003A\u0011A(\t\u000fM\u0003!\u0019!C\u0005)\"1\u0001\f\u0001Q\u0001\nUCq!\u0017\u0001C\u0002\u0013%!\f\u0003\u0004d\u0001\u0001\u0006Ia\u0017\u0005\u0006I\u0002!\t!\u001a\u0005\u0006]\u0002!\ta\u001c\u0005\u0006e\u0002!\ta\u001d\u0005\bu\u0002\t\n\u0011\"\u0001|\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!a\u000b\u0001\t\u0013\ti\u0003C\u0004\u0002D\u0001!I!!\u0012\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L!A\u00111\u000b\u0001\u0005\u0002)\n)\u0006C\u0004\u0002b\u0001!I!a\u0019\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004bBA<\u0001\u0011%\u0011\u0011\u0010\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!a&\u0001\t\u0013\tI\nC\u0004\u0002\u001e\u0002!I!a(\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002(\"9\u0011Q\u0016\u0001\u0005\n\u0005=v\u0001CA[U!\u0005a&a.\u0007\u000f%R\u0003\u0012\u0001\u0018\u0002:\"1aj\u0007C\u0001\u0003wC\u0011\"!0\u001c\u0005\u0004%\t!a0\t\u0011\u0005]7\u0004)A\u0005\u0003\u0003D\u0011\"!7\u001c\u0005\u0004%I!a7\t\u0011\u0005\r8\u0004)A\u0005\u0003;D\u0011\"!:\u001c\u0005\u0004%I!a:\t\u0011\u0005=8\u0004)A\u0005\u0003SD\u0011\"!=\u001c\u0005\u0004%I!a:\t\u0011\u0005M8\u0004)A\u0005\u0003SD\u0011\"!>\u001c\u0005\u0004%\t!a>\t\u0011\u0005e8\u0004)A\u0005\u0003\u001bD\u0001\"a?\u001c\t\u0003Q\u0013Q \u0005\t\u0005\u0007YB\u0011\u0001\u0018\u0003\u0006\t!\"+Z:u'V\u0014W.[:tS>t7\t\\5f]RT!a\u000b\u0017\u0002\tI,7\u000f\u001e\u0006\u0003[9\na\u0001Z3qY>L(BA\u00181\u0003\u0015\u0019\b/\u0019:l\u0015\t\t$'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0005\u0019qN]4\u0014\u0007\u0001)4\b\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0004B]f\u0014VM\u001a\t\u0003y}j\u0011!\u0010\u0006\u0003}9\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0001v\u0012q\u0001T8hO&tw-\u0001\u0004nCN$XM]\u0002\u0001!\t!5J\u0004\u0002F\u0013B\u0011aiN\u0007\u0002\u000f*\u0011\u0001JQ\u0001\u0007yI|w\u000e\u001e \n\u0005);\u0014A\u0002)sK\u0012,g-\u0003\u0002M\u001b\n11\u000b\u001e:j]\u001eT!AS\u001c\u0002\rqJg.\u001b;?)\t\u0001&\u000b\u0005\u0002R\u00015\t!\u0006C\u0003B\u0005\u0001\u00071)A\u0004nCN$XM]:\u0016\u0003U\u00032A\u000e,D\u0013\t9vGA\u0003BeJ\f\u00170\u0001\u0005nCN$XM]:!\u0003-awn\u001d;NCN$XM]:\u0016\u0003m\u00032\u0001X1D\u001b\u0005i&B\u00010`\u0003\u001diW\u000f^1cY\u0016T!\u0001Y\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002c;\n9\u0001*Y:i'\u0016$\u0018\u0001\u00047pgRl\u0015m\u001d;feN\u0004\u0013\u0001E2sK\u0006$XmU;c[&\u001c8/[8o)\t1\u0017\u000e\u0005\u0002RO&\u0011\u0001N\u000b\u0002\u001b'V\u0014W.\u001b;SKN$\bK]8u_\u000e|GNU3ta>t7/\u001a\u0005\u0006U\u001e\u0001\ra[\u0001\be\u0016\fX/Z:u!\t\tF.\u0003\u0002nU\t92I]3bi\u0016\u001cVOY7jgNLwN\u001c*fcV,7\u000f^\u0001\u000fW&dGnU;c[&\u001c8/[8o)\t1\u0007\u000fC\u0003r\u0011\u0001\u00071)\u0001\u0007tk\nl\u0017n]:j_:LE-A\fsKF,Xm\u001d;Tk\nl\u0017n]:j_:\u001cF/\u0019;vgR\u0019a\r^;\t\u000bEL\u0001\u0019A\"\t\u000fYL\u0001\u0013!a\u0001o\u0006)\u0011/^5fiB\u0011a\u0007_\u0005\u0003s^\u0012qAQ8pY\u0016\fg.A\u0011sKF,Xm\u001d;Tk\nl\u0017n]:j_:\u001cF/\u0019;vg\u0012\"WMZ1vYR$#'F\u0001}U\t9XpK\u0001\u007f!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000f9\u0014AC1o]>$\u0018\r^5p]&!\u00111BA\u0001\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017G>t7\u000f\u001e:vGR\u001cVOY7jiJ+\u0017/^3tiRY1.!\u0005\u0002\u0016\u0005e\u0011QDA\u0014\u0011\u0019\t\u0019b\u0003a\u0001\u0007\u0006Y\u0011\r\u001d9SKN|WO]2f\u0011\u0019\t9b\u0003a\u0001\u0007\u0006IQ.Y5o\u00072\f7o\u001d\u0005\u0007\u00037Y\u0001\u0019A+\u0002\u000f\u0005\u0004\b/\u0011:hg\"9\u0011qD\u0006A\u0002\u0005\u0005\u0012aD:qCJ\\\u0007K]8qKJ$\u0018.Z:\u0011\u000b\u0011\u000b\u0019cQ\"\n\u0007\u0005\u0015RJA\u0002NCBDq!!\u000b\f\u0001\u0004\t\t#\u0001\u000bf]ZL'o\u001c8nK:$h+\u0019:jC\ndWm]\u0001\u0004O\u0016$Hc\u00014\u00020!9\u0011\u0011\u0007\u0007A\u0002\u0005M\u0012aA;sYB!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012a\u00018fi*\u0011\u0011QH\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002B\u0005]\"aA+S\u0019\u0006!\u0001o\\:u)\r1\u0017q\t\u0005\b\u0003ci\u0001\u0019AA\u001a\u0003!\u0001xn\u001d;Kg>tG#\u00024\u0002N\u0005=\u0003bBA\u0019\u001d\u0001\u0007\u00111\u0007\u0005\u0007\u0003#r\u0001\u0019A\"\u0002\t)\u001cxN\\\u0001\re\u0016\fGMU3ta>t7/\u001a\u000b\u0004M\u0006]\u0003bBA-\u001f\u0001\u0007\u00111L\u0001\u000bG>tg.Z2uS>t\u0007\u0003BA\u001b\u0003;JA!a\u0018\u00028\t\t\u0002\n\u001e;q+Jc5i\u001c8oK\u000e$\u0018n\u001c8\u0002\u0019\u001d,GoU;c[&$XK\u001d7\u0015\t\u0005M\u0012Q\r\u0005\u0006\u0003B\u0001\raQ\u0001\u000bO\u0016$8*\u001b7m+JdGCBA\u001a\u0003W\ni\u0007C\u0003B#\u0001\u00071\tC\u0003r#\u0001\u00071)\u0001\u0007hKR\u001cF/\u0019;vgV\u0013H\u000e\u0006\u0004\u00024\u0005M\u0014Q\u000f\u0005\u0006\u0003J\u0001\ra\u0011\u0005\u0006cJ\u0001\raQ\u0001\u000bO\u0016$()Y:f+JdGcA\"\u0002|!)\u0011i\u0005a\u0001\u0007\u0006qa/\u00197jI\u0006$X-T1ti\u0016\u0014H\u0003BAA\u0003\u000f\u00032ANAB\u0013\r\t)i\u000e\u0002\u0005+:LG\u000fC\u0003B)\u0001\u00071)\u0001\fsKB|'\u000f^*vE6L7o]5p]N#\u0018\r^;t)\u0011\t\t)!$\t\u000f\u0005=U\u00031\u0001\u0002\u0012\u0006q1/\u001e2nSR\u0014Vm\u001d9p]N,\u0007cA)\u0002\u0014&\u0019\u0011Q\u0013\u0016\u00031\r\u0013X-\u0019;f'V\u0014W.[:tS>t'+Z:q_:\u001cX-\u0001\u000bq_2d7+\u001e2nSN\u001c\u0018n\u001c8Ti\u0006$Xo\u001d\u000b\u0005\u0003\u0003\u000bY\nC\u0003r-\u0001\u00071)\u0001\niC:$G.\u001a*fgR\u0014Vm\u001d9p]N,G\u0003BAA\u0003CCa!a)\u0018\u0001\u00041\u0017\u0001\u0003:fgB|gn]3\u00029!\fg\u000e\u001a7f+:,\u0007\u0010]3di\u0016$'+Z:u%\u0016\u001c\bo\u001c8tKR!\u0011\u0011QAU\u0011\u0019\tY\u000b\u0007a\u0001M\u0006QQO\\3ya\u0016\u001cG/\u001a3\u00023!\fg\u000e\u001a7f\u0007>tg.Z2uS>tW\t_2faRLwN\u001c\u000b\u0004o\u0006E\u0006BBAZ3\u0001\u00071)A\u0005nCN$XM]+sY\u0006!\"+Z:u'V\u0014W.[:tS>t7\t\\5f]R\u0004\"!U\u000e\u0014\u0005m)DCAA\\\u0003]\u0019X\u000f\u001d9peR,G-T1ti\u0016\u0014\bK]3gSb,7/\u0006\u0002\u0002BB1\u00111YAe\u0003\u001bl!!!2\u000b\u0007\u0005\u001dw,A\u0005j[6,H/\u00192mK&!\u00111ZAc\u0005\r\u0019V-\u001d\t\u0005\u0003\u001f\f).\u0004\u0002\u0002R*!\u00111[A\u001e\u0003\u0011a\u0017M\\4\n\u00071\u000b\t.\u0001\rtkB\u0004xN\u001d;fI6\u000b7\u000f^3s!J,g-\u001b=fg\u0002\nq#\u0012-D\u0019V#U\tR0T!\u0006\u00136jX#O-~3\u0016IU*\u0016\u0005\u0005u\u0007CBAb\u0003?\fi-\u0003\u0003\u0002b\u0006\u0015'aA*fi\u0006AR\tW\"M+\u0012+EiX*Q\u0003J[u,\u0012(W?Z\u000b%k\u0015\u0011\u0002;I+\u0005k\u0014*U?\u0012\u0013\u0016JV#S?N#\u0016\tV+T?&sE+\u0012*W\u00032+\"!!;\u0011\u0007Y\nY/C\u0002\u0002n^\u00121!\u00138u\u0003y\u0011V\tU(S)~#%+\u0013,F%~\u001bF+\u0011+V'~Ke\nV#S-\u0006c\u0005%\u0001\u0010S\u000bB{%\u000bV0E%&3VIU0T)\u0006#VkU0N\u0003b{FKU%F'\u0006y\"+\u0012)P%R{FIU%W\u000bJ{6\u000bV!U+N{V*\u0011-`)JKUi\u0015\u0011\u0002!A\u0013v\nV(D\u001f2{f+\u0012*T\u0013>sUCAAg\u0003E\u0001&k\u0014+P\u0007>cuLV#S'&{e\nI\u0001\u0018M&dG/\u001a:TsN$X-\\#om&\u0014xN\\7f]R$B!!\t\u0002\u0000\"9!\u0011A\u0014A\u0002\u0005\u0005\u0012aA3om\u0006\u00112/\u001e9q_J$8OU3ti\u000ec\u0017.\u001a8u)\r9(q\u0001\u0005\u0006\u0003\"\u0002\ra\u0011")
public class RestSubmissionClient
implements Logging {
    private final String master;
    private final String[] masters;
    private final HashSet<String> lostMasters;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String PROTOCOL_VERSION() {
        return RestSubmissionClient$.MODULE$.PROTOCOL_VERSION();
    }

    public static Seq<String> supportedMasterPrefixes() {
        return RestSubmissionClient$.MODULE$.supportedMasterPrefixes();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String[] masters() {
        return this.masters;
    }

    private HashSet<String> lostMasters() {
        return this.lostMasters;
    }

    public SubmitRestProtocolResponse createSubmission(CreateSubmissionRequest request) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Submitting a request to launch an application in ").append($this.master).append(".").toString());
        BooleanRef handled = BooleanRef.create((boolean)false);
        ObjectRef response = ObjectRef.create(null);
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.masters()), (Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)RestSubmissionClient.$anonfun$createSubmission$2(handled, m))).foreach((Function1 & Serializable)m -> {
            RestSubmissionClient.$anonfun$createSubmission$3(this, response, request, handled, m);
            return BoxedUnit.UNIT;
        });
        return (SubmitRestProtocolResponse)response.elem;
    }

    public SubmitRestProtocolResponse killSubmission(String submissionId) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Submitting a request to kill submission ").append(submissionId).append(" in ").append($this.master).append(".").toString());
        BooleanRef handled = BooleanRef.create((boolean)false);
        ObjectRef response = ObjectRef.create(null);
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.masters()), (Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)RestSubmissionClient.$anonfun$killSubmission$2(handled, m))).foreach((Function1 & Serializable)m -> {
            RestSubmissionClient.$anonfun$killSubmission$3(this, submissionId, response, handled, m);
            return BoxedUnit.UNIT;
        });
        return (SubmitRestProtocolResponse)response.elem;
    }

    public SubmitRestProtocolResponse requestSubmissionStatus(String submissionId, boolean quiet) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Submitting a request for the status of submission ").append(submissionId).append(" in ").append($this.master).append(".").toString());
        BooleanRef handled = BooleanRef.create((boolean)false);
        ObjectRef response = ObjectRef.create(null);
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.masters()), (Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)RestSubmissionClient.$anonfun$requestSubmissionStatus$2(handled, m))).foreach((Function1 & Serializable)m -> {
            RestSubmissionClient.$anonfun$requestSubmissionStatus$3(this, submissionId, response, quiet, handled, m);
            return BoxedUnit.UNIT;
        });
        return (SubmitRestProtocolResponse)response.elem;
    }

    public boolean requestSubmissionStatus$default$2() {
        return false;
    }

    public CreateSubmissionRequest constructSubmitRequest(String appResource, String mainClass, String[] appArgs, Map<String, String> sparkProperties, Map<String, String> environmentVariables) {
        CreateSubmissionRequest message = new CreateSubmissionRequest();
        message.clientSparkVersion_$eq(package$.MODULE$.SPARK_VERSION());
        message.appResource_$eq(appResource);
        message.mainClass_$eq(mainClass);
        message.appArgs_$eq(appArgs);
        message.sparkProperties_$eq(sparkProperties);
        message.environmentVariables_$eq(environmentVariables);
        message.validate();
        return message;
    }

    private SubmitRestProtocolResponse get(URL url) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Sending GET request to server at ").append(url).append(".").toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        return this.readResponse(conn);
    }

    private SubmitRestProtocolResponse post(URL url) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Sending POST request to server at ").append(url).append(".").toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        return this.readResponse(conn);
    }

    private SubmitRestProtocolResponse postJson(URL url, String json) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Sending POST request to server at ").append(url).append(":\n").append(json).toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("charset", "utf-8");
        conn.setDoOutput(true);
        try {
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable)() -> out.write(json.getBytes(StandardCharsets.UTF_8)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> out.close());
        }
        catch (ConnectException e) {
            throw new SubmitRestConnectionException("Connect Exception when connect to server", e);
        }
        return this.readResponse(conn);
    }

    public SubmitRestProtocolResponse readResponse(HttpURLConnection connection) {
        SubmitRestProtocolResponse submitRestProtocolResponse;
        Future responseFuture = Future$.MODULE$.apply((Function0 & Serializable)() -> {
            ErrorResponse errorResponse;
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                Some errString = new Some((Object)Source$.MODULE$.fromInputStream(connection.getErrorStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n"));
                if (responseCode == 500 && !connection.getContentType().contains("application/json")) {
                    throw new SubmitRestProtocolException(new StringBuilder(33).append("Server responded with exception:\n").append(errString).toString(), SubmitRestProtocolException$.MODULE$.$lessinit$greater$default$2());
                }
                this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Server responded with error:\n").append(errString).toString());
                ErrorResponse error = new ErrorResponse();
                if (responseCode == RestSubmissionServer$.MODULE$.SC_UNKNOWN_PROTOCOL_VERSION()) {
                    error.highestProtocolVersion_$eq(RestSubmissionServer$.MODULE$.PROTOCOL_VERSION());
                }
                error.message_$eq((String)errString.get());
                errorResponse = error;
            } else {
                SubmitRestProtocolResponse submitRestProtocolResponse;
                InputStream dataStream = connection.getInputStream();
                if (dataStream == null) {
                    throw new SubmitRestProtocolException("Server returned empty body", SubmitRestProtocolException$.MODULE$.$lessinit$greater$default$2());
                }
                String responseJson = Source$.MODULE$.fromInputStream(dataStream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Response from the server:\n").append(responseJson).toString());
                SubmitRestProtocolMessage response = SubmitRestProtocolMessage$.MODULE$.fromJson(responseJson);
                response.validate();
                SubmitRestProtocolMessage submitRestProtocolMessage = response;
                if (submitRestProtocolMessage instanceof ErrorResponse) {
                    ErrorResponse errorResponse2 = (ErrorResponse)submitRestProtocolMessage;
                    this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Server responded with error:\n").append(errorResponse2.message()).toString());
                    submitRestProtocolResponse = errorResponse2;
                } else if (submitRestProtocolMessage instanceof SubmitRestProtocolResponse) {
                    SubmitRestProtocolResponse submitRestProtocolResponse2 = (SubmitRestProtocolResponse)submitRestProtocolMessage;
                    submitRestProtocolResponse = submitRestProtocolResponse2;
                } else {
                    throw new SubmitRestProtocolException(new StringBuilder(49).append("Message received from server was not a response:\n").append(submitRestProtocolMessage.toJson()).toString(), SubmitRestProtocolException$.MODULE$.$lessinit$greater$default$2());
                }
                errorResponse = submitRestProtocolResponse;
            }
            return errorResponse;
        }, ExecutionContext.Implicits$.MODULE$.global());
        try {
            submitRestProtocolResponse = (SubmitRestProtocolResponse)Await$.MODULE$.result((Awaitable)responseFuture, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof FileNotFoundException ? true : throwable2 instanceof SocketException;
            if (bl) {
                throw new SubmitRestConnectionException("Unable to connect to server", throwable2);
            }
            boolean bl2 = throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof SubmitRestProtocolException;
            if (bl2) {
                throw new SubmitRestProtocolException("Malformed response received from server", throwable2);
            }
            if (throwable2 instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable2;
                throw new SubmitRestConnectionException("No response from server", timeoutException);
            }
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable t = (Throwable)option.get();
                throw new SparkException("Exception while waiting for response", t);
            }
            throw throwable;
        }
        return submitRestProtocolResponse;
    }

    private URL getSubmitUrl(String master) {
        String baseUrl = this.getBaseUrl(master);
        return new URL(new StringBuilder(7).append(baseUrl).append("/create").toString());
    }

    private URL getKillUrl(String master, String submissionId) {
        String baseUrl = this.getBaseUrl(master);
        return new URL(new StringBuilder(6).append(baseUrl).append("/kill/").append(submissionId).toString());
    }

    private URL getStatusUrl(String master, String submissionId) {
        String baseUrl = this.getBaseUrl(master);
        return new URL(new StringBuilder(8).append(baseUrl).append("/status/").append(submissionId).toString());
    }

    private String getBaseUrl(String master) {
        ObjectRef masterUrl = ObjectRef.create((Object)master);
        RestSubmissionClient$.MODULE$.supportedMasterPrefixes().foreach((Function1 & Serializable)prefix -> {
            RestSubmissionClient.$anonfun$getBaseUrl$1(master, masterUrl, prefix);
            return BoxedUnit.UNIT;
        });
        masterUrl.elem = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString((String)masterUrl.elem), "/");
        return new StringBuilder(20).append("http://").append((String)masterUrl.elem).append("/").append(RestSubmissionClient$.MODULE$.PROTOCOL_VERSION()).append("/submissions").toString();
    }

    private void validateMaster(String master) {
        boolean valid = RestSubmissionClient$.MODULE$.supportedMasterPrefixes().exists((Function1 & Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)master.startsWith(prefix)));
        if (!valid) {
            throw new IllegalArgumentException(new StringBuilder(81).append("This REST client only supports master URLs that start with one of the following: ").append(RestSubmissionClient$.MODULE$.supportedMasterPrefixes().mkString(",")).toString());
        }
    }

    private void reportSubmissionStatus(CreateSubmissionResponse submitResponse) {
        if (Predef$.MODULE$.Boolean2boolean(submitResponse.success())) {
            String submissionId = submitResponse.submissionId();
            if (submissionId != null) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Submission successfully created as ").append(submissionId).append(". Polling submission state...").toString());
                this.pollSubmissionStatus(submissionId);
            } else {
                this.logError((Function0<String>)(Function0 & Serializable)() -> "Application successfully submitted, but submission ID was not provided!");
            }
        } else {
            String failMessage = (String)Option$.MODULE$.apply((Object)submitResponse.message()).map((Function1 & Serializable)x$1 -> new StringBuilder(2).append(": ").append((String)x$1).toString()).getOrElse((Function0 & Serializable)() -> "");
            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Application submission failed").append(failMessage).toString());
        }
    }

    private void pollSubmissionStatus(String submissionId) {
        Object object = new Object();
        try {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), RestSubmissionClient$.MODULE$.org$apache$spark$deploy$rest$RestSubmissionClient$$REPORT_DRIVER_STATUS_MAX_TRIES()).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> RestSubmissionClient.$anonfun$pollSubmissionStatus$1(this, submissionId, object, arg_0)));
            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Error: Master did not recognize driver ").append(submissionId).append(".").toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void handleRestResponse(SubmitRestProtocolResponse response) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Server responded with ").append(response.messageType()).append(":\n").append(response.toJson()).toString());
    }

    private void handleUnexpectedRestResponse(SubmitRestProtocolResponse unexpected) {
        this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Error: Server responded with message of unexpected type ").append(unexpected.messageType()).append(".").toString());
    }

    private boolean handleConnectionException(String masterUrl) {
        BoxedUnit boxedUnit;
        if (!this.lostMasters().contains((Object)masterUrl)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Unable to connect to server ").append(masterUrl).append(".").toString());
            boxedUnit = this.lostMasters().$plus$eq((Object)masterUrl);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.lostMasters().size() >= this.masters().length;
    }

    public static final /* synthetic */ boolean $anonfun$createSubmission$2(BooleanRef handled$1, String m) {
        return !handled$1.elem;
    }

    public static final /* synthetic */ void $anonfun$createSubmission$3(RestSubmissionClient $this, ObjectRef response$1, CreateSubmissionRequest request$1, BooleanRef handled$1, String m) {
        block6: {
            $this.validateMaster(m);
            URL url = $this.getSubmitUrl(m);
            try {
                response$1.elem = $this.postJson(url, request$1.toJson());
                SubmitRestProtocolResponse submitRestProtocolResponse = (SubmitRestProtocolResponse)response$1.elem;
                if (submitRestProtocolResponse instanceof CreateSubmissionResponse) {
                    BoxedUnit boxedUnit;
                    CreateSubmissionResponse createSubmissionResponse = (CreateSubmissionResponse)submitRestProtocolResponse;
                    if (Predef$.MODULE$.Boolean2boolean(createSubmissionResponse.success())) {
                        $this.reportSubmissionStatus(createSubmissionResponse);
                        $this.handleRestResponse(createSubmissionResponse);
                        handled$1.elem = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    $this.handleUnexpectedRestResponse(submitRestProtocolResponse);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (SubmitRestConnectionException e) {
                if (!$this.handleConnectionException(m)) break block6;
                throw new SubmitRestConnectionException("Unable to connect to server", e);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$killSubmission$2(BooleanRef handled$2, String m) {
        return !handled$2.elem;
    }

    public static final /* synthetic */ void $anonfun$killSubmission$3(RestSubmissionClient $this, String submissionId$1, ObjectRef response$2, BooleanRef handled$2, String m) {
        block6: {
            $this.validateMaster(m);
            URL url = $this.getKillUrl(m, submissionId$1);
            try {
                response$2.elem = $this.post(url);
                SubmitRestProtocolResponse submitRestProtocolResponse = (SubmitRestProtocolResponse)response$2.elem;
                if (submitRestProtocolResponse instanceof KillSubmissionResponse) {
                    BoxedUnit boxedUnit;
                    KillSubmissionResponse killSubmissionResponse = (KillSubmissionResponse)submitRestProtocolResponse;
                    if (!Utils$.MODULE$.responseFromBackup(killSubmissionResponse.message())) {
                        $this.handleRestResponse(killSubmissionResponse);
                        handled$2.elem = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    $this.handleUnexpectedRestResponse(submitRestProtocolResponse);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (SubmitRestConnectionException e) {
                if (!$this.handleConnectionException(m)) break block6;
                throw new SubmitRestConnectionException("Unable to connect to server", e);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$requestSubmissionStatus$2(BooleanRef handled$3, String m) {
        return !handled$3.elem;
    }

    public static final /* synthetic */ void $anonfun$requestSubmissionStatus$3(RestSubmissionClient $this, String submissionId$2, ObjectRef response$3, boolean quiet$1, BooleanRef handled$3, String m) {
        block5: {
            $this.validateMaster(m);
            URL url = $this.getStatusUrl(m, submissionId$2);
            try {
                SubmissionStatusResponse submissionStatusResponse;
                response$3.elem = $this.get(url);
                SubmitRestProtocolResponse submitRestProtocolResponse = (SubmitRestProtocolResponse)response$3.elem;
                if (submitRestProtocolResponse instanceof SubmissionStatusResponse && Predef$.MODULE$.Boolean2boolean((submissionStatusResponse = (SubmissionStatusResponse)submitRestProtocolResponse).success())) {
                    if (!quiet$1) {
                        $this.handleRestResponse(submissionStatusResponse);
                    }
                    handled$3.elem = true;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.handleUnexpectedRestResponse(submitRestProtocolResponse);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (SubmitRestConnectionException e) {
                if (!$this.handleConnectionException(m)) break block5;
                throw new SubmitRestConnectionException("Unable to connect to server", e);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$getBaseUrl$1(String master$1, ObjectRef masterUrl$1, String prefix) {
        block0: {
            if (!master$1.startsWith(prefix)) break block0;
            masterUrl$1.elem = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(master$1), prefix);
        }
    }

    public static final /* synthetic */ String $anonfun$pollSubmissionStatus$2(String submissionId$4, String state$1) {
        return new StringBuilder(25).append("State of driver ").append(submissionId$4).append(" is now ").append(state$1).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$pollSubmissionStatus$3(String submissionId$4) {
        return new StringBuilder(31).append("State of driver ").append(submissionId$4).append(" was not found!").toString();
    }

    public static final /* synthetic */ String $anonfun$pollSubmissionStatus$4(String id$1, String hp$1) {
        return new StringBuilder(33).append("Driver is running on worker ").append(id$1).append(" at ").append(hp$1).append(".").toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$pollSubmissionStatus$1(RestSubmissionClient $this, String submissionId$4, Object nonLocalReturnKey1$1, int x$2) {
        block5: {
            response = $this.requestSubmissionStatus(submissionId$4, true);
            var9_5 = response;
            if (!(var9_5 instanceof SubmissionStatusResponse)) {
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            var6_7 = var10_6 = (SubmissionStatusResponse)var9_5;
            statusResponse = var6_7;
            if (!Predef$.MODULE$.Boolean2boolean(statusResponse.success())) break block5;
            driverState = Option$.MODULE$.apply((Object)statusResponse.driverState());
            workerId = Option$.MODULE$.apply((Object)statusResponse.workerId());
            workerHostPort = Option$.MODULE$.apply((Object)statusResponse.workerHostPort());
            exception = Option$.MODULE$.apply((Object)statusResponse.message());
            var15_13 = driverState;
            if (var15_13 instanceof Some) {
                var16_14 = (Some)var15_13;
                state = (String)var16_14.value();
                $this.logInfo((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$pollSubmissionStatus$2(java.lang.String java.lang.String ), ()Ljava/lang/String;)((String)submissionId$4, (String)state));
                var5_16 = BoxedUnit.UNIT;
            } else {
                $this.logError((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$pollSubmissionStatus$3(java.lang.String ), ()Ljava/lang/String;)((String)submissionId$4));
                var5_17 = BoxedUnit.UNIT;
            }
            var18_18 = new Tuple2((Object)workerId, (Object)workerHostPort);
            if (var18_18 == null) ** GOTO lbl-1000
            var19_19 = (Option)var18_18._1();
            var20_20 = (Option)var18_18._2();
            if (!(var19_19 instanceof Some)) ** GOTO lbl-1000
            var21_21 = (Some)var19_19;
            id = (String)var21_21.value();
            if (var20_20 instanceof Some) {
                var23_23 = (Some)var20_20;
                hp = (String)var23_23.value();
                $this.logInfo((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$pollSubmissionStatus$4(java.lang.String java.lang.String ), ()Ljava/lang/String;)((String)id, (String)hp));
                var4_25 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 3 sources

            {
                var4_26 = BoxedUnit.UNIT;
            }
            exception.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$pollSubmissionStatus$5$adapted(org.apache.spark.deploy.rest.RestSubmissionClient java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((RestSubmissionClient)$this));
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        Thread.sleep(RestSubmissionClient$.MODULE$.org$apache$spark$deploy$rest$RestSubmissionClient$$REPORT_DRIVER_STATUS_INTERVAL());
    }

    public RestSubmissionClient(String master) {
        this.master = master;
        Logging.$init$((Logging)this);
        this.masters = master.startsWith("spark://") ? Utils$.MODULE$.parseStandaloneMasterUrls(master) : (String[])((Object[])new String[]{master});
        this.lostMasters = new HashSet();
    }

    public static final /* synthetic */ Object $anonfun$pollSubmissionStatus$5$adapted(RestSubmissionClient $this, String e) {
        $this.logError((Function0<String>)(Function0 & Serializable)() -> e);
        return BoxedUnit.UNIT;
    }
}

