/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.common.antlr.CaseInsensitiveCharStream;
import org.opensearch.sql.common.antlr.SyntaxAnalysisErrorListener;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.spark.antlr.parser.FlintSparkSqlExtensionsBaseVisitor;
import org.opensearch.sql.spark.antlr.parser.FlintSparkSqlExtensionsLexer;
import org.opensearch.sql.spark.antlr.parser.FlintSparkSqlExtensionsParser;
import org.opensearch.sql.spark.antlr.parser.SqlBaseLexer;
import org.opensearch.sql.spark.antlr.parser.SqlBaseParser;
import org.opensearch.sql.spark.antlr.parser.SqlBaseParserBaseVisitor;
import org.opensearch.sql.spark.dispatcher.model.FlintIndexOptions;
import org.opensearch.sql.spark.dispatcher.model.FullyQualifiedTableName;
import org.opensearch.sql.spark.dispatcher.model.IndexQueryActionType;
import org.opensearch.sql.spark.dispatcher.model.IndexQueryDetails;
import org.opensearch.sql.spark.flint.FlintIndexType;

public final class SQLQueryUtils {
    private static final Logger logger = LogManager.getLogger(SQLQueryUtils.class);

    public static List<FullyQualifiedTableName> extractFullyQualifiedTableNames(String sqlQuery) {
        return SQLQueryUtils.extractFullyQualifiedTableNamesWithMetadata(sqlQuery).getFullyQualifiedTableNames();
    }

    public static TableExtractionResult extractFullyQualifiedTableNamesWithMetadata(String sqlQuery) {
        SqlBaseParser sqlBaseParser = SQLQueryUtils.getBaseParser(sqlQuery);
        SqlBaseParser.StatementContext statement = sqlBaseParser.statement();
        SparkSqlTableNameVisitor visitor = new SparkSqlTableNameVisitor();
        statement.accept(visitor);
        LinkedList<FullyQualifiedTableName> uniqueFullyQualifiedTableNames = new LinkedList<FullyQualifiedTableName>();
        for (FullyQualifiedTableName fullyQualifiedTableName : visitor.getFullyQualifiedTableNames()) {
            if (uniqueFullyQualifiedTableNames.contains(fullyQualifiedTableName)) continue;
            uniqueFullyQualifiedTableNames.add(fullyQualifiedTableName);
        }
        return new TableExtractionResult(uniqueFullyQualifiedTableNames, visitor.isCreateTable());
    }

    public static IndexQueryDetails extractIndexDetails(String sqlQuery) {
        FlintSparkSqlExtensionsParser flintSparkSqlExtensionsParser = new FlintSparkSqlExtensionsParser((TokenStream)new CommonTokenStream((TokenSource)new FlintSparkSqlExtensionsLexer(new CaseInsensitiveCharStream(sqlQuery))));
        flintSparkSqlExtensionsParser.addErrorListener((ANTLRErrorListener)new SyntaxAnalysisErrorListener());
        FlintSparkSqlExtensionsParser.SingleStatementContext singleStatementContext = flintSparkSqlExtensionsParser.singleStatement();
        FlintSQLIndexDetailsVisitor flintSQLIndexDetailsVisitor = new FlintSQLIndexDetailsVisitor();
        singleStatementContext.accept(flintSQLIndexDetailsVisitor);
        return flintSQLIndexDetailsVisitor.getIndexQueryDetailsBuilder().build();
    }

    public static boolean isFlintExtensionQuery(String sqlQuery) {
        FlintSparkSqlExtensionsParser flintSparkSqlExtensionsParser = new FlintSparkSqlExtensionsParser((TokenStream)new CommonTokenStream((TokenSource)new FlintSparkSqlExtensionsLexer(new CaseInsensitiveCharStream(sqlQuery))));
        flintSparkSqlExtensionsParser.addErrorListener((ANTLRErrorListener)new SyntaxAnalysisErrorListener());
        try {
            flintSparkSqlExtensionsParser.statement();
            return true;
        }
        catch (SyntaxCheckException syntaxCheckException) {
            return false;
        }
    }

    public static SqlBaseParser getBaseParser(String sqlQuery) {
        SqlBaseParser sqlBaseParser = new SqlBaseParser((TokenStream)new CommonTokenStream((TokenSource)new SqlBaseLexer(new CaseInsensitiveCharStream(sqlQuery))));
        sqlBaseParser.addErrorListener((ANTLRErrorListener)new SyntaxAnalysisErrorListener());
        return sqlBaseParser;
    }

    @Generated
    private SQLQueryUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class TableExtractionResult {
        private final List<FullyQualifiedTableName> fullyQualifiedTableNames;
        private final boolean isCreateTableQuery;

        public TableExtractionResult(List<FullyQualifiedTableName> fullyQualifiedTableNames, boolean isCreateTableQuery) {
            this.fullyQualifiedTableNames = fullyQualifiedTableNames;
            this.isCreateTableQuery = isCreateTableQuery;
        }

        @Generated
        public List<FullyQualifiedTableName> getFullyQualifiedTableNames() {
            return this.fullyQualifiedTableNames;
        }

        @Generated
        public boolean isCreateTableQuery() {
            return this.isCreateTableQuery;
        }
    }

    public static class SparkSqlTableNameVisitor
    extends SqlBaseParserBaseVisitor<Void> {
        private final List<FullyQualifiedTableName> fullyQualifiedTableNames = new LinkedList<FullyQualifiedTableName>();
        private boolean isCreateTable = false;

        @Override
        public Void visitIdentifierReference(SqlBaseParser.IdentifierReferenceContext ctx) {
            this.fullyQualifiedTableNames.add(new FullyQualifiedTableName(ctx.getText()));
            return (Void)super.visitIdentifierReference(ctx);
        }

        @Override
        public Void visitDropTable(SqlBaseParser.DropTableContext ctx) {
            for (ParseTree parseTree : ctx.children) {
                if (!(parseTree instanceof SqlBaseParser.IdentifierReferenceContext)) continue;
                this.fullyQualifiedTableNames.add(new FullyQualifiedTableName(parseTree.getText()));
            }
            return (Void)super.visitDropTable(ctx);
        }

        @Override
        public Void visitDescribeRelation(SqlBaseParser.DescribeRelationContext ctx) {
            for (ParseTree parseTree : ctx.children) {
                if (!(parseTree instanceof SqlBaseParser.IdentifierReferenceContext)) continue;
                this.fullyQualifiedTableNames.add(new FullyQualifiedTableName(parseTree.getText()));
            }
            return (Void)super.visitDescribeRelation(ctx);
        }

        @Override
        public Void visitCreateTableHeader(SqlBaseParser.CreateTableHeaderContext ctx) {
            for (ParseTree parseTree : ctx.children) {
                if (!(parseTree instanceof SqlBaseParser.IdentifierReferenceContext)) continue;
                this.fullyQualifiedTableNames.add(new FullyQualifiedTableName(parseTree.getText()));
            }
            return (Void)super.visitCreateTableHeader(ctx);
        }

        @Override
        public Void visitCreateTable(SqlBaseParser.CreateTableContext ctx) {
            this.isCreateTable = true;
            return (Void)super.visitCreateTable(ctx);
        }

        @Generated
        public List<FullyQualifiedTableName> getFullyQualifiedTableNames() {
            return this.fullyQualifiedTableNames;
        }

        @Generated
        public boolean isCreateTable() {
            return this.isCreateTable;
        }
    }

    public static class FlintSQLIndexDetailsVisitor
    extends FlintSparkSqlExtensionsBaseVisitor<Void> {
        private final IndexQueryDetails.IndexQueryDetailsBuilder indexQueryDetailsBuilder = new IndexQueryDetails.IndexQueryDetailsBuilder();

        @Override
        public Void visitIndexName(FlintSparkSqlExtensionsParser.IndexNameContext ctx) {
            this.indexQueryDetailsBuilder.indexName(ctx.getText());
            return (Void)super.visitIndexName(ctx);
        }

        @Override
        public Void visitTableName(FlintSparkSqlExtensionsParser.TableNameContext ctx) {
            this.indexQueryDetailsBuilder.fullyQualifiedTableName(new FullyQualifiedTableName(ctx.getText()));
            return (Void)super.visitTableName(ctx);
        }

        @Override
        public Void visitCreateSkippingIndexStatement(FlintSparkSqlExtensionsParser.CreateSkippingIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.CREATE);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.SKIPPING);
            this.visitPropertyList(ctx.propertyList());
            return (Void)super.visitCreateSkippingIndexStatement(ctx);
        }

        @Override
        public Void visitCreateCoveringIndexStatement(FlintSparkSqlExtensionsParser.CreateCoveringIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.CREATE);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.COVERING);
            this.visitPropertyList(ctx.propertyList());
            return (Void)super.visitCreateCoveringIndexStatement(ctx);
        }

        @Override
        public Void visitCreateMaterializedViewStatement(FlintSparkSqlExtensionsParser.CreateMaterializedViewStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.CREATE);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.MATERIALIZED_VIEW);
            this.indexQueryDetailsBuilder.mvName(ctx.mvName.getText());
            this.visitPropertyList(ctx.propertyList());
            return (Void)super.visitCreateMaterializedViewStatement(ctx);
        }

        @Override
        public Void visitDropCoveringIndexStatement(FlintSparkSqlExtensionsParser.DropCoveringIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.DROP);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.COVERING);
            return (Void)super.visitDropCoveringIndexStatement(ctx);
        }

        @Override
        public Void visitDropSkippingIndexStatement(FlintSparkSqlExtensionsParser.DropSkippingIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.DROP);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.SKIPPING);
            return (Void)super.visitDropSkippingIndexStatement(ctx);
        }

        @Override
        public Void visitDropMaterializedViewStatement(FlintSparkSqlExtensionsParser.DropMaterializedViewStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.DROP);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.MATERIALIZED_VIEW);
            this.indexQueryDetailsBuilder.mvName(ctx.mvName.getText());
            return (Void)super.visitDropMaterializedViewStatement(ctx);
        }

        @Override
        public Void visitDescribeCoveringIndexStatement(FlintSparkSqlExtensionsParser.DescribeCoveringIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.DESCRIBE);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.COVERING);
            return (Void)super.visitDescribeCoveringIndexStatement(ctx);
        }

        @Override
        public Void visitDescribeSkippingIndexStatement(FlintSparkSqlExtensionsParser.DescribeSkippingIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.DESCRIBE);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.SKIPPING);
            return (Void)super.visitDescribeSkippingIndexStatement(ctx);
        }

        @Override
        public Void visitDescribeMaterializedViewStatement(FlintSparkSqlExtensionsParser.DescribeMaterializedViewStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.DESCRIBE);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.MATERIALIZED_VIEW);
            this.indexQueryDetailsBuilder.mvName(ctx.mvName.getText());
            return (Void)super.visitDescribeMaterializedViewStatement(ctx);
        }

        @Override
        public Void visitShowCoveringIndexStatement(FlintSparkSqlExtensionsParser.ShowCoveringIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.SHOW);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.COVERING);
            return (Void)super.visitShowCoveringIndexStatement(ctx);
        }

        @Override
        public Void visitShowMaterializedViewStatement(FlintSparkSqlExtensionsParser.ShowMaterializedViewStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.SHOW);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.MATERIALIZED_VIEW);
            return (Void)super.visitShowMaterializedViewStatement(ctx);
        }

        @Override
        public Void visitRefreshCoveringIndexStatement(FlintSparkSqlExtensionsParser.RefreshCoveringIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.REFRESH);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.COVERING);
            return (Void)super.visitRefreshCoveringIndexStatement(ctx);
        }

        @Override
        public Void visitRefreshSkippingIndexStatement(FlintSparkSqlExtensionsParser.RefreshSkippingIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.REFRESH);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.SKIPPING);
            return (Void)super.visitRefreshSkippingIndexStatement(ctx);
        }

        @Override
        public Void visitRefreshMaterializedViewStatement(FlintSparkSqlExtensionsParser.RefreshMaterializedViewStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.REFRESH);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.MATERIALIZED_VIEW);
            this.indexQueryDetailsBuilder.mvName(ctx.mvName.getText());
            return (Void)super.visitRefreshMaterializedViewStatement(ctx);
        }

        @Override
        public Void visitPropertyList(FlintSparkSqlExtensionsParser.PropertyListContext ctx) {
            FlintIndexOptions flintIndexOptions = new FlintIndexOptions();
            if (ctx != null) {
                ctx.property().forEach(property -> flintIndexOptions.setOption(this.removeUnwantedQuotes(this.propertyKey(property.key).toLowerCase(Locale.ROOT)), this.removeUnwantedQuotes(this.propertyValue(property.value).toLowerCase(Locale.ROOT))));
            }
            this.indexQueryDetailsBuilder.indexOptions(flintIndexOptions);
            return null;
        }

        @Override
        public Void visitAlterCoveringIndexStatement(FlintSparkSqlExtensionsParser.AlterCoveringIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.ALTER);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.COVERING);
            this.visitPropertyList(ctx.propertyList());
            return (Void)super.visitAlterCoveringIndexStatement(ctx);
        }

        @Override
        public Void visitAlterSkippingIndexStatement(FlintSparkSqlExtensionsParser.AlterSkippingIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.ALTER);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.SKIPPING);
            this.visitPropertyList(ctx.propertyList());
            return (Void)super.visitAlterSkippingIndexStatement(ctx);
        }

        @Override
        public Void visitAlterMaterializedViewStatement(FlintSparkSqlExtensionsParser.AlterMaterializedViewStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.ALTER);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.MATERIALIZED_VIEW);
            this.indexQueryDetailsBuilder.mvName(ctx.mvName.getText());
            this.visitPropertyList(ctx.propertyList());
            return (Void)super.visitAlterMaterializedViewStatement(ctx);
        }

        @Override
        public Void visitVacuumCoveringIndexStatement(FlintSparkSqlExtensionsParser.VacuumCoveringIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.VACUUM);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.COVERING);
            return (Void)super.visitVacuumCoveringIndexStatement(ctx);
        }

        @Override
        public Void visitVacuumSkippingIndexStatement(FlintSparkSqlExtensionsParser.VacuumSkippingIndexStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.VACUUM);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.SKIPPING);
            return (Void)super.visitVacuumSkippingIndexStatement(ctx);
        }

        @Override
        public Void visitVacuumMaterializedViewStatement(FlintSparkSqlExtensionsParser.VacuumMaterializedViewStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.VACUUM);
            this.indexQueryDetailsBuilder.indexType(FlintIndexType.MATERIALIZED_VIEW);
            this.indexQueryDetailsBuilder.mvName(ctx.mvName.getText());
            return (Void)super.visitVacuumMaterializedViewStatement(ctx);
        }

        @Override
        public Void visitMaterializedViewQuery(FlintSparkSqlExtensionsParser.MaterializedViewQueryContext ctx) {
            int a = ctx.start.getStartIndex();
            int b = ctx.stop.getStopIndex();
            String query = ctx.start.getInputStream().getText(new Interval(a, b));
            this.indexQueryDetailsBuilder.mvQuery(query);
            return (Void)super.visitMaterializedViewQuery(ctx);
        }

        @Override
        public Void visitRecoverIndexJobStatement(FlintSparkSqlExtensionsParser.RecoverIndexJobStatementContext ctx) {
            this.indexQueryDetailsBuilder.indexQueryActionType(IndexQueryActionType.RECOVER);
            return (Void)super.visitRecoverIndexJobStatement(ctx);
        }

        private String propertyKey(FlintSparkSqlExtensionsParser.PropertyKeyContext key) {
            if (key.STRING() != null) {
                return key.STRING().getText();
            }
            return key.getText();
        }

        private String propertyValue(FlintSparkSqlExtensionsParser.PropertyValueContext value) {
            if (value.STRING() != null) {
                return value.STRING().getText();
            }
            if (value.booleanValue() != null) {
                return value.getText();
            }
            return value.getText();
        }

        public String removeUnwantedQuotes(String input) {
            return input.replaceAll("^\"|\"$", "");
        }

        @Generated
        public IndexQueryDetails.IndexQueryDetailsBuilder getIndexQueryDetailsBuilder() {
            return this.indexQueryDetailsBuilder;
        }
    }
}

