/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.dao;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.StepListener;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndices;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndicesManager;
import org.opensearch.searchrelevance.model.ScheduledExperimentResult;

public class ScheduledExperimentHistoryDao {
    private static final Logger LOGGER = LogManager.getLogger(ScheduledExperimentHistoryDao.class);
    private final SearchRelevanceIndicesManager searchRelevanceIndicesManager;

    public ScheduledExperimentHistoryDao(SearchRelevanceIndicesManager searchRelevanceIndicesManager) {
        this.searchRelevanceIndicesManager = searchRelevanceIndicesManager;
    }

    public void createIndexIfAbsent(StepListener<Void> stepListener) {
        this.searchRelevanceIndicesManager.createIndexIfAbsent(SearchRelevanceIndices.SCHEDULED_EXPERIMENT_HISTORY, stepListener);
    }

    public void putScheduledExperimentResult(ScheduledExperimentResult scheduledExperimentResult, ActionListener listener) {
        if (scheduledExperimentResult == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Scheduled experiment result cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.putDoc(scheduledExperimentResult.getId(), scheduledExperimentResult.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.SCHEDULED_EXPERIMENT_HISTORY, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store scheduled experiment result", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void updateScheduledExperimentResult(ScheduledExperimentResult scheduledExperimentResult, ActionListener listener) {
        if (scheduledExperimentResult == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Scheduled experiment result cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.updateDoc(scheduledExperimentResult.getId(), scheduledExperimentResult.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.SCHEDULED_EXPERIMENT_HISTORY, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store scheduled experiment result", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void deleteScheduledExperimentResult(String scheduledExperimentResultId, ActionListener<DeleteResponse> listener) {
        this.searchRelevanceIndicesManager.deleteDocByDocId(scheduledExperimentResultId, SearchRelevanceIndices.SCHEDULED_EXPERIMENT_HISTORY, listener);
    }

    public void deleteScheduledExperimentHistoryByExperimentId(String experimentId, ActionListener<BulkByScrollResponse> listener) {
        this.searchRelevanceIndicesManager.deleteByQuery(experimentId, "experimentId", SearchRelevanceIndices.SCHEDULED_EXPERIMENT_HISTORY, listener);
    }

    public SearchResponse getScheduledExperimentResult(String scheduledExperimentResultId, ActionListener<SearchResponse> listener) {
        if (scheduledExperimentResultId == null || scheduledExperimentResultId.isEmpty()) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("scheduledExperimentResultId must not be null or empty", RestStatus.BAD_REQUEST)));
            return null;
        }
        return this.searchRelevanceIndicesManager.getDocByDocId(scheduledExperimentResultId, SearchRelevanceIndices.SCHEDULED_EXPERIMENT_HISTORY, listener);
    }

    public SearchResponse listScheduledExperimentResult(SearchSourceBuilder sourceBuilder, ActionListener<SearchResponse> listener) {
        if (sourceBuilder == null) {
            sourceBuilder = new SearchSourceBuilder();
        }
        if (sourceBuilder.query() == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        return this.searchRelevanceIndicesManager.listDocsBySearchRequest(sourceBuilder, SearchRelevanceIndices.SCHEDULED_EXPERIMENT_HISTORY, listener);
    }
}

