/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.internal;

import java.io.IOException;
import java.io.InputStream;
import org.opensearch.notifications.core.repackage.com.amazonaws.AbortedException;
import org.opensearch.notifications.core.repackage.com.amazonaws.internal.MetricAware;
import org.opensearch.notifications.core.repackage.com.amazonaws.internal.Releasable;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.IOUtils;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.SdkRuntime;
import org.opensearch.notifications.core.repackage.org.apache.commons.logging.LogFactory;

public abstract class SdkInputStream
extends InputStream
implements MetricAware,
Releasable {
    protected abstract InputStream getWrappedInputStream();

    @Override
    public final boolean isMetricActivated() {
        InputStream in = this.getWrappedInputStream();
        if (in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    protected final void abortIfNeeded() {
        if (SdkRuntime.shouldAbort()) {
            try {
                this.abort();
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).debug((Object)"FYI", (Throwable)e);
            }
            throw new AbortedException();
        }
    }

    protected void abort() throws IOException {
    }

    @Override
    public void release() {
        IOUtils.closeQuietly(this, null);
        InputStream in = this.getWrappedInputStream();
        if (in instanceof Releasable) {
            Releasable r = (Releasable)((Object)in);
            r.release();
        }
    }
}

