/*
 * Decompiled with CFR 0.152.
 */
package StormTracker_Compile;

import BoundedInts_Compile.uint8;
import DafnyLibraries.MutableMap;
import LocalCMC_Compile.LocalCMC;
import StormTracker_Compile.CacheState;
import Time.__default;
import Wrappers_Compile.Result;
import dafny.DafnyEuclidean;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.CountingNumber;
import software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.PositiveLong;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.StormTrackingCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.TimeUnits;
import software.amazon.cryptography.materialproviders.internaldafny.types.UpdateUsageMetadataInput;

public class StormTracker {
    public LocalCMC wrapped = null;
    public MutableMap<DafnySequence<? extends Byte>, Long> inFlight = null;
    public long gracePeriod = 0L;
    public long graceInterval = 0L;
    public long fanOut = 0L;
    public long inFlightTTL = 0L;
    public long lastPrune = 0L;
    public long sleepMilli = 0L;
    private static final TypeDescriptor<StormTracker> _TYPE = TypeDescriptor.referenceWithInitializer(StormTracker.class, () -> null);

    public void __ctor(StormTrackingCache cache) {
        long _0_gracePeriod = 0L;
        long _1_graceInterval = 0L;
        long _2_inFlightTTL = 0L;
        if (cache.dtor_timeUnits().UnwrapOr(TimeUnits._typeDescriptor(), TimeUnits.create_Seconds()).is_Seconds()) {
            _0_gracePeriod = (long)cache.dtor_gracePeriod() * 1000L;
            _1_graceInterval = (long)cache.dtor_graceInterval() * 1000L;
            _2_inFlightTTL = (long)cache.dtor_inFlightTTL() * 1000L;
        } else {
            _0_gracePeriod = cache.dtor_gracePeriod();
            _1_graceInterval = cache.dtor_graceInterval();
            _2_inFlightTTL = cache.dtor_inFlightTTL();
        }
        LocalCMC _nw0 = new LocalCMC();
        _nw0.__ctor(cache.dtor_entryCapacity(), cache.dtor_entryPruningTailSize().UnwrapOr(CountingNumber._typeDescriptor(), 1).intValue());
        this.wrapped = _nw0;
        MutableMap _nw1 = new MutableMap(DafnySequence._typeDescriptor(uint8._typeDescriptor()), PositiveLong._typeDescriptor());
        this.inFlight = _nw1;
        this.gracePeriod = _0_gracePeriod;
        this.graceInterval = _1_graceInterval;
        this.fanOut = cache.dtor_fanOut();
        this.inFlightTTL = _2_inFlightTTL;
        this.sleepMilli = cache.dtor_sleepMilli();
        this.lastPrune = 0L;
    }

    public boolean FanOutReached(long now) {
        boolean res = false;
        this.PruneInFlight(now);
        res = this.fanOut <= this.inFlight.Size().longValue();
        return res;
    }

    public long AddLong(long x, long y) {
        if (x < StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT().longValue() - y) {
            return x + y;
        }
        return StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT().longValue();
    }

    public boolean GracePeriod_q(GetCacheEntryOutput result, long now) {
        return result.dtor_expiryTime() < 9223372036854775L && result.dtor_expiryTime() * 1000L - this.gracePeriod <= now;
    }

    public CacheState CheckInFlight(DafnySequence<? extends Byte> identifier, GetCacheEntryOutput result, long now) {
        long _1_entry;
        CacheState output = CacheState.Default();
        boolean _out0 = this.FanOutReached(now);
        boolean _0_fanOutReached = _out0;
        if (_0_fanOutReached) {
            output = CacheState.create_Full(result);
            return output;
        }
        if (!this.GracePeriod_q(result, now)) {
            output = CacheState.create_Full(result);
            return output;
        }
        if (this.inFlight.HasKey(identifier) && this.AddLong(_1_entry = this.inFlight.Select(identifier).longValue(), this.graceInterval) > now) {
            output = CacheState.create_Full(result);
            return output;
        }
        this.inFlight.Put(identifier, now);
        output = CacheState.create_EmptyFetch();
        return output;
    }

    public void PruneInFlight(long now) {
        DafnySequence<DafnySequence<? extends Byte>> _out0;
        if (this.inFlight.Size().longValue() < this.fanOut) {
            return;
        }
        if (now - 1000L < this.lastPrune) {
            return;
        }
        this.lastPrune = now;
        DafnySet<DafnySequence<? extends Byte>> _0_keySet = this.inFlight.Keys();
        DafnySequence<DafnySequence<? extends Byte>> _1_keys = _out0 = SortedSets.__default.SetToSequence(DafnySequence._typeDescriptor(uint8._typeDescriptor()), _0_keySet);
        long _hi0 = _1_keys.cardinalityInt();
        long _2_i = 0L;
        while (Long.compareUnsigned(_2_i, _hi0) < 0) {
            long _3_v = this.inFlight.Select((DafnySequence<? extends Byte>)((DafnySequence)_1_keys.select(Helpers.unsignedToInt((long)_2_i))));
            if (now >= this.AddLong(_3_v, this.inFlightTTL)) {
                this.inFlight.Remove((DafnySequence<? extends Byte>)((DafnySequence)_1_keys.select(Helpers.unsignedToInt((long)_2_i))));
            }
            ++_2_i;
        }
    }

    public CacheState CheckNewEntry(DafnySequence<? extends Byte> identifier, long now) {
        long _1_entry;
        CacheState output = CacheState.Default();
        boolean _out0 = this.FanOutReached(now);
        boolean _0_fanOutReached = _out0;
        if (_0_fanOutReached) {
            output = CacheState.create_EmptyWait();
            return output;
        }
        if (this.inFlight.HasKey(identifier) && now < this.AddLong(_1_entry = this.inFlight.Select(identifier).longValue(), this.graceInterval)) {
            output = CacheState.create_EmptyWait();
            return output;
        }
        this.inFlight.Put(identifier, now);
        output = CacheState.create_EmptyFetch();
        return output;
    }

    public Result<CacheState, Error> GetFromCacheWithTime(GetCacheEntryInput input, long now) {
        Result<CacheState, Error> output = Result.Default(CacheState._typeDescriptor(), Error._typeDescriptor(), CacheState.Default());
        Result<GetCacheEntryOutput, Error> _out0 = this.wrapped.GetCacheEntryWithTime(input, DafnyEuclidean.EuclideanDivision((long)now, (long)1000L));
        Result<GetCacheEntryOutput, Error> _0_result = _out0;
        if (_0_result.is_Success()) {
            CacheState _out1;
            CacheState _1_newResult = _out1 = this.CheckInFlight(input.dtor_identifier(), _0_result.dtor_value(), now);
            output = Result.create_Success(CacheState._typeDescriptor(), Error._typeDescriptor(), _1_newResult);
            return output;
        }
        if (_0_result.dtor_error().is_EntryDoesNotExist()) {
            CacheState _out2;
            CacheState _2_newResult = _out2 = this.CheckNewEntry(input.dtor_identifier(), now);
            output = Result.create_Success(CacheState._typeDescriptor(), Error._typeDescriptor(), _2_newResult);
            return output;
        }
        output = Result.create_Failure(CacheState._typeDescriptor(), Error._typeDescriptor(), _0_result.dtor_error());
        return output;
    }

    public Result<CacheState, Error> GetFromCache(GetCacheEntryInput input) {
        long _out0;
        Result<CacheState, Error> output = Result.Default(CacheState._typeDescriptor(), Error._typeDescriptor(), CacheState.Default());
        long _0_now = _out0 = __default.CurrentRelativeTimeMilli().longValue();
        Result<CacheState, Error> _out1 = this.GetFromCacheWithTime(input, _0_now);
        output = _out1;
        return output;
    }

    public Result<GetCacheEntryOutput, Error> GetCacheEntry(GetCacheEntryInput input) {
        Result<GetCacheEntryOutput, Error> output = null;
        Result<CacheState, Error> _out0 = this.GetFromCache(input);
        Result<CacheState, Error> _0_result = _out0;
        if (_0_result.is_Failure()) {
            output = Result.create_Failure(GetCacheEntryOutput._typeDescriptor(), Error._typeDescriptor(), _0_result.dtor_error());
            return output;
        }
        if (_0_result.dtor_value().is_Full()) {
            output = Result.create_Success(GetCacheEntryOutput._typeDescriptor(), Error._typeDescriptor(), _0_result.dtor_value().dtor_data());
            return output;
        }
        output = Result.create_Failure(GetCacheEntryOutput._typeDescriptor(), Error._typeDescriptor(), Error.create_EntryDoesNotExist((DafnySequence<? extends Character>)DafnySequence.asString((String)"Entry does not exist")));
        return output;
    }

    public Result<Tuple0, Error> PutCacheEntry(PutCacheEntryInput input) {
        Result<Tuple0, Error> output = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
        this.inFlight.Remove(input.dtor_identifier());
        Result<Tuple0, Error> _out0 = this.wrapped.PutCacheEntry_k(input);
        output = _out0;
        return output;
    }

    public Result<Tuple0, Error> DeleteCacheEntry(DeleteCacheEntryInput input) {
        Result<Tuple0, Error> output = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
        this.inFlight.Remove(input.dtor_identifier());
        Result<Tuple0, Error> _out0 = this.wrapped.DeleteCacheEntry_k(input);
        output = _out0;
        return output;
    }

    public Result<Tuple0, Error> UpdateUsageMetadata(UpdateUsageMetadataInput input) {
        Result<Tuple0, Error> output = Result.Default(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.Default());
        Result<Tuple0, Error> _out0 = this.wrapped.UpdateUsageMetadata_k(input);
        output = _out0;
        return output;
    }

    public static TypeDescriptor<StormTracker> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "StormTracker.StormTracker";
    }
}

