/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.rule.autotagging.Attribute;
import org.opensearch.rule.autotagging.FeatureType;
import org.opensearch.rule.storage.AttributeValueStore;

public class AttributeValueStoreFactory {
    private final Map<String, AttributeValueStore<String, String>> attributeValueStores = new HashMap<String, AttributeValueStore<String, String>>();

    public AttributeValueStoreFactory(FeatureType featureType, Supplier<AttributeValueStore<String, String>> attributeValueStoreSupplier) {
        for (Attribute attribute : featureType.getAllowedAttributesRegistry().values()) {
            this.attributeValueStores.put(attribute.getName(), attributeValueStoreSupplier.get());
        }
    }

    public AttributeValueStore<String, String> getAttributeValueStore(Attribute attribute) {
        String attributeName = attribute.getName();
        if (this.attributeValueStores == null) {
            throw new IllegalStateException("AttributeValueStoreFactory is not initialized yet.");
        }
        if (!this.attributeValueStores.containsKey(attributeName)) {
            throw new IllegalArgumentException("[" + attributeName + "] is not a valid attribute for enabled features.");
        }
        return this.attributeValueStores.get(attributeName);
    }
}

