/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH264SliceHeaderFlags;

public class StdVideoEncodeH264SliceHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int FIRST_MB_IN_SLICE;
    public static final int SLICE_TYPE;
    public static final int SEQ_PARAMETER_SET_ID;
    public static final int PIC_PARAMETER_SET_ID;
    public static final int IDR_PIC_ID;
    public static final int NUM_REF_IDX_L0_ACTIVE_MINUS1;
    public static final int NUM_REF_IDX_L1_ACTIVE_MINUS1;
    public static final int CABAC_INIT_IDC;
    public static final int DISABLE_DEBLOCKING_FILTER_IDC;
    public static final int SLICE_ALPHA_C0_OFFSET_DIV2;
    public static final int SLICE_BETA_OFFSET_DIV2;

    public StdVideoEncodeH264SliceHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoEncodeH264SliceHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeH264SliceHeaderFlags flags() {
        return StdVideoEncodeH264SliceHeader.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int first_mb_in_slice() {
        return StdVideoEncodeH264SliceHeader.nfirst_mb_in_slice(this.address());
    }

    @NativeType(value="StdVideoH264SliceType")
    public int slice_type() {
        return StdVideoEncodeH264SliceHeader.nslice_type(this.address());
    }

    @NativeType(value="uint8_t")
    public byte seq_parameter_set_id() {
        return StdVideoEncodeH264SliceHeader.nseq_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pic_parameter_set_id() {
        return StdVideoEncodeH264SliceHeader.npic_parameter_set_id(this.address());
    }

    @NativeType(value="uint16_t")
    public short idr_pic_id() {
        return StdVideoEncodeH264SliceHeader.nidr_pic_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_ref_idx_l0_active_minus1() {
        return StdVideoEncodeH264SliceHeader.nnum_ref_idx_l0_active_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_ref_idx_l1_active_minus1() {
        return StdVideoEncodeH264SliceHeader.nnum_ref_idx_l1_active_minus1(this.address());
    }

    @NativeType(value="StdVideoH264CabacInitIdc")
    public int cabac_init_idc() {
        return StdVideoEncodeH264SliceHeader.ncabac_init_idc(this.address());
    }

    @NativeType(value="StdVideoH264DisableDeblockingFilterIdc")
    public int disable_deblocking_filter_idc() {
        return StdVideoEncodeH264SliceHeader.ndisable_deblocking_filter_idc(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_alpha_c0_offset_div2() {
        return StdVideoEncodeH264SliceHeader.nslice_alpha_c0_offset_div2(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_beta_offset_div2() {
        return StdVideoEncodeH264SliceHeader.nslice_beta_offset_div2(this.address());
    }

    public StdVideoEncodeH264SliceHeader flags(StdVideoEncodeH264SliceHeaderFlags value) {
        StdVideoEncodeH264SliceHeader.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader flags(Consumer<StdVideoEncodeH264SliceHeaderFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH264SliceHeader first_mb_in_slice(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeH264SliceHeader.nfirst_mb_in_slice(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader slice_type(@NativeType(value="StdVideoH264SliceType") int value) {
        StdVideoEncodeH264SliceHeader.nslice_type(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264SliceHeader.nseq_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264SliceHeader.npic_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader idr_pic_id(@NativeType(value="uint16_t") short value) {
        StdVideoEncodeH264SliceHeader.nidr_pic_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader num_ref_idx_l0_active_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264SliceHeader.nnum_ref_idx_l0_active_minus1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader num_ref_idx_l1_active_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH264SliceHeader.nnum_ref_idx_l1_active_minus1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader cabac_init_idc(@NativeType(value="StdVideoH264CabacInitIdc") int value) {
        StdVideoEncodeH264SliceHeader.ncabac_init_idc(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader disable_deblocking_filter_idc(@NativeType(value="StdVideoH264DisableDeblockingFilterIdc") int value) {
        StdVideoEncodeH264SliceHeader.ndisable_deblocking_filter_idc(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader slice_alpha_c0_offset_div2(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH264SliceHeader.nslice_alpha_c0_offset_div2(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader slice_beta_offset_div2(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH264SliceHeader.nslice_beta_offset_div2(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader set(StdVideoEncodeH264SliceHeaderFlags flags, int first_mb_in_slice, int slice_type, byte seq_parameter_set_id, byte pic_parameter_set_id, short idr_pic_id, byte num_ref_idx_l0_active_minus1, byte num_ref_idx_l1_active_minus1, int cabac_init_idc, int disable_deblocking_filter_idc, byte slice_alpha_c0_offset_div2, byte slice_beta_offset_div2) {
        this.flags(flags);
        this.first_mb_in_slice(first_mb_in_slice);
        this.slice_type(slice_type);
        this.seq_parameter_set_id(seq_parameter_set_id);
        this.pic_parameter_set_id(pic_parameter_set_id);
        this.idr_pic_id(idr_pic_id);
        this.num_ref_idx_l0_active_minus1(num_ref_idx_l0_active_minus1);
        this.num_ref_idx_l1_active_minus1(num_ref_idx_l1_active_minus1);
        this.cabac_init_idc(cabac_init_idc);
        this.disable_deblocking_filter_idc(disable_deblocking_filter_idc);
        this.slice_alpha_c0_offset_div2(slice_alpha_c0_offset_div2);
        this.slice_beta_offset_div2(slice_beta_offset_div2);
        return this;
    }

    public StdVideoEncodeH264SliceHeader set(StdVideoEncodeH264SliceHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoEncodeH264SliceHeader malloc() {
        return (StdVideoEncodeH264SliceHeader)StdVideoEncodeH264SliceHeader.wrap(StdVideoEncodeH264SliceHeader.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static StdVideoEncodeH264SliceHeader calloc() {
        return (StdVideoEncodeH264SliceHeader)StdVideoEncodeH264SliceHeader.wrap(StdVideoEncodeH264SliceHeader.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static StdVideoEncodeH264SliceHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (StdVideoEncodeH264SliceHeader)StdVideoEncodeH264SliceHeader.wrap(StdVideoEncodeH264SliceHeader.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static StdVideoEncodeH264SliceHeader create(long address) {
        return (StdVideoEncodeH264SliceHeader)StdVideoEncodeH264SliceHeader.wrap(StdVideoEncodeH264SliceHeader.class, (long)address);
    }

    @Nullable
    public static StdVideoEncodeH264SliceHeader createSafe(long address) {
        return address == 0L ? null : (StdVideoEncodeH264SliceHeader)StdVideoEncodeH264SliceHeader.wrap(StdVideoEncodeH264SliceHeader.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)StdVideoEncodeH264SliceHeader.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)StdVideoEncodeH264SliceHeader.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)StdVideoEncodeH264SliceHeader.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH264SliceHeader.__create((int)capacity, (int)SIZEOF);
        return (Buffer)StdVideoEncodeH264SliceHeader.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)StdVideoEncodeH264SliceHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)StdVideoEncodeH264SliceHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static StdVideoEncodeH264SliceHeader malloc(MemoryStack stack) {
        return (StdVideoEncodeH264SliceHeader)StdVideoEncodeH264SliceHeader.wrap(StdVideoEncodeH264SliceHeader.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static StdVideoEncodeH264SliceHeader calloc(MemoryStack stack) {
        return (StdVideoEncodeH264SliceHeader)StdVideoEncodeH264SliceHeader.wrap(StdVideoEncodeH264SliceHeader.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)StdVideoEncodeH264SliceHeader.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)StdVideoEncodeH264SliceHeader.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static StdVideoEncodeH264SliceHeaderFlags nflags(long struct) {
        return StdVideoEncodeH264SliceHeaderFlags.create(struct + (long)FLAGS);
    }

    public static int nfirst_mb_in_slice(long struct) {
        return UNSAFE.getInt(null, struct + (long)FIRST_MB_IN_SLICE);
    }

    public static int nslice_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)SLICE_TYPE);
    }

    public static byte nseq_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)SEQ_PARAMETER_SET_ID);
    }

    public static byte npic_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)PIC_PARAMETER_SET_ID);
    }

    public static short nidr_pic_id(long struct) {
        return UNSAFE.getShort(null, struct + (long)IDR_PIC_ID);
    }

    public static byte nnum_ref_idx_l0_active_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_REF_IDX_L0_ACTIVE_MINUS1);
    }

    public static byte nnum_ref_idx_l1_active_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_REF_IDX_L1_ACTIVE_MINUS1);
    }

    public static int ncabac_init_idc(long struct) {
        return UNSAFE.getInt(null, struct + (long)CABAC_INIT_IDC);
    }

    public static int ndisable_deblocking_filter_idc(long struct) {
        return UNSAFE.getInt(null, struct + (long)DISABLE_DEBLOCKING_FILTER_IDC);
    }

    public static byte nslice_alpha_c0_offset_div2(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_ALPHA_C0_OFFSET_DIV2);
    }

    public static byte nslice_beta_offset_div2(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_BETA_OFFSET_DIV2);
    }

    public static void nflags(long struct, StdVideoEncodeH264SliceHeaderFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoEncodeH264SliceHeaderFlags.SIZEOF);
    }

    public static void nfirst_mb_in_slice(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FIRST_MB_IN_SLICE, value);
    }

    public static void nslice_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SLICE_TYPE, value);
    }

    public static void nseq_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SEQ_PARAMETER_SET_ID, value);
    }

    public static void npic_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PIC_PARAMETER_SET_ID, value);
    }

    public static void nidr_pic_id(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)IDR_PIC_ID, value);
    }

    public static void nnum_ref_idx_l0_active_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_REF_IDX_L0_ACTIVE_MINUS1, value);
    }

    public static void nnum_ref_idx_l1_active_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_REF_IDX_L1_ACTIVE_MINUS1, value);
    }

    public static void ncabac_init_idc(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CABAC_INIT_IDC, value);
    }

    public static void ndisable_deblocking_filter_idc(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DISABLE_DEBLOCKING_FILTER_IDC, value);
    }

    public static void nslice_alpha_c0_offset_div2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_ALPHA_C0_OFFSET_DIV2, value);
    }

    public static void nslice_beta_offset_div2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_BETA_OFFSET_DIV2, value);
    }

    static {
        Struct.Layout layout = StdVideoEncodeH264SliceHeader.__struct((Struct.Member[])new Struct.Member[]{StdVideoEncodeH264SliceHeader.__member((int)StdVideoEncodeH264SliceHeaderFlags.SIZEOF, (int)StdVideoEncodeH264SliceHeaderFlags.ALIGNOF), StdVideoEncodeH264SliceHeader.__member((int)4), StdVideoEncodeH264SliceHeader.__member((int)4), StdVideoEncodeH264SliceHeader.__member((int)1), StdVideoEncodeH264SliceHeader.__member((int)1), StdVideoEncodeH264SliceHeader.__member((int)2), StdVideoEncodeH264SliceHeader.__member((int)1), StdVideoEncodeH264SliceHeader.__member((int)1), StdVideoEncodeH264SliceHeader.__member((int)4), StdVideoEncodeH264SliceHeader.__member((int)4), StdVideoEncodeH264SliceHeader.__member((int)1), StdVideoEncodeH264SliceHeader.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        FIRST_MB_IN_SLICE = layout.offsetof(1);
        SLICE_TYPE = layout.offsetof(2);
        SEQ_PARAMETER_SET_ID = layout.offsetof(3);
        PIC_PARAMETER_SET_ID = layout.offsetof(4);
        IDR_PIC_ID = layout.offsetof(5);
        NUM_REF_IDX_L0_ACTIVE_MINUS1 = layout.offsetof(6);
        NUM_REF_IDX_L1_ACTIVE_MINUS1 = layout.offsetof(7);
        CABAC_INIT_IDC = layout.offsetof(8);
        DISABLE_DEBLOCKING_FILTER_IDC = layout.offsetof(9);
        SLICE_ALPHA_C0_OFFSET_DIV2 = layout.offsetof(10);
        SLICE_BETA_OFFSET_DIV2 = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH264SliceHeader, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH264SliceHeader ELEMENT_FACTORY = StdVideoEncodeH264SliceHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected StdVideoEncodeH264SliceHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeH264SliceHeaderFlags flags() {
            return StdVideoEncodeH264SliceHeader.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int first_mb_in_slice() {
            return StdVideoEncodeH264SliceHeader.nfirst_mb_in_slice(this.address());
        }

        @NativeType(value="StdVideoH264SliceType")
        public int slice_type() {
            return StdVideoEncodeH264SliceHeader.nslice_type(this.address());
        }

        @NativeType(value="uint8_t")
        public byte seq_parameter_set_id() {
            return StdVideoEncodeH264SliceHeader.nseq_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pic_parameter_set_id() {
            return StdVideoEncodeH264SliceHeader.npic_parameter_set_id(this.address());
        }

        @NativeType(value="uint16_t")
        public short idr_pic_id() {
            return StdVideoEncodeH264SliceHeader.nidr_pic_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_ref_idx_l0_active_minus1() {
            return StdVideoEncodeH264SliceHeader.nnum_ref_idx_l0_active_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_ref_idx_l1_active_minus1() {
            return StdVideoEncodeH264SliceHeader.nnum_ref_idx_l1_active_minus1(this.address());
        }

        @NativeType(value="StdVideoH264CabacInitIdc")
        public int cabac_init_idc() {
            return StdVideoEncodeH264SliceHeader.ncabac_init_idc(this.address());
        }

        @NativeType(value="StdVideoH264DisableDeblockingFilterIdc")
        public int disable_deblocking_filter_idc() {
            return StdVideoEncodeH264SliceHeader.ndisable_deblocking_filter_idc(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_alpha_c0_offset_div2() {
            return StdVideoEncodeH264SliceHeader.nslice_alpha_c0_offset_div2(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_beta_offset_div2() {
            return StdVideoEncodeH264SliceHeader.nslice_beta_offset_div2(this.address());
        }

        public Buffer flags(StdVideoEncodeH264SliceHeaderFlags value) {
            StdVideoEncodeH264SliceHeader.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH264SliceHeaderFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer first_mb_in_slice(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeH264SliceHeader.nfirst_mb_in_slice(this.address(), value);
            return this;
        }

        public Buffer slice_type(@NativeType(value="StdVideoH264SliceType") int value) {
            StdVideoEncodeH264SliceHeader.nslice_type(this.address(), value);
            return this;
        }

        public Buffer seq_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264SliceHeader.nseq_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264SliceHeader.npic_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer idr_pic_id(@NativeType(value="uint16_t") short value) {
            StdVideoEncodeH264SliceHeader.nidr_pic_id(this.address(), value);
            return this;
        }

        public Buffer num_ref_idx_l0_active_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264SliceHeader.nnum_ref_idx_l0_active_minus1(this.address(), value);
            return this;
        }

        public Buffer num_ref_idx_l1_active_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH264SliceHeader.nnum_ref_idx_l1_active_minus1(this.address(), value);
            return this;
        }

        public Buffer cabac_init_idc(@NativeType(value="StdVideoH264CabacInitIdc") int value) {
            StdVideoEncodeH264SliceHeader.ncabac_init_idc(this.address(), value);
            return this;
        }

        public Buffer disable_deblocking_filter_idc(@NativeType(value="StdVideoH264DisableDeblockingFilterIdc") int value) {
            StdVideoEncodeH264SliceHeader.ndisable_deblocking_filter_idc(this.address(), value);
            return this;
        }

        public Buffer slice_alpha_c0_offset_div2(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH264SliceHeader.nslice_alpha_c0_offset_div2(this.address(), value);
            return this;
        }

        public Buffer slice_beta_offset_div2(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH264SliceHeader.nslice_beta_offset_div2(this.address(), value);
            return this;
        }
    }
}

