/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.assertion;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.AudienceRestrictionType;
import org.keycloak.dom.saml.v2.assertion.ConditionAbstractType;
import org.keycloak.dom.saml.v2.assertion.ConditionsType;
import org.keycloak.dom.saml.v2.assertion.OneTimeUseType;
import org.keycloak.dom.saml.v2.assertion.ProxyRestrictionType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.assertion.AbstractStaxSamlAssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAssertionQNames;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAudienceRestrictionParser;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLProxyRestrictionParser;

public class SAMLConditionsParser
extends AbstractStaxSamlAssertionParser<ConditionsType> {
    private static final SAMLConditionsParser INSTANCE = new SAMLConditionsParser();

    private SAMLConditionsParser() {
        super(SAMLAssertionQNames.CONDITIONS);
    }

    public static SAMLConditionsParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected ConditionsType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        ConditionsType conditions = new ConditionsType();
        conditions.setNotBefore(StaxParserUtil.getXmlTimeAttributeValue(element, SAMLAssertionQNames.ATTR_NOT_BEFORE));
        conditions.setNotOnOrAfter(StaxParserUtil.getXmlTimeAttributeValue(element, SAMLAssertionQNames.ATTR_NOT_ON_OR_AFTER));
        return conditions;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, ConditionsType target, SAMLAssertionQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case AUDIENCE_RESTRICTION: {
                AudienceRestrictionType audienceRestriction = (AudienceRestrictionType)SAMLAudienceRestrictionParser.getInstance().parse(xmlEventReader);
                target.addCondition((ConditionAbstractType)audienceRestriction);
                break;
            }
            case ONE_TIME_USE: {
                OneTimeUseType oneTimeUseCondition = new OneTimeUseType();
                target.addCondition((ConditionAbstractType)oneTimeUseCondition);
                break;
            }
            case PROXY_RESTRICTION: {
                ProxyRestrictionType proxyRestriction = (ProxyRestrictionType)SAMLProxyRestrictionParser.getInstance().parse(xmlEventReader);
                target.addCondition((ConditionAbstractType)proxyRestriction);
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

