/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.workflows;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.reflections.Reflections;

public abstract class AbstractWorkflowComponentRepresentation {
    private String id;
    private String uses;
    @JsonProperty(value="with")
    private MultivaluedHashMap<String, String> config;

    public AbstractWorkflowComponentRepresentation(String id, String uses, MultivaluedHashMap<String, String> config) {
        this.id = id;
        this.uses = uses;
        this.config = config;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUses() {
        return this.uses;
    }

    public void setUses(String uses) {
        this.uses = uses;
    }

    public MultivaluedHashMap<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(MultivaluedHashMap<String, String> config) {
        if (this.config == null) {
            this.config = config;
        }
        this.config.putAll(config);
    }

    public void setConfig(String key, String value) {
        this.setConfig(key, Collections.singletonList(value));
    }

    @JsonAnySetter
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public void setConfig(String key, List<String> values) {
        if (this.config == null) {
            this.config = new MultivaluedHashMap();
        }
        this.config.put((Object)key, values);
    }

    protected <T> T getConfigValue(String key, Class<T> type) {
        if (this.config == null) {
            return null;
        }
        return (T)Reflections.convertValueToType((Object)this.config.getFirst((Object)key), type);
    }

    protected List<String> getConfigValues(String key) {
        if (this.config == null) {
            return null;
        }
        try {
            return (List)this.config.get((Object)key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> T getConfigValuesOrSingle(String key) {
        if (this.config == null) {
            return null;
        }
        List values = (List)this.config.get((Object)key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values.size() == 1) {
            return (T)values.get(0);
        }
        return (T)values;
    }

    protected void setConfigValue(String key, Object ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.config == null) {
            this.config = new MultivaluedHashMap();
        }
        if (Reflections.isArrayType(values.getClass())) {
            this.config.put((Object)key, Arrays.stream(values).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList()));
        } else {
            this.config.putSingle((Object)key, (Object)values[0].toString());
        }
    }

    protected void setConfigValue(String key, List<String> values) {
        if (this.config == null) {
            this.config = new MultivaluedHashMap();
        }
        this.config.put((Object)key, values);
    }

    protected void addConfigValue(String key, String value) {
        if (this.config == null) {
            this.config = new MultivaluedHashMap();
        }
        this.config.add((Object)key, (Object)value);
    }
}

