/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourcesaver;

import java.util.Collection;
import java.util.HashMap;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.extension.ExtensionService;
import org.jd.gui.spi.SourceSaver;

public class SourceSaverService {
    protected static final SourceSaverService SOURCE_SAVER_SERVICE = new SourceSaverService();
    protected HashMap<String, SourceSavers> mapProviders = new HashMap();

    public static SourceSaverService getInstance() {
        return SOURCE_SAVER_SERVICE;
    }

    protected SourceSaverService() {
        Collection<SourceSaver> providers = ExtensionService.getInstance().load(SourceSaver.class);
        for (SourceSaver provider : providers) {
            for (String selector : provider.getSelectors()) {
                SourceSavers savers = this.mapProviders.get(selector);
                if (savers == null) {
                    savers = new SourceSavers();
                    this.mapProviders.put(selector, savers);
                }
                savers.add(provider);
            }
        }
    }

    public SourceSaver get(Container.Entry entry) {
        SourceSaver saver = this.get(entry.getContainer().getType(), entry);
        return saver != null ? saver : this.get("*", entry);
    }

    protected SourceSaver get(String containerType, Container.Entry entry) {
        String path = entry.getPath();
        String type = entry.isDirectory() ? "dir" : "file";
        String prefix = containerType + ':' + type;
        SourceSaver saver = null;
        SourceSavers savers = this.mapProviders.get(prefix + ':' + path);
        if (savers != null) {
            saver = savers.match(path);
        }
        if (saver == null) {
            int lastSlashIndex = path.lastIndexOf(47);
            String name = path.substring(lastSlashIndex + 1);
            savers = this.mapProviders.get(prefix + ":*/" + path);
            if (savers != null) {
                saver = savers.match(path);
            }
            if (saver == null) {
                int index = name.lastIndexOf(46);
                if (index != -1) {
                    String extension = name.substring(index + 1);
                    savers = this.mapProviders.get(prefix + ":*." + extension);
                    if (savers != null) {
                        saver = savers.match(path);
                    }
                }
                if (saver == null && (savers = this.mapProviders.get(prefix + ":*")) != null) {
                    saver = savers.match(path);
                }
            }
        }
        return saver;
    }

    protected static class SourceSavers {
        protected HashMap<String, SourceSaver> savers = new HashMap();
        protected SourceSaver defaultSaver;

        protected SourceSavers() {
        }

        void add(SourceSaver saver) {
            if (saver.getPathPattern() != null) {
                this.savers.put(saver.getPathPattern().pattern(), saver);
            } else {
                this.defaultSaver = saver;
            }
        }

        SourceSaver match(String path) {
            for (SourceSaver saver : this.savers.values()) {
                if (!saver.getPathPattern().matcher(path).matches()) continue;
                return saver;
            }
            return this.defaultSaver;
        }
    }
}

