/*
 * Decompiled with CFR 0.152.
 */
package gnu.gettext;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class GettextResource
extends ResourceBundle {
    public static boolean verbose = false;
    private static final String CONTEXT_GLUE = "\u0004";

    private static String gettextnull(ResourceBundle catalog, String msgid) {
        try {
            return (String)catalog.getObject(msgid);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static String gettext(ResourceBundle catalog, String msgid) {
        String result = GettextResource.gettextnull(catalog, msgid);
        if (result != null) {
            return result;
        }
        return msgid;
    }

    private static String ngettextnull(ResourceBundle catalog, String msgid, long n) {
        Object parentCatalog;
        ResourceBundle origCatalog = catalog;
        do {
            Object localValue;
            if (verbose) {
                System.out.println("ngettext on " + catalog);
            }
            Method handleGetObjectMethod = null;
            Method getParentMethod = null;
            try {
                handleGetObjectMethod = catalog.getClass().getMethod("handleGetObject", String.class);
                getParentMethod = catalog.getClass().getMethod("getParent", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (verbose) {
                System.out.println("handleGetObject = " + (handleGetObjectMethod != null) + ", getParent = " + (getParentMethod != null));
            }
            if (handleGetObjectMethod == null || !Modifier.isPublic(handleGetObjectMethod.getModifiers()) || getParentMethod == null) break;
            Method lookupMethod = null;
            Method pluralEvalMethod = null;
            try {
                lookupMethod = catalog.getClass().getMethod("lookup", String.class);
                pluralEvalMethod = catalog.getClass().getMethod("pluralEval", Long.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (verbose) {
                System.out.println("lookup = " + (lookupMethod != null) + ", pluralEval = " + (pluralEvalMethod != null));
            }
            if (lookupMethod != null && pluralEvalMethod != null) {
                localValue = null;
                try {
                    localValue = lookupMethod.invoke((Object)catalog, msgid);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.getTargetException().printStackTrace();
                }
                if (localValue != null) {
                    if (verbose) {
                        System.out.println("localValue = " + localValue);
                    }
                    if (localValue instanceof String) {
                        return (String)localValue;
                    }
                    String[] pluralforms = (String[])localValue;
                    long i = 0L;
                    try {
                        i = (Long)pluralEvalMethod.invoke((Object)catalog, n);
                        if (i < 0L || i >= (long)pluralforms.length) {
                            i = 0L;
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.getTargetException().printStackTrace();
                    }
                    return pluralforms[(int)i];
                }
            } else {
                localValue = null;
                try {
                    localValue = handleGetObjectMethod.invoke((Object)catalog, msgid);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.getTargetException().printStackTrace();
                }
                if (localValue != null) {
                    if (verbose) {
                        System.out.println("localValue = " + localValue);
                    }
                    return (String)localValue;
                }
            }
            parentCatalog = catalog;
            try {
                parentCatalog = getParentMethod.invoke((Object)catalog, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
            }
        } while (parentCatalog != catalog && (catalog = (ResourceBundle)parentCatalog) != null);
        if (catalog != null) {
            Object value;
            try {
                value = catalog.getObject(msgid);
            }
            catch (MissingResourceException e) {
                value = null;
            }
            if (value != null) {
                return (String)value;
            }
        }
        return null;
    }

    public static String ngettext(ResourceBundle catalog, String msgid, String msgid_plural, long n) {
        String result = GettextResource.ngettextnull(catalog, msgid, n);
        if (result != null) {
            return result;
        }
        return n != 1L ? msgid_plural : msgid;
    }

    public static String pgettext(ResourceBundle catalog, String msgctxt, String msgid) {
        String result = GettextResource.gettextnull(catalog, msgctxt + CONTEXT_GLUE + msgid);
        if (result != null) {
            return result;
        }
        return msgid;
    }

    public static String npgettext(ResourceBundle catalog, String msgctxt, String msgid, String msgid_plural, long n) {
        String result = GettextResource.ngettextnull(catalog, msgctxt + CONTEXT_GLUE + msgid, n);
        if (result != null) {
            return result;
        }
        return n != 1L ? msgid_plural : msgid;
    }
}

