untrusted comment: verify with openbsd-78-base.pub
RWS3/nvFmk4SWf3Jk0YiZyjjTl5wnWQSrNPVC9F0cibUsvHpCGY72wdExq1H6BuqA30aJYQdFRJDmXUZzb9A+kLU7pF8waDG5AE=

OpenBSD 7.8 errata 007, December 3, 2025:

Fix drm(4) to avoid spurious sleep errors leading to crashes.

Apply by doing:
    signify -Vep /etc/signify/openbsd-78-base.pub -x 007_drm.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/pci/drm/drm_linux.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/drm_linux.c,v
diff -u -p -r1.126 drm_linux.c
--- sys/dev/pci/drm/drm_linux.c	13 Jun 2025 07:01:37 -0000	1.126
+++ sys/dev/pci/drm/drm_linux.c	24 Nov 2025 21:21:48 -0000
@@ -126,7 +126,7 @@ __set_current_state(int state)
 	SCHED_LOCK();
 	unsleep(p);
 	p->p_stat = SONPROC;
-	atomic_clearbits_int(&p->p_flag, P_INSCHED);
+	atomic_clearbits_int(&p->p_flag, P_INSCHED|P_SINTR);
 	SCHED_UNLOCK();
 }
 
