/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.featurepack;

import java.io.File;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.APIVersion;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.impl.ProvisioningUtil;

@CommandDefinition(name="import", description="Import a feature pack zip file to cache and install it in universe")
public class ImportCommand
extends PmSessionCommand {
    @Argument(required=true, description="Feature pack zip file to import")
    private File path;
    @Option(name="install-in-universe", hasValue=true, required=false, description="Install feature pack to universe. Optional, it is installed by default")
    private Boolean install;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        throw new CommandExecutionException("Shouldn't be called");
    }

    @Override
    public String getCommandClassName(PmSession session) throws ProvisioningException {
        return "org.jboss.galleon.cli.cmd.featurepack.core.CoreImportCommand";
    }

    @Override
    protected String getCoreVersion(PmSession session) throws ProvisioningException {
        String version = ProvisioningUtil.getFeaturePackDescription(this.getPath().toPath()).getGalleonVersion();
        if (version == null || version.isEmpty()) {
            version = APIVersion.getVersion();
        }
        return version;
    }

    public File getPath() {
        return this.path;
    }

    public Boolean getInstall() {
        return this.install;
    }
}

