/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeSet;

public class TranslationReport {
    private static final String stars = "*****************************************************************";
    private static final boolean printSummary = true;

    public static void main(String[] args) throws Exception {
        String localeKey;
        String[] languageFiles;
        ArrayList<LanguageStatsRecord> statistics = new ArrayList<LanguageStatsRecord>();
        String dirName = args[0];
        File directory = new File(dirName);
        if (!directory.isDirectory()) {
            System.exit(1);
        }
        if ((languageFiles = directory.list(new FilenameFilter(localeKey = args.length > 1 ? args[1] : ""){
            final /* synthetic */ String val$localeKey;
            {
                this.val$localeKey = string;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("FreeColMessages_" + this.val$localeKey + ".*\\.properties");
            }
        })) == null) {
            System.err.println("No language files found in " + directory);
            System.exit(1);
        }
        Path filePath = FileSystems.getDefault().getPath(args[0], "FreeColMessages.properties");
        Properties master = new Properties();
        master.load(Files.newInputStream(filePath, new OpenOption[0]));
        Properties properties = new Properties();
        for (String name : languageFiles) {
            LanguageStatsRecord lstat = new LanguageStatsRecord();
            lstat.localFile = name;
            Path propPath = FileSystems.getDefault().getPath(args[0], name);
            properties.clear();
            properties.load(Files.newInputStream(propPath, new OpenOption[0]));
            System.out.println(name.length() + 8 < stars.length() ? stars.substring(0, name.length() + 8) : stars);
            System.out.println("*** " + name + " ***");
            System.out.println(name.length() + 8 < stars.length() ? stars.substring(0, name.length() + 8) : stars);
            ArrayList<String> missingKeys = new ArrayList<String>();
            ArrayList<String> missingVariables = new ArrayList<String>();
            ArrayList<String> copiedFromMaster = new ArrayList<String>();
            for (Object o : master.keySet()) {
                String key = (String)o;
                String value = properties.getProperty(key, null);
                if (value == null) {
                    missingKeys.add(key);
                    continue;
                }
                String masterValue = master.getProperty(key);
                int lastIndex = 0;
                boolean inVariable = false;
                if (!(!value.equalsIgnoreCase(masterValue) || key.contains("newColonyName") || key.contains("foundingFather") && key.contains(".birthAndDeath") || key.contains("foundingFather") && key.contains(".name"))) {
                    copiedFromMaster.add(key);
                }
                TranslationReport.isInVariable(missingVariables, key, value, masterValue, lastIndex, inVariable);
            }
            if (!missingKeys.isEmpty()) {
                System.out.println("** Total of " + missingKeys.size() + " properties missing:\n");
                for (String key : TranslationReport.sort(missingKeys)) {
                    System.out.println(key + "=" + master.getProperty(key));
                }
                lstat.missingKeys = missingKeys.size();
                System.out.println("");
            } else {
                System.out.println("** No properties missing.\n");
            }
            if (!copiedFromMaster.isEmpty()) {
                System.out.println("** Total of " + copiedFromMaster.size() + " properties copied from master properties:\n");
                for (String key : TranslationReport.sort(copiedFromMaster)) {
                    System.out.println(key + "=" + master.getProperty(key));
                }
                lstat.copiedKeys = copiedFromMaster.size();
                System.out.println("");
            } else {
                System.out.println("** No properties copied.\n");
            }
            if (!missingVariables.isEmpty()) {
                System.out.println("** Total of " + missingVariables.size() + " properties with missing variables:\n");
                for (String key : TranslationReport.sort(missingVariables)) {
                    System.out.println("* CORRECT: " + key + "=" + master.getProperty(key));
                    System.out.println("INCORRECT: " + key + "=" + properties.getProperty(key));
                }
                lstat.missingVariables = missingVariables.size();
                System.out.println("");
            } else {
                System.out.println("** No properties with missing variables.\n");
            }
            ArrayList<String> superfluousKeys = new ArrayList<String>();
            ArrayList<String> superfluousVariables = new ArrayList<String>();
            for (Object o : properties.keySet()) {
                String key = (String)o;
                String value = master.getProperty(key, null);
                if (value == null) {
                    superfluousKeys.add(key);
                    continue;
                }
                String propertiesValue = properties.getProperty(key);
                int lastIndex = 0;
                boolean inVariable = false;
                TranslationReport.isInVariable(superfluousVariables, key, value, propertiesValue, lastIndex, inVariable);
            }
            if (!superfluousKeys.isEmpty()) {
                System.out.println("** Total of " + superfluousKeys.size() + " superfluous properties:\n");
                for (String key : TranslationReport.sort(superfluousKeys)) {
                    System.out.println(key + "=" + properties.getProperty(key));
                }
                lstat.superfluousKeys = superfluousKeys.size();
                System.out.println("");
            } else {
                System.out.println("** No superfluous properties.\n");
            }
            if (!superfluousVariables.isEmpty()) {
                System.out.println("** Total of " + superfluousVariables.size() + " properties with superfluous variables:\n");
                for (String key : TranslationReport.sort(superfluousVariables)) {
                    System.out.println("* CORRECT: " + key + "=" + master.getProperty(key));
                    System.out.println("INCORRECT: " + key + "=" + properties.getProperty(key));
                }
                lstat.superfluousVariables = superfluousVariables.size();
                System.out.println("");
            } else {
                System.out.println("** No properties with superfluous variables.\n");
            }
            statistics.add(lstat);
        }
        System.out.println(stars);
        System.out.println("*** Summary of translation efforts (" + master.size() + " keys in master file) ***");
        System.out.println(stars);
        for (LanguageStatsRecord stats : statistics) {
            StringBuilder output = new StringBuilder();
            output.append((CharSequence)TranslationReport.shortenName(stats.localFile));
            output.append(": ");
            output.append((CharSequence)TranslationReport.prettyPrint(stats.missingKeys));
            output.append(" keys missing, ");
            output.append((CharSequence)TranslationReport.prettyPrint(stats.missingVariables));
            output.append(" vars missing, ");
            output.append((CharSequence)TranslationReport.prettyPrint(stats.copiedKeys));
            output.append(" entries copied, ");
            output.append((CharSequence)TranslationReport.prettyPrint(stats.superfluousKeys));
            output.append(" redundant keys, ");
            output.append((CharSequence)TranslationReport.prettyPrint(stats.superfluousVariables));
            output.append(" redundant vars. ");
            float percentageDone = (float)(100 * (master.size() - (stats.missingKeys + stats.copiedKeys))) / (float)master.size();
            percentageDone = (float)Math.round(percentageDone * 100.0f) / 100.0f;
            output.append(percentageDone).append("% finished.");
            System.out.println(output.toString());
        }
    }

    private static void isInVariable(ArrayList<String> superfluousVariables, String key, String value, String propertiesValue, int lastIndex, boolean inVariable) {
        for (int index = 0; index < propertiesValue.length() - 1; ++index) {
            char current = propertiesValue.charAt(index);
            if (current == '%') {
                if (inVariable) {
                    String var = propertiesValue.substring(lastIndex, index + 1);
                    if (!value.contains(var)) {
                        superfluousVariables.add(key);
                    }
                    inVariable = false;
                    continue;
                }
                lastIndex = index;
                inVariable = true;
                continue;
            }
            if (Character.isLetterOrDigit(current)) continue;
            inVariable = false;
        }
    }

    private static StringBuilder shortenName(String localFile) {
        StringBuilder out = new StringBuilder(5);
        String temp = localFile.substring(16, localFile.indexOf(46));
        if (temp.length() < 5) {
            out.append("   ");
        }
        out.append(temp);
        return out;
    }

    private static StringBuilder prettyPrint(int number) {
        StringBuilder output = new StringBuilder(4);
        if (number < 10) {
            output.append(' ');
        }
        if (number < 100) {
            output.append(' ');
        }
        if (number < 1000) {
            output.append(' ');
        }
        output.append(number);
        return output;
    }

    private static TreeSet<String> sort(ArrayList<String> missingKeys) {
        TreeSet<String> sorted = new TreeSet<String>();
        sorted.addAll(missingKeys);
        return sorted;
    }

    private static class LanguageStatsRecord {
        String localFile = "";
        int missingKeys = 0;
        int missingVariables = 0;
        int copiedKeys = 0;
        public int superfluousVariables;
        public int superfluousKeys;

        private LanguageStatsRecord() {
        }
    }
}

