/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl.drown;

import de.rub.nds.tlsattacker.attacks.impl.drown.LeakyExportCheckData;
import de.rub.nds.tlsattacker.attacks.impl.drown.ServerVerifyChecker;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import java.util.concurrent.Callable;

class LeakyExportCheckCallable
implements Callable<Boolean> {
    private int firstByteFrom;
    private int firstByteTo;
    private volatile int processedSecondBytes;
    private LeakyExportCheckData data;

    public LeakyExportCheckCallable(int firstByteFrom, int firstByteTo, LeakyExportCheckData data) {
        this.firstByteFrom = firstByteFrom;
        this.firstByteTo = firstByteTo;
        this.processedSecondBytes = 0;
        this.data = data;
    }

    public int getProcessedSecondBytes() {
        return this.processedSecondBytes;
    }

    @Override
    public Boolean call() {
        byte[] masterKey = new byte[this.data.getClearKey().length + this.data.getCipherSuite().getSecretKeyByteNumber()];
        System.arraycopy(this.data.getClearKey(), 0, masterKey, 0, this.data.getClearKey().length);
        int secretKeyBytesUsed = Math.min(this.data.getSecretKeyPlain().length, this.data.getCipherSuite().getSecretKeyByteNumber());
        System.arraycopy(this.data.getSecretKeyPlain(), 0, masterKey, this.data.getClearKey().length, secretKeyBytesUsed);
        if (secretKeyBytesUsed < this.data.getCipherSuite().getSecretKeyByteNumber()) {
            System.arraycopy(this.data.getSecretKeyEnc(), secretKeyBytesUsed, masterKey, this.data.getClearKey().length + secretKeyBytesUsed, this.data.getCipherSuite().getSecretKeyByteNumber() - secretKeyBytesUsed);
        }
        for (int a = this.firstByteFrom; a < this.firstByteTo; ++a) {
            masterKey[0] = (byte)a;
            for (int b = -128; b < 128; ++b) {
                masterKey[1] = (byte)b;
                for (int c = -128; c < 128; ++c) {
                    masterKey[2] = (byte)c;
                    for (int d = -128; d < 128; ++d) {
                        masterKey[3] = (byte)d;
                        for (int e = -128; e < 128; ++e) {
                            if (Thread.currentThread().isInterrupted()) {
                                return false;
                            }
                            masterKey[4] = (byte)e;
                            if (!this.checkMasterKey(masterKey)) continue;
                            return true;
                        }
                    }
                }
                ++this.processedSecondBytes;
            }
        }
        return false;
    }

    private boolean checkMasterKey(byte[] masterKey) {
        byte[] clientReadKey = ServerVerifyChecker.makeKeyMaterial(masterKey, this.data.getClientRandom(), this.data.getServerRandom(), "0");
        byte[] decrypted = this.data.getCipherSuite() == SSL2CipherSuite.SSL_CK_RC4_128_EXPORT40_WITH_MD5 ? ServerVerifyChecker.decryptRC4(clientReadKey, this.data.getEncrypted()) : ServerVerifyChecker.decryptRC2(clientReadKey, this.data.getEncrypted(), this.data.getIv(), this.data.getPaddingLength());
        return ServerVerifyChecker.compareDecrypted(decrypted, this.data.getClientRandom(), true);
    }
}

