/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfATTRIB;
import de.escape.quincunx.dxf.reader.DxfConverter;
import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.dxf.reader.DxfEntityCollector;
import de.escape.quincunx.dxf.reader.DxfEntitySet;
import de.escape.quincunx.dxf.reader.DxfException;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.trafo.Point3D;

public class DxfINSERT
extends DxfEntity
implements DxfEntityCollector {
    protected Point3D insertPoint = new Point3D();
    protected String blockName;
    protected float scaleX = 1.0f;
    protected float scaleY = 1.0f;
    protected float scaleZ = 1.0f;
    protected float rotAngle;
    protected int nrRows = 1;
    protected int nrCols = 1;
    protected float rowDist;
    protected float colDist;
    protected boolean attribFollows = false;
    protected DxfEntitySet attribSet;

    public boolean setGroup(short grpNr, float fval) {
        switch (grpNr) {
            case 10: 
            case 20: 
            case 30: {
                this.setCoord(this.insertPoint, grpNr / 10, fval);
                return true;
            }
            case 41: {
                this.scaleX = fval;
                return true;
            }
            case 42: {
                this.scaleY = fval;
                return true;
            }
            case 43: {
                this.scaleZ = fval;
                return true;
            }
            case 44: {
                this.colDist = fval;
                return true;
            }
            case 45: {
                this.rowDist = fval;
                return true;
            }
            case 50: {
                this.rotAngle = (float)((double)fval / 180.0 * Math.PI);
                return true;
            }
        }
        return super.setGroup(grpNr, fval);
    }

    public boolean setGroup(short grpNr, int ival) {
        switch (grpNr) {
            case 66: {
                boolean bl = this.attribFollows = ival != 0;
                if (this.attribFollows) {
                    this.attribSet = new DxfEntitySet();
                }
                return true;
            }
            case 70: {
                this.nrCols = ival;
                return true;
            }
            case 71: {
                this.nrRows = ival;
                return true;
            }
        }
        return super.setGroup(grpNr, ival);
    }

    public boolean setGroup(short grpNr, String str) {
        switch (grpNr) {
            case 2: {
                this.blockName = str;
                return true;
            }
        }
        return super.setGroup(grpNr, str);
    }

    public void convert(DxfConverter converter, DxfFile dxf, Object collector) {
        converter.convert(this, dxf, collector);
    }

    public final Point3D getInsertPoint() {
        return this.insertPoint;
    }

    public final String getBlockName() {
        return this.blockName;
    }

    public final float getScaleX() {
        return this.scaleX;
    }

    public final float getScaleY() {
        return this.scaleY;
    }

    public final float getScaleZ() {
        return this.scaleZ;
    }

    public final float getRotation() {
        return this.rotAngle;
    }

    public final int getRows() {
        return this.nrRows;
    }

    public final int getColumns() {
        return this.nrCols;
    }

    public final float getRowDistance() {
        return this.rowDist;
    }

    public final float getColumnDistance() {
        return this.colDist;
    }

    public final boolean attributesFollowing() {
        return this.attribFollows;
    }

    public boolean addEntity(DxfEntity entity) throws DxfException {
        if (this.attribFollows && entity instanceof DxfATTRIB) {
            this.attribSet.addEntity(entity);
            return true;
        }
        return false;
    }

    public DxfEntityCollector getEntityCollector() {
        return this.attribFollows ? this : null;
    }

    public DxfEntitySet getAttributes() {
        return this.attribSet;
    }
}

