/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs.backward_codecs.lucene99;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsFormat;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.opensearch.index.codec.customcodecs.ZstdCompressionMode;
import org.opensearch.index.codec.customcodecs.ZstdNoDictCompressionMode;
import org.opensearch.index.codec.customcodecs.backward_codecs.lucene99.Lucene99CustomCodec;

public class Lucene99CustomStoredFieldsFormat
extends StoredFieldsFormat {
    public static final String MODE_KEY = Lucene99CustomStoredFieldsFormat.class.getSimpleName() + ".mode";
    protected static final int ZSTD_BLOCK_LENGTH = 491520;
    protected static final int ZSTD_MAX_DOCS_PER_BLOCK = 4096;
    protected static final int ZSTD_BLOCK_SHIFT = 10;
    private final CompressionMode zstdCompressionMode;
    private final CompressionMode zstdNoDictCompressionMode;
    private final Lucene99CustomCodec.Mode mode;
    private final int compressionLevel;

    public Lucene99CustomStoredFieldsFormat() {
        this(Lucene99CustomCodec.Mode.ZSTD, Lucene99CustomCodec.DEFAULT_COMPRESSION_LEVEL);
    }

    public Lucene99CustomStoredFieldsFormat(Lucene99CustomCodec.Mode mode) {
        this(mode, Lucene99CustomCodec.DEFAULT_COMPRESSION_LEVEL);
    }

    public Lucene99CustomStoredFieldsFormat(Lucene99CustomCodec.Mode mode, int compressionLevel) {
        this.mode = Objects.requireNonNull(mode);
        this.compressionLevel = compressionLevel;
        this.zstdCompressionMode = new ZstdCompressionMode(this, compressionLevel){};
        this.zstdNoDictCompressionMode = new ZstdNoDictCompressionMode(this, compressionLevel){};
    }

    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        if (si.getAttribute(MODE_KEY) != null) {
            String value = si.getAttribute(MODE_KEY);
            Lucene99CustomCodec.Mode mode = Lucene99CustomCodec.Mode.valueOf(value);
            return this.impl(mode).fieldsReader(directory, si, fn, context);
        }
        throw new IllegalStateException("missing value for " + MODE_KEY + " for segment: " + si.name);
    }

    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        String previous = si.putAttribute(MODE_KEY, this.mode.name());
        if (previous != null && !previous.equals(this.mode.name())) {
            throw new IllegalStateException("found existing value for " + MODE_KEY + " for segment: " + si.name + " old = " + previous + ", new = " + this.mode.name());
        }
        return this.impl(this.mode).fieldsWriter(directory, si, context);
    }

    StoredFieldsFormat impl(Lucene99CustomCodec.Mode mode) {
        switch (mode) {
            case ZSTD: {
                return this.getCustomCompressingStoredFieldsFormat("CustomStoredFieldsZstd", this.zstdCompressionMode);
            }
            case ZSTD_NO_DICT: {
                return this.getCustomCompressingStoredFieldsFormat("CustomStoredFieldsZstdNoDict", this.zstdNoDictCompressionMode);
            }
        }
        throw new IllegalStateException("Unsupported compression mode: " + String.valueOf((Object)mode));
    }

    private StoredFieldsFormat getCustomCompressingStoredFieldsFormat(String formatName, CompressionMode compressionMode) {
        return new Lucene90CompressingStoredFieldsFormat(formatName, compressionMode, 491520, 4096, 10);
    }

    public Lucene99CustomCodec.Mode getMode() {
        return this.mode;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public CompressionMode getCompressionMode() {
        return this.mode == Lucene99CustomCodec.Mode.ZSTD_NO_DICT ? this.zstdNoDictCompressionMode : this.zstdCompressionMode;
    }
}

