/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model;

import java.io.IOException;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.threatIntel.model.DefaultIocStoreConfig;

public abstract class IocStoreConfig {
    private static final Logger log = LogManager.getLogger(IocStoreConfig.class);

    abstract String name();

    static IocStoreConfig readFrom(StreamInput sin) throws IOException {
        Type type = (Type)sin.readEnum(Type.class);
        switch (type.ordinal()) {
            case 0: {
                return new DefaultIocStoreConfig(sin);
            }
        }
        throw new IllegalStateException("Unexpected input [" + String.valueOf((Object)type) + "] when reading ioc store config");
    }

    static IocStoreConfig parse(XContentParser xcp) throws IOException {
        DefaultIocStoreConfig iocStoreConfig = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "default": {
                    iocStoreConfig = DefaultIocStoreConfig.parse(xcp);
                }
            }
        }
        return iocStoreConfig;
    }

    public void writeTo(StreamOutput out) throws IOException {
    }

    static enum Type {
        DEFAULT;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

