/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class ListIOCsActionRequest
extends ActionRequest {
    public static final String FEED_IDS_FIELD = "feed_ids";
    public static String SEARCH_FIELD = "search";
    public static String TYPE_FIELD = "ioc_types";
    public static String ALL_TYPES_FILTER = "ALL";
    private final Table table;
    private List<String> types;
    private List<String> feedIds;

    public ListIOCsActionRequest(List<String> types, List<String> feedIds, Table table) {
        this.table = table;
        this.types = types == null ? Collections.emptyList() : types.stream().map(t -> t.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        this.feedIds = feedIds == null ? Collections.emptyList() : feedIds;
    }

    public ListIOCsActionRequest(StreamInput sin) throws IOException {
        this(sin.readOptionalStringList(), sin.readOptionalStringList(), Table.readFrom((StreamInput)sin));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalStringCollection(this.types);
        out.writeOptionalStringCollection(this.feedIds);
        this.table.writeTo(out);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.table.getStartIndex() < 0) {
            validationException = ValidateActions.addValidationError((String)String.format("start_index param cannot be a negative number.", new Object[0]), validationException);
        } else if (this.table.getSize() < 0 || this.table.getSize() > 10000) {
            validationException = ValidateActions.addValidationError((String)String.format("size param must be between 0 and 10,000.", new Object[0]), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public Table getTable() {
        return this.table;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public List<String> getFeedIds() {
        return this.feedIds;
    }

    public static enum SortOrder {
        asc,
        dsc;

    }
}

