/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter.provider;

import java.util.Comparator;
import org.opensearch.common.Numbers;
import org.opensearch.index.compositeindex.datacube.DimensionDataType;
import org.opensearch.search.startree.filter.provider.NumericNonDecimalMapper;

class UnsignedLongFieldMapperNumeric
extends NumericNonDecimalMapper {
    UnsignedLongFieldMapperNumeric() {
    }

    @Override
    Long defaultMinimum() {
        return Numbers.MIN_UNSIGNED_LONG_VALUE_AS_LONG;
    }

    @Override
    Long defaultMaximum() {
        return Numbers.MAX_UNSIGNED_LONG_VALUE_AS_LONG;
    }

    @Override
    public Comparator<Long> comparator() {
        return DimensionDataType.UNSIGNED_LONG::compare;
    }

    @Override
    public int compareValues(Object v1, Object v2) {
        if (!(v1 instanceof Long) || !(v2 instanceof Long)) {
            throw new IllegalArgumentException("Expected Long values for unsigned comparison");
        }
        return Long.compareUnsigned((Long)v1, (Long)v2);
    }

    @Override
    public boolean isValueInRange(Object value, Object low, Object high, boolean includeLow, boolean includeHigh) {
        long h;
        long v = (Long)value;
        long l = low != null ? (Long)low : 0L;
        long l2 = h = high != null ? (Long)high : -1L;
        if (Long.compareUnsigned(l, h) > 0) {
            return Long.compareUnsigned(v, l) > 0 || Long.compareUnsigned(v, l) == 0 && includeLow || Long.compareUnsigned(v, h) < 0 || Long.compareUnsigned(v, h) == 0 && includeHigh;
        }
        return super.isValueInRange(value, low, high, includeLow, includeHigh);
    }
}

