/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.models.RefType;
import io.swagger.v3.parser.urlresolver.PermittedUrlsChecker;
import io.swagger.v3.parser.urlresolver.exceptions.HostDeniedException;
import io.swagger.v3.parser.util.DeserializationUtils;
import io.swagger.v3.parser.util.OpenAPIDeserializer;
import io.swagger.v3.parser.util.PathUtils;
import io.swagger.v3.parser.util.RefUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ResolverCache {
    private static final Pattern SCHEMAS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "schemas/(?<name>.+)");
    private static final Pattern RESPONSES_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "responses/(?<name>.+)");
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "parameters/(?<name>.+)");
    private static final Pattern REQUEST_BODIES_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "requestBodies/(?<name>.+)");
    private static final Pattern EXAMPLES_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "examples/(?<name>.+)");
    private static final Pattern LINKS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "links/(?<name>.+)");
    private static final Pattern CALLBACKS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "callbacks/(?<name>.+)");
    private static final Pattern HEADERS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "headers/(?<name>.+)");
    private static final Pattern SECURITY_SCHEMES = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "securitySchemes/(?<name>.+)");
    private static final Pattern PATHS_PATTERN = Pattern.compile("^" + RefType.PATH.getInternalPrefix() + "(?<name>.+)");
    private final OpenAPI openApi;
    private final List<AuthorizationValue> auths;
    private final Path parentDirectory;
    private final String rootPath;
    private Map<String, Object> resolutionCache = new HashMap<String, Object>();
    private Map<String, String> externalFileCache = new HashMap<String, String>();
    private List<String> referencedModelKeys = new ArrayList<String>();
    private Set<String> resolveValidationMessages;
    private final ParseOptions parseOptions;
    protected boolean openapi31;
    private Map<String, String> renameCache = new HashMap<String, String>();

    public ResolverCache(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation) {
        this(openApi, auths, parentFileLocation, new HashSet<String>());
    }

    public ResolverCache(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation, Set<String> resolveValidationMessages) {
        this(openApi, auths, parentFileLocation, resolveValidationMessages, new ParseOptions());
    }

    public ResolverCache(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation, Set<String> resolveValidationMessages, ParseOptions parseOptions) {
        this.openapi31 = openApi != null && openApi.getOpenapi() != null && openApi.getOpenapi().startsWith("3.1");
        this.openApi = openApi;
        this.auths = auths;
        this.rootPath = parentFileLocation;
        this.resolveValidationMessages = resolveValidationMessages;
        this.parseOptions = parseOptions;
        if (parentFileLocation != null) {
            this.parentDirectory = parentFileLocation.startsWith("http") || parentFileLocation.startsWith("jar") ? null : PathUtils.getParentDirectoryOfFile(parentFileLocation);
        } else {
            File file = new File(".");
            this.parentDirectory = file.toPath();
        }
    }

    public <T> T loadRef(String ref, RefFormat refFormat, Class<T> expectedType) {
        String[] jsonPathElements;
        String contents;
        if (refFormat == RefFormat.INTERNAL) {
            Object loadedRef = this.loadInternalRef(ref);
            try {
                return expectedType.cast(loadedRef);
            }
            catch (Exception e) {
                return null;
            }
        }
        String[] refParts = ref.split("#/");
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file = refParts[0];
        String definitionPath = refParts.length == 2 ? refParts[1] : null;
        Object previouslyResolvedEntity = this.resolutionCache.get(ref);
        if (previouslyResolvedEntity != null) {
            if (expectedType.equals(Header.class)) {
                if (expectedType.getClass().equals(previouslyResolvedEntity.getClass())) {
                    return expectedType.cast(previouslyResolvedEntity);
                }
            } else {
                return expectedType.cast(previouslyResolvedEntity);
            }
        }
        if ((contents = this.externalFileCache.get(file)) == null) {
            if (this.parseOptions.isSafelyResolveURL()) {
                this.checkUrlIsPermitted(file);
            }
            if (this.parentDirectory != null) {
                contents = RefUtils.readExternalRef(file, refFormat, this.auths, this.parentDirectory);
            } else if (this.rootPath != null && this.rootPath.startsWith("http")) {
                contents = RefUtils.readExternalUrlRef(file, refFormat, this.auths, this.rootPath);
            } else if (this.rootPath != null) {
                contents = RefUtils.readExternalClasspathRef(file, refFormat, this.auths, this.rootPath);
            }
            this.externalFileCache.put(file, contents);
        }
        SwaggerParseResult deserializationUtilResult = new SwaggerParseResult();
        JsonNode tree = DeserializationUtils.deserializeIntoTree(contents, file, this.parseOptions, deserializationUtilResult);
        if (definitionPath == null) {
            T result = null;
            result = this.parseOptions.isValidateExternalRefs() ? (T)this.deserializeFragment(tree, expectedType, file, "/") : (T)DeserializationUtils.deserialize(contents, file, expectedType, this.openapi31);
            this.resolutionCache.put(ref, result);
            if (deserializationUtilResult.getMessages() != null && this.resolveValidationMessages != null) {
                this.resolveValidationMessages.addAll(deserializationUtilResult.getMessages());
            }
            return result;
        }
        for (String jsonPathElement : jsonPathElements = definitionPath.split("/")) {
            if (tree.isArray()) {
                try {
                    tree = tree.get(Integer.valueOf(jsonPathElement).intValue());
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                tree = tree.get(this.unescapePointer(jsonPathElement));
            }
            if (tree != null) continue;
            throw new RuntimeException("Could not find " + definitionPath + " in contents of " + file);
        }
        Schema result = null;
        if (this.parseOptions.isValidateExternalRefs()) {
            result = (Schema)this.deserializeFragment(tree, expectedType, file, definitionPath);
        } else if (expectedType.equals(Schema.class)) {
            OpenAPIDeserializer deserializer = new OpenAPIDeserializer();
            result = deserializer.getSchema((JsonNode)((ObjectNode)tree), definitionPath.replace("/", "."), new OpenAPIDeserializer.ParseResult().openapi31(this.openapi31));
        } else {
            result = (Schema)DeserializationUtils.deserialize(tree, file, expectedType, this.openapi31);
        }
        this.updateLocalRefs(file, (T)result);
        this.resolutionCache.put(ref, result);
        if (deserializationUtilResult.getMessages() != null && this.resolveValidationMessages != null) {
            this.resolveValidationMessages.addAll(deserializationUtilResult.getMessages());
        }
        return (T)result;
    }

    private <T> T deserializeFragment(JsonNode node, Class<T> expectedType, String file, String definitionPath) {
        OpenAPIDeserializer deserializer = new OpenAPIDeserializer();
        OpenAPIDeserializer.ParseResult parseResult = new OpenAPIDeserializer.ParseResult();
        Schema result = null;
        if (expectedType.equals(Schema.class)) {
            result = deserializer.getSchema((JsonNode)((ObjectNode)node), definitionPath.replace("/", "."), parseResult);
        } else if (expectedType.equals(RequestBody.class)) {
            result = deserializer.getRequestBody((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType.equals(ApiResponse.class)) {
            result = deserializer.getResponse((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType.equals(Callback.class)) {
            result = deserializer.getCallback((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType.equals(Example.class)) {
            result = deserializer.getExample((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType.equals(Header.class)) {
            result = deserializer.getHeader((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType.equals(Link.class)) {
            result = deserializer.getLink((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType.equals(Parameter.class)) {
            result = deserializer.getParameter((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType.equals(SecurityScheme.class)) {
            result = deserializer.getSecurityScheme((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        } else if (expectedType.equals(PathItem.class)) {
            result = deserializer.getPathItem((ObjectNode)node, definitionPath.replace("/", "."), parseResult);
        }
        parseResult.getMessages().forEach(m -> this.resolveValidationMessages.add(m + " (" + file + ")"));
        if (result != null) {
            return (T)result;
        }
        return DeserializationUtils.deserialize(node, file, expectedType);
    }

    protected <T> void updateLocalRefs(String file, T result) {
        Parameter parameter;
        if (result instanceof Parameter && (parameter = (Parameter)result).getSchema() != null) {
            this.updateLocalRefs(file, parameter.getSchema());
        }
        if (result instanceof Schema && ((Schema)result).get$ref() != null) {
            Schema prop = (Schema)result;
            this.updateLocalRefs(file, prop);
        } else if (result instanceof Schema) {
            Schema model = (Schema)result;
            this.updateLocalRefs(file, model);
        }
    }

    protected <T> void updateLocalRefs(String file, Schema schema) {
        if (schema.get$ref() != null) {
            String updatedLocation = this.merge(file, schema.get$ref());
            schema.set$ref(updatedLocation);
        } else if (schema.getProperties() != null) {
            Map properties = schema.getProperties();
            for (Schema property : properties.values()) {
                this.updateLocalRefs(file, property);
            }
        }
    }

    protected String merge(String host, String ref) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return ref;
        }
        if (ref.startsWith("http:") || ref.startsWith("https:")) {
            return ref;
        }
        if (!(host.startsWith("http:") || host.startsWith("https:") || ref.startsWith("#/components"))) {
            return ref;
        }
        if (ref.startsWith(".")) {
            return ref;
        }
        if (host.endsWith("/") && ref.startsWith("/")) {
            return host + ref.substring(1);
        }
        return host + ref;
    }

    private Object loadInternalRef(String ref) {
        Object result = null;
        if (ref.startsWith("#/paths")) {
            result = this.getFromMap(ref, (Map)this.openApi.getPaths(), PATHS_PATTERN);
        } else if (this.openApi.getComponents() != null) {
            if (ref.startsWith("#/components/schemas")) {
                result = this.getFromMap(ref, this.openApi.getComponents().getSchemas(), SCHEMAS_PATTERN);
            } else if (ref.startsWith("#/components/requestBodies")) {
                result = this.getFromMap(ref, this.openApi.getComponents().getRequestBodies(), REQUEST_BODIES_PATTERN);
            } else if (ref.startsWith("#/components/examples")) {
                result = this.getFromMap(ref, this.openApi.getComponents().getExamples(), EXAMPLES_PATTERN);
            } else if (ref.startsWith("#/components/responses")) {
                result = this.getFromMap(ref, this.openApi.getComponents().getResponses(), RESPONSES_PATTERN);
            } else if (ref.startsWith("#/components/parameters")) {
                result = this.getFromMap(ref, this.openApi.getComponents().getParameters(), PARAMETERS_PATTERN);
            } else if (ref.startsWith("#/components/links")) {
                result = this.getFromMap(ref, this.openApi.getComponents().getLinks(), LINKS_PATTERN);
            } else if (ref.startsWith("#/components/headers")) {
                result = this.getFromMap(ref, this.openApi.getComponents().getHeaders(), HEADERS_PATTERN);
            } else if (ref.startsWith("#/components/callbacks")) {
                result = this.getFromMap(ref, this.openApi.getComponents().getCallbacks(), CALLBACKS_PATTERN);
            } else if (ref.startsWith("#/components/securitySchemes")) {
                result = this.getFromMap(ref, this.openApi.getComponents().getSecuritySchemes(), SECURITY_SCHEMES);
            }
        }
        return result;
    }

    private String unescapePointer(String jsonPathElement) {
        try {
            jsonPathElement = URLDecoder.decode(jsonPathElement, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        jsonPathElement = jsonPathElement.replaceAll("~1", "/");
        return jsonPathElement.replaceAll("~0", "~");
    }

    private Object getFromMap(String ref, Map map, Pattern pattern) {
        Matcher parameterMatcher = pattern.matcher(ref);
        if (parameterMatcher.matches()) {
            String paramName = this.unescapePointer(parameterMatcher.group("name"));
            if (map != null) {
                return map.get(paramName);
            }
        }
        return null;
    }

    protected void checkUrlIsPermitted(String refSet) {
        try {
            PermittedUrlsChecker permittedUrlsChecker = new PermittedUrlsChecker(this.parseOptions.getRemoteRefAllowList(), this.parseOptions.getRemoteRefBlockList());
            permittedUrlsChecker.verify(refSet);
        }
        catch (HostDeniedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean hasReferencedKey(String modelKey) {
        if (this.referencedModelKeys == null) {
            return false;
        }
        return this.referencedModelKeys.contains(modelKey);
    }

    public void addReferencedKey(String modelKey) {
        this.referencedModelKeys.add(modelKey);
    }

    public String getRenamedRef(String originalRef) {
        return this.renameCache.get(originalRef);
    }

    public void putRenamedRef(String originalRef, String newRef) {
        this.renameCache.put(originalRef, newRef);
    }

    public Map<String, Object> getResolutionCache() {
        return Collections.unmodifiableMap(this.resolutionCache);
    }

    public Map<String, String> getExternalFileCache() {
        return Collections.unmodifiableMap(this.externalFileCache);
    }

    public Map<String, String> getRenameCache() {
        return Collections.unmodifiableMap(this.renameCache);
    }

    public ParseOptions getParseOptions() {
        return this.parseOptions;
    }
}

