/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.services.kms.internaldafny.types;

import dafny.TypeDescriptor;
import java.util.ArrayList;
import software.amazon.cryptography.services.kms.internaldafny.types.SigningAlgorithmSpec_ECDSA__SHA__256;
import software.amazon.cryptography.services.kms.internaldafny.types.SigningAlgorithmSpec_ECDSA__SHA__384;
import software.amazon.cryptography.services.kms.internaldafny.types.SigningAlgorithmSpec_ECDSA__SHA__512;
import software.amazon.cryptography.services.kms.internaldafny.types.SigningAlgorithmSpec_RSASSA__PKCS1__V1__5__SHA__256;
import software.amazon.cryptography.services.kms.internaldafny.types.SigningAlgorithmSpec_RSASSA__PKCS1__V1__5__SHA__384;
import software.amazon.cryptography.services.kms.internaldafny.types.SigningAlgorithmSpec_RSASSA__PKCS1__V1__5__SHA__512;
import software.amazon.cryptography.services.kms.internaldafny.types.SigningAlgorithmSpec_RSASSA__PSS__SHA__256;
import software.amazon.cryptography.services.kms.internaldafny.types.SigningAlgorithmSpec_RSASSA__PSS__SHA__384;
import software.amazon.cryptography.services.kms.internaldafny.types.SigningAlgorithmSpec_RSASSA__PSS__SHA__512;
import software.amazon.cryptography.services.kms.internaldafny.types.SigningAlgorithmSpec_SM2DSA;

public abstract class SigningAlgorithmSpec {
    private static final TypeDescriptor<SigningAlgorithmSpec> _TYPE = TypeDescriptor.referenceWithInitializer(SigningAlgorithmSpec.class, () -> SigningAlgorithmSpec.Default());
    private static final SigningAlgorithmSpec theDefault = SigningAlgorithmSpec.create_RSASSA__PSS__SHA__256();

    public static TypeDescriptor<SigningAlgorithmSpec> _typeDescriptor() {
        return _TYPE;
    }

    public static SigningAlgorithmSpec Default() {
        return theDefault;
    }

    public static SigningAlgorithmSpec create_RSASSA__PSS__SHA__256() {
        return new SigningAlgorithmSpec_RSASSA__PSS__SHA__256();
    }

    public static SigningAlgorithmSpec create_RSASSA__PSS__SHA__384() {
        return new SigningAlgorithmSpec_RSASSA__PSS__SHA__384();
    }

    public static SigningAlgorithmSpec create_RSASSA__PSS__SHA__512() {
        return new SigningAlgorithmSpec_RSASSA__PSS__SHA__512();
    }

    public static SigningAlgorithmSpec create_RSASSA__PKCS1__V1__5__SHA__256() {
        return new SigningAlgorithmSpec_RSASSA__PKCS1__V1__5__SHA__256();
    }

    public static SigningAlgorithmSpec create_RSASSA__PKCS1__V1__5__SHA__384() {
        return new SigningAlgorithmSpec_RSASSA__PKCS1__V1__5__SHA__384();
    }

    public static SigningAlgorithmSpec create_RSASSA__PKCS1__V1__5__SHA__512() {
        return new SigningAlgorithmSpec_RSASSA__PKCS1__V1__5__SHA__512();
    }

    public static SigningAlgorithmSpec create_ECDSA__SHA__256() {
        return new SigningAlgorithmSpec_ECDSA__SHA__256();
    }

    public static SigningAlgorithmSpec create_ECDSA__SHA__384() {
        return new SigningAlgorithmSpec_ECDSA__SHA__384();
    }

    public static SigningAlgorithmSpec create_ECDSA__SHA__512() {
        return new SigningAlgorithmSpec_ECDSA__SHA__512();
    }

    public static SigningAlgorithmSpec create_SM2DSA() {
        return new SigningAlgorithmSpec_SM2DSA();
    }

    public boolean is_RSASSA__PSS__SHA__256() {
        return this instanceof SigningAlgorithmSpec_RSASSA__PSS__SHA__256;
    }

    public boolean is_RSASSA__PSS__SHA__384() {
        return this instanceof SigningAlgorithmSpec_RSASSA__PSS__SHA__384;
    }

    public boolean is_RSASSA__PSS__SHA__512() {
        return this instanceof SigningAlgorithmSpec_RSASSA__PSS__SHA__512;
    }

    public boolean is_RSASSA__PKCS1__V1__5__SHA__256() {
        return this instanceof SigningAlgorithmSpec_RSASSA__PKCS1__V1__5__SHA__256;
    }

    public boolean is_RSASSA__PKCS1__V1__5__SHA__384() {
        return this instanceof SigningAlgorithmSpec_RSASSA__PKCS1__V1__5__SHA__384;
    }

    public boolean is_RSASSA__PKCS1__V1__5__SHA__512() {
        return this instanceof SigningAlgorithmSpec_RSASSA__PKCS1__V1__5__SHA__512;
    }

    public boolean is_ECDSA__SHA__256() {
        return this instanceof SigningAlgorithmSpec_ECDSA__SHA__256;
    }

    public boolean is_ECDSA__SHA__384() {
        return this instanceof SigningAlgorithmSpec_ECDSA__SHA__384;
    }

    public boolean is_ECDSA__SHA__512() {
        return this instanceof SigningAlgorithmSpec_ECDSA__SHA__512;
    }

    public boolean is_SM2DSA() {
        return this instanceof SigningAlgorithmSpec_SM2DSA;
    }

    public static ArrayList<SigningAlgorithmSpec> AllSingletonConstructors() {
        ArrayList<SigningAlgorithmSpec> singleton_iterator = new ArrayList<SigningAlgorithmSpec>();
        singleton_iterator.add(new SigningAlgorithmSpec_RSASSA__PSS__SHA__256());
        singleton_iterator.add(new SigningAlgorithmSpec_RSASSA__PSS__SHA__384());
        singleton_iterator.add(new SigningAlgorithmSpec_RSASSA__PSS__SHA__512());
        singleton_iterator.add(new SigningAlgorithmSpec_RSASSA__PKCS1__V1__5__SHA__256());
        singleton_iterator.add(new SigningAlgorithmSpec_RSASSA__PKCS1__V1__5__SHA__384());
        singleton_iterator.add(new SigningAlgorithmSpec_RSASSA__PKCS1__V1__5__SHA__512());
        singleton_iterator.add(new SigningAlgorithmSpec_ECDSA__SHA__256());
        singleton_iterator.add(new SigningAlgorithmSpec_ECDSA__SHA__384());
        singleton_iterator.add(new SigningAlgorithmSpec_ECDSA__SHA__512());
        singleton_iterator.add(new SigningAlgorithmSpec_SM2DSA());
        return singleton_iterator;
    }
}

