/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class RSAPrivateKey {
    private final int lengthBits;
    private final ByteBuffer pem;

    protected RSAPrivateKey(BuilderImpl builder) {
        this.lengthBits = builder.lengthBits();
        this.pem = builder.pem();
    }

    public int lengthBits() {
        return this.lengthBits;
    }

    public ByteBuffer pem() {
        return this.pem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected int lengthBits;
        private boolean _lengthBitsSet = false;
        protected ByteBuffer pem;

        protected BuilderImpl() {
        }

        protected BuilderImpl(RSAPrivateKey model) {
            this.lengthBits = model.lengthBits();
            this._lengthBitsSet = true;
            this.pem = model.pem();
        }

        @Override
        public Builder lengthBits(int lengthBits) {
            this.lengthBits = lengthBits;
            this._lengthBitsSet = true;
            return this;
        }

        @Override
        public int lengthBits() {
            return this.lengthBits;
        }

        @Override
        public Builder pem(ByteBuffer pem) {
            this.pem = pem;
            return this;
        }

        @Override
        public ByteBuffer pem() {
            return this.pem;
        }

        @Override
        public RSAPrivateKey build() {
            if (!this._lengthBitsSet) {
                throw new IllegalArgumentException("Missing value for required field `lengthBits`");
            }
            if (this._lengthBitsSet && this.lengthBits() < 81) {
                throw new IllegalArgumentException("`lengthBits` must be greater than or equal to 81");
            }
            if (Objects.isNull(this.pem())) {
                throw new IllegalArgumentException("Missing value for required field `pem`");
            }
            return new RSAPrivateKey(this);
        }
    }

    public static interface Builder {
        public Builder lengthBits(int var1);

        public int lengthBits();

        public Builder pem(ByteBuffer var1);

        public ByteBuffer pem();

        public RSAPrivateKey build();
    }
}

