/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;

public class HkdfExpandInput {
    public DigestAlgorithm _digestAlgorithm;
    public DafnySequence<? extends Byte> _prk;
    public DafnySequence<? extends Byte> _info;
    public int _expectedLength;
    private static final TypeDescriptor<HkdfExpandInput> _TYPE = TypeDescriptor.referenceWithInitializer(HkdfExpandInput.class, () -> HkdfExpandInput.Default());
    private static final HkdfExpandInput theDefault = HkdfExpandInput.create(DigestAlgorithm.Default(), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), 0);

    public HkdfExpandInput(DigestAlgorithm digestAlgorithm, DafnySequence<? extends Byte> prk, DafnySequence<? extends Byte> info, int expectedLength) {
        this._digestAlgorithm = digestAlgorithm;
        this._prk = prk;
        this._info = info;
        this._expectedLength = expectedLength;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        HkdfExpandInput o = (HkdfExpandInput)other;
        return Objects.equals(this._digestAlgorithm, o._digestAlgorithm) && Objects.equals(this._prk, o._prk) && Objects.equals(this._info, o._info) && this._expectedLength == o._expectedLength;
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._digestAlgorithm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._prk);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._info);
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._expectedLength);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyPrimitivesTypes.HkdfExpandInput.HkdfExpandInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._digestAlgorithm));
        s.append(", ");
        s.append(Helpers.toString(this._prk));
        s.append(", ");
        s.append(Helpers.toString(this._info));
        s.append(", ");
        s.append(this._expectedLength);
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<HkdfExpandInput> _typeDescriptor() {
        return _TYPE;
    }

    public static HkdfExpandInput Default() {
        return theDefault;
    }

    public static HkdfExpandInput create(DigestAlgorithm digestAlgorithm, DafnySequence<? extends Byte> prk, DafnySequence<? extends Byte> info, int expectedLength) {
        return new HkdfExpandInput(digestAlgorithm, prk, info, expectedLength);
    }

    public static HkdfExpandInput create_HkdfExpandInput(DigestAlgorithm digestAlgorithm, DafnySequence<? extends Byte> prk, DafnySequence<? extends Byte> info, int expectedLength) {
        return HkdfExpandInput.create(digestAlgorithm, prk, info, expectedLength);
    }

    public boolean is_HkdfExpandInput() {
        return true;
    }

    public DigestAlgorithm dtor_digestAlgorithm() {
        return this._digestAlgorithm;
    }

    public DafnySequence<? extends Byte> dtor_prk() {
        return this._prk;
    }

    public DafnySequence<? extends Byte> dtor_info() {
        return this._info;
    }

    public int dtor_expectedLength() {
        return this._expectedLength;
    }
}

