/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.common;

import inet.ipaddr.IPAddressString;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoSettings;

public class URLDenyListChecker {
    @Generated
    private static final Logger log = LogManager.getLogger(URLDenyListChecker.class);
    private final ClusterSettings clusterSettings;

    public URLDenyListChecker(ClusterSettings clusterSettings) {
        this.clusterSettings = clusterSettings;
    }

    public URL toUrlIfNotInDenyList(String url) {
        try {
            return this.toUrlIfNotInDenyList(url, (List)this.clusterSettings.get(Ip2GeoSettings.DATASOURCE_ENDPOINT_DENYLIST));
        }
        catch (UnknownHostException e) {
            log.error("Unknown host", (Throwable)e);
            throw new IllegalArgumentException("host provided in the datasource endpoint is unknown");
        }
        catch (MalformedURLException e) {
            log.error("Malformed URL", (Throwable)e);
            throw new IllegalArgumentException("URL provided in the datasource endpoint is malformed");
        }
    }

    @SuppressForbidden(reason="Need to connect to http endpoint to read GeoIP database file")
    private URL toUrlIfNotInDenyList(String url, List<String> denyList) throws UnknownHostException, MalformedURLException {
        URL urlToReturn = new URL(url);
        if (this.isInDenyList(new IPAddressString(InetAddress.getByName(urlToReturn.getHost()).getHostAddress()), denyList)) {
            throw new IllegalArgumentException("given endpoint is blocked by deny list in cluster setting " + Ip2GeoSettings.DATASOURCE_ENDPOINT_DENYLIST.getKey());
        }
        return urlToReturn;
    }

    private boolean isInDenyList(IPAddressString url, List<String> denyList) {
        return denyList.stream().map(cidr -> new IPAddressString(cidr)).anyMatch(cidr -> cidr.contains(url));
    }
}

