/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.rest;

import com.o19s.es.ltr.action.AddFeaturesToSetAction;
import com.o19s.es.ltr.feature.FeatureValidation;
import com.o19s.es.ltr.feature.store.StoredFeature;
import com.o19s.es.ltr.rest.FeatureStoreBaseRestHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ltr.settings.LTRSettings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestStatusToXContentListener;
import org.opensearch.transport.client.OpenSearchClient;
import org.opensearch.transport.client.node.NodeClient;

public class RestAddFeatureToSet
extends FeatureStoreBaseRestHandler {
    public String getName() {
        return "Add a feature to the set of features";
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_ltr/_featureset/{name}/_addfeatures/{query}"), new RestHandler.Route(RestRequest.Method.POST, "/_ltr/{store}/_featureset/{name}/_addfeatures/{query}"), new RestHandler.Route(RestRequest.Method.POST, "/_ltr/_featureset/{name}/_addfeatures"), new RestHandler.Route(RestRequest.Method.POST, "/_ltr/{store}/_featureset/{name}/_addfeatures")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!LTRSettings.isLTRPluginEnabled()) {
            throw new IllegalStateException("LTR plugin is disabled. To enable, update ltr.plugin.enabled to true");
        }
        String store = this.indexName(request);
        String setName = request.param("name");
        String routing = request.param("routing");
        String featureQuery = null;
        List<StoredFeature> features = null;
        boolean merge = request.paramAsBoolean("merge", false);
        if (request.hasParam("query")) {
            featureQuery = request.param("query");
        }
        FeatureValidation validation = null;
        if (request.hasContentOrSourceParam()) {
            FeaturesParserState featuresParser = new FeaturesParserState();
            request.applyContentParser(featuresParser::parse);
            features = featuresParser.features;
            validation = featuresParser.validation;
        }
        if (featureQuery == null && (features == null || features.isEmpty())) {
            throw new IllegalArgumentException("features must be provided as a query for the feature store or in the body, none provided");
        }
        if (featureQuery != null && features != null && !features.isEmpty()) {
            throw new IllegalArgumentException("features must be provided as a query for the feature store or directly in the body not both");
        }
        AddFeaturesToSetAction.AddFeaturesToSetRequestBuilder builder = new AddFeaturesToSetAction.AddFeaturesToSetRequestBuilder((OpenSearchClient)client);
        ((AddFeaturesToSetAction.AddFeaturesToSetRequest)builder.request()).setStore(store);
        ((AddFeaturesToSetAction.AddFeaturesToSetRequest)builder.request()).setFeatureSet(setName);
        ((AddFeaturesToSetAction.AddFeaturesToSetRequest)builder.request()).setFeatureNameQuery(featureQuery);
        ((AddFeaturesToSetAction.AddFeaturesToSetRequest)builder.request()).setRouting(routing);
        ((AddFeaturesToSetAction.AddFeaturesToSetRequest)builder.request()).setFeatures(features);
        ((AddFeaturesToSetAction.AddFeaturesToSetRequest)builder.request()).setMerge(merge);
        ((AddFeaturesToSetAction.AddFeaturesToSetRequest)builder.request()).setValidation(validation);
        return channel -> {
            try (ThreadContext.StoredContext threadContext = client.threadPool().getThreadContext().stashContext();){
                ActionListener wrappedListener = ActionListener.runBefore((ActionListener)new RestStatusToXContentListener(channel, r -> r.getResponse().getLocation(routing)), () -> ((ThreadContext.StoredContext)threadContext).restore());
                builder.execute(wrappedListener);
            }
            catch (Exception e) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
            }
        };
    }

    static class FeaturesParserState {
        public static final ObjectParser<FeaturesParserState, Void> PARSER = new ObjectParser("features");
        private List<StoredFeature> features;
        private FeatureValidation validation;

        FeaturesParserState() {
        }

        public void parse(XContentParser parser) throws IOException {
            PARSER.parse(parser, (Object)this, null);
        }

        List<StoredFeature> getFeatures() {
            return this.features;
        }

        public void setFeatures(List<StoredFeature> features) {
            this.features = features;
        }

        public FeatureValidation getValidation() {
            return this.validation;
        }

        public void setValidation(FeatureValidation validation) {
            this.validation = validation;
        }

        static {
            PARSER.declareObjectArray(FeaturesParserState::setFeatures, (parser, context) -> StoredFeature.parse(parser), new ParseField("features", new String[0]));
            PARSER.declareObject(FeaturesParserState::setValidation, (arg_0, arg_1) -> FeatureValidation.PARSER.apply(arg_0, arg_1), new ParseField("validation", new String[0]));
        }
    }
}

