/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.subquery.rewriter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import org.opensearch.sql.legacy.rewriter.subquery.RewriterContext;
import org.opensearch.sql.legacy.rewriter.subquery.rewriter.Rewriter;

public class NestedExistsRewriter
implements Rewriter {
    private final SQLExistsExpr existsExpr;
    private final RewriterContext ctx;
    private final SQLExprTableSource from;
    private final SQLExpr where;

    public NestedExistsRewriter(SQLExistsExpr existsExpr, RewriterContext board) {
        this.existsExpr = existsExpr;
        this.ctx = board;
        MySqlSelectQueryBlock queryBlock = (MySqlSelectQueryBlock)existsExpr.getSubQuery().getQuery();
        if (!(queryBlock.getFrom() instanceof SQLExprTableSource)) {
            throw new IllegalStateException("unsupported expression in from " + String.valueOf(queryBlock.getFrom().getClass()));
        }
        this.from = (SQLExprTableSource)queryBlock.getFrom();
        this.where = queryBlock.getWhere();
    }

    @Override
    public boolean canRewrite() {
        return this.ctx.isNestedQuery(this.from);
    }

    @Override
    public void rewrite() {
        this.ctx.addJoin((SQLTableSource)this.from, SQLJoinTableSource.JoinType.COMMA);
        this.ctx.addWhere(this.rewriteExistsWhere());
    }

    private SQLExpr rewriteExistsWhere() {
        SQLBinaryOpExpr translatedWhere;
        SQLBinaryOpExpr notMissingOp = this.buildNotMissingOp();
        if (null == this.where) {
            translatedWhere = notMissingOp;
        } else if (this.where instanceof SQLBinaryOpExpr) {
            translatedWhere = this.and(notMissingOp, (SQLBinaryOpExpr)this.where);
        } else {
            throw new IllegalStateException("unsupported expression in where " + String.valueOf(this.where.getClass()));
        }
        if (this.existsExpr.isNot()) {
            SQLNotExpr sqlNotExpr = new SQLNotExpr((SQLExpr)translatedWhere);
            translatedWhere.setParent((SQLObject)sqlNotExpr);
            return sqlNotExpr;
        }
        return translatedWhere;
    }

    private SQLBinaryOpExpr buildNotMissingOp() {
        SQLBinaryOpExpr binaryOpExpr = new SQLBinaryOpExpr();
        binaryOpExpr.setLeft((SQLExpr)new SQLIdentifierExpr(this.from.getAlias()));
        binaryOpExpr.setRight((SQLExpr)new SQLIdentifierExpr("MISSING"));
        binaryOpExpr.setOperator(SQLBinaryOperator.IsNot);
        return binaryOpExpr;
    }
}

