/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor.execution;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.QueryId;
import org.opensearch.sql.executor.QueryService;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.executor.execution.QueryPlan;
import org.opensearch.sql.executor.streaming.DefaultMetadataLog;
import org.opensearch.sql.executor.streaming.MicroBatchStreamingExecution;
import org.opensearch.sql.executor.streaming.Offset;
import org.opensearch.sql.executor.streaming.StreamingSource;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalPlanNodeVisitor;
import org.opensearch.sql.planner.logical.LogicalRelation;

public class StreamingQueryPlan
extends QueryPlan {
    private static final Logger log = LogManager.getLogger(StreamingQueryPlan.class);
    private final ExecutionStrategy executionStrategy;
    private MicroBatchStreamingExecution streamingExecution;

    public StreamingQueryPlan(QueryId queryId, QueryType queryType, UnresolvedPlan plan, QueryService queryService, ResponseListener<ExecutionEngine.QueryResponse> listener, ExecutionStrategy executionStrategy) {
        super(queryId, queryType, plan, queryService, listener);
        this.executionStrategy = executionStrategy;
    }

    @Override
    public void execute() {
        try {
            LogicalPlan logicalPlan = this.queryService.analyze(this.plan, this.queryType);
            StreamingSource streamingSource = this.buildStreamingSource(logicalPlan);
            this.streamingExecution = new MicroBatchStreamingExecution(streamingSource, logicalPlan, this.queryService, new DefaultMetadataLog<Offset>(), new DefaultMetadataLog<Offset>());
            this.executionStrategy.execute(this.streamingExecution::execute);
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            this.listener.onFailure(e);
        }
        catch (InterruptedException e) {
            log.error((Object)e);
        }
    }

    private StreamingSource buildStreamingSource(LogicalPlan logicalPlan) {
        return logicalPlan.accept(new StreamingSourceBuilder(), null);
    }

    static interface ExecutionStrategy {
        public void execute(Runnable var1) throws InterruptedException;
    }

    static class StreamingSourceBuilder
    extends LogicalPlanNodeVisitor<StreamingSource, Void> {
        StreamingSourceBuilder() {
        }

        @Override
        public StreamingSource visitNode(LogicalPlan plan, Void context) {
            List<LogicalPlan> children = plan.getChild();
            if (children.isEmpty()) {
                String errorMsg = String.format("Could find relation plan, %s does not have child node.", plan.getClass().getSimpleName());
                log.error(errorMsg);
                throw new IllegalArgumentException(errorMsg);
            }
            return children.get(0).accept(this, context);
        }

        @Override
        public StreamingSource visitRelation(LogicalRelation plan, Void context) {
            try {
                return plan.getTable().asStreamingSource();
            }
            catch (UnsupportedOperationException e) {
                String errorMsg = String.format("table %s could not been used as streaming source.", plan.getRelationName());
                log.error(errorMsg);
                throw new UnsupportedOperationException(errorMsg);
            }
        }
    }

    public static class IntervalTriggerExecution
    implements ExecutionStrategy {
        private final long intervalInSeconds;

        @Override
        public void execute(Runnable runnable) throws InterruptedException {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Instant start = Instant.now();
                    runnable.run();
                    Instant end = Instant.now();
                    long took = Duration.between(start, end).toSeconds();
                    TimeUnit.SECONDS.sleep(this.intervalInSeconds > took ? this.intervalInSeconds - took : 0L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Generated
        public IntervalTriggerExecution(long intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }
    }
}

