/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.caching.CacheProvider;
import org.opensearch.timeseries.caching.TimeSeriesCache;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.ml.CheckpointDao;
import org.opensearch.timeseries.ml.IntermediateResult;
import org.opensearch.timeseries.ml.ModelColdStart;
import org.opensearch.timeseries.ml.ModelManager;
import org.opensearch.timeseries.ml.ModelState;
import org.opensearch.timeseries.ml.RealTimeInferencer;
import org.opensearch.timeseries.ml.Sample;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.model.TaskType;
import org.opensearch.timeseries.model.TimeSeriesTask;
import org.opensearch.timeseries.ratelimit.CheckpointReadWorker;
import org.opensearch.timeseries.ratelimit.CheckpointWriteWorker;
import org.opensearch.timeseries.ratelimit.ColdEntityWorker;
import org.opensearch.timeseries.ratelimit.ColdStartWorker;
import org.opensearch.timeseries.ratelimit.FeatureRequest;
import org.opensearch.timeseries.ratelimit.RateLimitedRequestWorker;
import org.opensearch.timeseries.ratelimit.RequestPriority;
import org.opensearch.timeseries.ratelimit.SaveResultStrategy;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.task.TaskManager;
import org.opensearch.timeseries.transport.EntityResultRequest;
import org.opensearch.timeseries.util.ActionListenerExecutor;

public class EntityResultProcessor<RCFModelType extends ThresholdedRandomCutForest, IndexableResultType extends IndexableResult, IntermediateResultType extends IntermediateResult<IndexableResultType>, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, CheckpointDaoType extends CheckpointDao<RCFModelType, IndexType, IndexManagementType>, CheckpointWriteWorkerType extends CheckpointWriteWorker<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType>, ModelColdStartType extends ModelColdStart<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriteWorkerType, IndexableResultType>, ModelManagerType extends ModelManager<RCFModelType, IndexableResultType, IntermediateResultType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriteWorkerType, ModelColdStartType>, CacheType extends TimeSeriesCache<RCFModelType>, SaveResultStrategyType extends SaveResultStrategy<IndexableResultType, IntermediateResultType>, TaskCacheManagerType extends TaskCacheManager, TaskTypeEnum extends TaskType, TaskClass extends TimeSeriesTask, TaskManagerType extends TaskManager<TaskCacheManagerType, TaskTypeEnum, TaskClass, IndexType, IndexManagementType>, ColdStartWorkerType extends ColdStartWorker<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriteWorkerType, ModelColdStartType, CacheType, IndexableResultType, IntermediateResultType, ModelManagerType, SaveResultStrategyType, TaskCacheManagerType, TaskTypeEnum, TaskClass, TaskManagerType>, InferencerType extends RealTimeInferencer<RCFModelType, IndexableResultType, IntermediateResultType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriteWorkerType, ModelColdStartType, ModelManagerType, SaveResultStrategyType, CacheType, TaskCacheManagerType, TaskTypeEnum, TaskClass, TaskManagerType, ColdStartWorkerType>, HCCheckpointReadWorkerType extends CheckpointReadWorker<RCFModelType, IndexableResultType, IntermediateResultType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriteWorkerType, ModelColdStartType, ModelManagerType, CacheType, SaveResultStrategyType, TaskCacheManagerType, TaskTypeEnum, TaskClass, TaskManagerType, ColdStartWorkerType, InferencerType>, ColdEntityWorkerType extends ColdEntityWorker<RCFModelType, IndexableResultType, IndexType, IndexManagementType, CheckpointDaoType, IntermediateResultType, ModelManagerType, CheckpointWriteWorkerType, ModelColdStartType, CacheType, SaveResultStrategyType, TaskCacheManagerType, TaskTypeEnum, TaskClass, TaskManagerType, ColdStartWorkerType, InferencerType, HCCheckpointReadWorkerType>> {
    private static final Logger LOG = LogManager.getLogger(EntityResultProcessor.class);
    private CacheProvider<RCFModelType, CacheType> cache;
    private HCCheckpointReadWorkerType checkpointReadQueue;
    private ColdEntityWorkerType coldEntityQueue;
    private InferencerType inferencer;
    private ThreadPool threadPool;
    private String threadPoolName;

    public EntityResultProcessor(CacheProvider<RCFModelType, CacheType> cache, HCCheckpointReadWorkerType checkpointReadQueue, ColdEntityWorkerType coldEntityQueue, InferencerType inferencer, ThreadPool threadPool, String threadPoolName) {
        this.cache = cache;
        this.checkpointReadQueue = checkpointReadQueue;
        this.coldEntityQueue = coldEntityQueue;
        this.inferencer = inferencer;
        this.threadPool = threadPool;
        this.threadPoolName = threadPoolName;
    }

    public ActionListener<Optional<? extends Config>> onGetConfig(ActionListener<AcknowledgedResponse> listener, String configId, EntityResultRequest request, Optional<Exception> prevException, AnalysisType analysisType) {
        return ActionListenerExecutor.wrap(configOptional -> {
            if (!configOptional.isPresent()) {
                listener.onFailure((Exception)new EndRunException(configId, "Config " + configId + " is not available.", false));
                return;
            }
            Config config = (Config)configOptional.get();
            if (request.getEntities() == null) {
                listener.onFailure((Exception)new EndRunException(configId, "Fail to get any entities from request.", false));
                return;
            }
            HashMap<Entity, double[]> cacheMissEntities = new HashMap<Entity, double[]>();
            for (Map.Entry<Entity, double[]> entityEntry : request.getEntities().entrySet()) {
                Optional<String> modelIdOptional;
                Entity entity = entityEntry.getKey();
                if (this.isEntityFromOldNodeMsg(entity) && config.getCategoryFields() != null && config.getCategoryFields().size() == 1) {
                    Map<String, String> attrValues = entity.getAttributes();
                    entity = Entity.createSingleAttributeEntity(config.getCategoryFields().get(0), attrValues.get(""));
                }
                if ((modelIdOptional = entity.getModelId(configId)).isEmpty()) continue;
                String modelId = modelIdOptional.get();
                double[] datapoint = entityEntry.getValue();
                ModelState entityModel = this.cache.get().get(modelId, config);
                if (entityModel == null) {
                    cacheMissEntities.put(entity, datapoint);
                    continue;
                }
                ((RealTimeInferencer)this.inferencer).process(new Sample(datapoint, Instant.ofEpochMilli(request.getStart()), Instant.ofEpochMilli(request.getEnd())), entityModel, config, request.getTaskId());
            }
            Pair<List<Entity>, List<Entity>> hotColdEntities = this.cache.get().selectUpdateCandidate(cacheMissEntities.keySet(), configId, config);
            ArrayList<FeatureRequest> hotEntityRequests = new ArrayList<FeatureRequest>();
            ArrayList<FeatureRequest> coldEntityRequests = new ArrayList<FeatureRequest>();
            for (Entity hotEntity : (List)hotColdEntities.getLeft()) {
                double[] hotEntityValue = (double[])cacheMissEntities.get(hotEntity);
                if (hotEntityValue == null) {
                    LOG.error((Message)new ParameterizedMessage("feature value should not be null: [{}]", (Object)hotEntity));
                    continue;
                }
                hotEntityRequests.add(new FeatureRequest(System.currentTimeMillis() + config.getIntervalInMilliseconds(), configId, RequestPriority.MEDIUM, hotEntityValue, request.getStart(), hotEntity, request.getTaskId()));
            }
            RequestPriority coldEntityPriority = config.isLongInterval() ? RequestPriority.MEDIUM : RequestPriority.LOW;
            for (Entity coldEntity : (List)hotColdEntities.getRight()) {
                double[] coldEntityValue = (double[])cacheMissEntities.get(coldEntity);
                if (coldEntityValue == null) {
                    LOG.error((Message)new ParameterizedMessage("feature value should not be null: [{}]", (Object)coldEntity));
                    continue;
                }
                coldEntityRequests.add(new FeatureRequest(System.currentTimeMillis() + config.getIntervalInMilliseconds(), configId, coldEntityPriority, coldEntityValue, request.getStart(), coldEntity, request.getTaskId()));
            }
            ((RateLimitedRequestWorker)this.checkpointReadQueue).putAll(hotEntityRequests);
            ((RateLimitedRequestWorker)this.coldEntityQueue).putAll(coldEntityRequests);
            if (prevException.isPresent()) {
                listener.onFailure((Exception)prevException.get());
            } else {
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }
        }, exception -> {
            LOG.error((Message)new ParameterizedMessage("fail to get entity's analysis result for config [{}]: start: [{}], end: [{}]", new Object[]{configId, request.getStart(), request.getEnd()}), (Throwable)exception);
            listener.onFailure(exception);
        }, this.threadPool.executor(this.threadPoolName));
    }

    private boolean isEntityFromOldNodeMsg(Entity categoricalValues) {
        Map<String, String> attrValues = categoricalValues.getAttributes();
        return attrValues != null && attrValues.containsKey("");
    }
}

